/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.mailbox;

import java.io.IOException;
import javax.inject.Inject;
import org.apache.james.backends.es.v7.ElasticSearchConfiguration;
import org.apache.james.backends.es.v7.ReactorElasticSearchClient;
import org.apache.james.lifecycle.api.StartUpCheck;
import org.elasticsearch.Version;
import org.elasticsearch.client.RequestOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchStartUpCheck
implements StartUpCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticSearchConfiguration.class);
    private static final Version RECOMMENDED_ES_VERSION = Version.V_7_10_2;
    private static final String VERSION_CHECKING_ERROR_MESSAGE = "Error when checking ES version";
    public static final String CHECK_NAME = "ElasticSearchStartUpCheck";
    private final ReactorElasticSearchClient client;

    @Inject
    private ElasticSearchStartUpCheck(ReactorElasticSearchClient client) {
        this.client = client;
    }

    public StartUpCheck.CheckResult check() {
        try {
            Version esVersion = Version.fromString((String)this.client.info(RequestOptions.DEFAULT).getVersion().getNumber());
            if (esVersion.isCompatible(RECOMMENDED_ES_VERSION)) {
                return StartUpCheck.CheckResult.builder().checkName(this.checkName()).resultType(StartUpCheck.ResultType.GOOD).build();
            }
            String esVersionCompatibilityWarn = String.format("ES version(%s) is not compatible with the recommendation(%s)", esVersion.toString(), RECOMMENDED_ES_VERSION.toString());
            LOGGER.warn(esVersionCompatibilityWarn);
            return StartUpCheck.CheckResult.builder().checkName(this.checkName()).resultType(StartUpCheck.ResultType.BAD).description(esVersionCompatibilityWarn).build();
        }
        catch (IOException e) {
            LOGGER.error(VERSION_CHECKING_ERROR_MESSAGE, (Throwable)e);
            return StartUpCheck.CheckResult.builder().checkName(this.checkName()).resultType(StartUpCheck.ResultType.BAD).description("Error when checking ES version: " + e.getMessage()).build();
        }
    }

    public String checkName() {
        return CHECK_NAME;
    }
}

