/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.methods;

import com.github.fge.lambdas.Throwing;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.mail.MessagingException;
import org.apache.james.core.Username;
import org.apache.james.jmap.draft.exceptions.AttachmentsNotFoundException;
import org.apache.james.jmap.draft.exceptions.InvalidDraftKeywordsException;
import org.apache.james.jmap.draft.exceptions.InvalidMailboxForCreationException;
import org.apache.james.jmap.draft.exceptions.MailboxNotOwnedException;
import org.apache.james.jmap.draft.exceptions.SizeExceededException;
import org.apache.james.jmap.draft.methods.MailboxInvalidMessageCreationException;
import org.apache.james.jmap.draft.methods.MailboxSendingNotAllowedException;
import org.apache.james.jmap.draft.methods.MessageAppender;
import org.apache.james.jmap.draft.methods.MessageSender;
import org.apache.james.jmap.draft.methods.ReferenceUpdater;
import org.apache.james.jmap.draft.methods.SetMailboxesCreationProcessor;
import org.apache.james.jmap.draft.methods.SetMessagesProcessor;
import org.apache.james.jmap.draft.methods.ValidationResult;
import org.apache.james.jmap.draft.methods.ValueWithId;
import org.apache.james.jmap.draft.model.CreationMessage;
import org.apache.james.jmap.draft.model.EnvelopeUtils;
import org.apache.james.jmap.draft.model.MessageProperties;
import org.apache.james.jmap.draft.model.SetError;
import org.apache.james.jmap.draft.model.SetMessagesError;
import org.apache.james.jmap.draft.model.SetMessagesRequest;
import org.apache.james.jmap.draft.model.SetMessagesResponse;
import org.apache.james.jmap.draft.model.message.view.MessageFullView;
import org.apache.james.jmap.draft.model.message.view.MessageFullViewFactory;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.Role;
import org.apache.james.mailbox.SystemMailboxesProvider;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.exception.OverQuotaException;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.rrt.api.CanSendFrom;
import org.apache.james.server.core.Envelope;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class SetMessagesCreationProcessor
implements SetMessagesProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(SetMailboxesCreationProcessor.class);
    private final MessageFullViewFactory messageFullViewFactory;
    private final SystemMailboxesProvider systemMailboxesProvider;
    private final MetricFactory metricFactory;
    private final MailboxManager mailboxManager;
    private final MailboxId.Factory mailboxIdFactory;
    private final MessageAppender messageAppender;
    private final MessageSender messageSender;
    private final ReferenceUpdater referenceUpdater;
    private final CanSendFrom canSendFrom;

    @Inject
    @VisibleForTesting
    SetMessagesCreationProcessor(MessageFullViewFactory messageFullViewFactory, SystemMailboxesProvider systemMailboxesProvider, MetricFactory metricFactory, MailboxManager mailboxManager, MailboxId.Factory mailboxIdFactory, MessageAppender messageAppender, MessageSender messageSender, ReferenceUpdater referenceUpdater, CanSendFrom canSendFrom) {
        this.messageFullViewFactory = messageFullViewFactory;
        this.systemMailboxesProvider = systemMailboxesProvider;
        this.metricFactory = metricFactory;
        this.mailboxManager = mailboxManager;
        this.mailboxIdFactory = mailboxIdFactory;
        this.messageAppender = messageAppender;
        this.messageSender = messageSender;
        this.referenceUpdater = referenceUpdater;
        this.canSendFrom = canSendFrom;
    }

    @Override
    public Mono<SetMessagesResponse> processReactive(SetMessagesRequest request, MailboxSession mailboxSession) {
        if (request.getCreate().isEmpty()) {
            return Mono.just((Object)SetMessagesResponse.builder().build());
        }
        return Mono.from((Publisher)this.metricFactory.decoratePublisherWithTimerMetric("JMAP-SetMessageCreationProcessor", (Publisher)Flux.fromIterable(request.getCreate()).flatMap(create -> this.handleCreate((ValueWithId.CreationMessageEntry)create, mailboxSession)).reduce(SetMessagesResponse.Builder::mergeWith).switchIfEmpty(Mono.just((Object)SetMessagesResponse.builder())).map(SetMessagesResponse.Builder::build)));
    }

    private Mono<SetMessagesResponse.Builder> handleCreate(ValueWithId.CreationMessageEntry create, MailboxSession mailboxSession) {
        ImmutableList<MailboxId> mailboxIds = this.toMailboxIds(create);
        if (mailboxIds.isEmpty()) {
            return Mono.just((Object)SetMessagesResponse.builder().notCreated(create.getCreationId(), SetError.builder().type(SetError.Type.INVALID_PROPERTIES).properties(MessageProperties.MessageProperty.mailboxIds).description("Message needs to be in at least one mailbox").build()));
        }
        return this.assertIsUserOwnerOfMailboxes((List<MailboxId>)mailboxIds, mailboxSession).then(this.performCreate(create, mailboxSession)).onErrorResume(MailboxSendingNotAllowedException.class, e -> {
            LOG.debug("{} is not allowed to send a mail using {} identity", (Object)e.getConnectedUser().asString(), e.getFromField());
            return Mono.just((Object)SetMessagesResponse.builder().notCreated(create.getCreationId(), SetError.builder().type(SetError.Type.INVALID_PROPERTIES).properties(MessageProperties.MessageProperty.from).description("Invalid 'from' field. One accepted value is " + e.getConnectedUser().asString()).build()));
        }).onErrorResume(InvalidDraftKeywordsException.class, e -> Mono.just((Object)SetMessagesResponse.builder().notCreated(create.getCreationId(), SetError.builder().type(SetError.Type.INVALID_PROPERTIES).properties(MessageProperties.MessageProperty.keywords).description(e.getMessage()).build()))).onErrorResume(SizeExceededException.class, e -> Mono.just((Object)SetMessagesResponse.builder().notCreated(create.getCreationId(), SetError.builder().type(SetError.Type.INVALID_ARGUMENTS).description(e.getMessage()).build()))).onErrorResume(AttachmentsNotFoundException.class, e -> Mono.just((Object)SetMessagesResponse.builder().notCreated(create.getCreationId(), SetMessagesError.builder().type(SetError.Type.INVALID_PROPERTIES).properties(MessageProperties.MessageProperty.attachments).attachmentsNotFound(e.getAttachmentIds()).description("Attachment not found").build()))).onErrorResume(InvalidMailboxForCreationException.class, e -> Mono.just((Object)SetMessagesResponse.builder().notCreated(create.getCreationId(), SetError.builder().type(SetError.Type.INVALID_PROPERTIES).properties(MessageProperties.MessageProperty.mailboxIds).description("Message creation is only supported in mailboxes with role Draft and Outbox").build()))).onErrorResume(MailboxInvalidMessageCreationException.class, e -> Mono.just((Object)SetMessagesResponse.builder().notCreated(create.getCreationId(), this.buildSetErrorFromValidationResult(((CreationMessage)create.getValue()).validate())))).onErrorResume(MailboxNotFoundException.class, e -> Mono.just((Object)SetMessagesResponse.builder().notCreated(create.getCreationId(), SetError.builder().type(SetError.Type.ERROR).description(e.getMessage()).build()))).onErrorResume(MailboxNotOwnedException.class, e -> Mono.just((Object)SetMessagesResponse.builder().notCreated(create.getCreationId(), SetError.builder().type(SetError.Type.ERROR).properties(MessageProperties.MessageProperty.mailboxIds).description("MailboxId invalid").build()))).onErrorResume(OverQuotaException.class, e -> Mono.just((Object)SetMessagesResponse.builder().notCreated(create.getCreationId(), SetError.builder().type(SetError.Type.MAX_QUOTA_REACHED).description(e.getMessage()).build()))).onErrorResume(MailboxException.class, e -> Mono.just((Object)SetMessagesResponse.builder().notCreated(create.getCreationId(), SetError.builder().type(SetError.Type.ERROR).description("unexpected error").build()))).onErrorResume(MessagingException.class, e -> Mono.just((Object)SetMessagesResponse.builder().notCreated(create.getCreationId(), SetError.builder().type(SetError.Type.ERROR).description("unexpected error").build()))).onErrorResume(IOException.class, e -> Mono.just((Object)SetMessagesResponse.builder().notCreated(create.getCreationId(), SetError.builder().type(SetError.Type.ERROR).description("unexpected error").build())));
    }

    private ImmutableList<MailboxId> toMailboxIds(ValueWithId.CreationMessageEntry create) {
        return (ImmutableList)((CreationMessage)create.getValue()).getMailboxIds().stream().distinct().map(arg_0 -> ((MailboxId.Factory)this.mailboxIdFactory).fromString(arg_0)).collect(ImmutableList.toImmutableList());
    }

    private Mono<SetMessagesResponse.Builder> performCreate(ValueWithId.CreationMessageEntry entry, MailboxSession session) {
        return this.isAppendToMailboxWithRole(Role.OUTBOX, (CreationMessage)entry.getValue(), session).flatMap(isAppendToMailboxWithRole -> {
            if (isAppendToMailboxWithRole.booleanValue()) {
                return this.sendMailViaOutbox(entry, session);
            }
            if (((CreationMessage)entry.getValue()).isDraft()) {
                return this.assertNoOutbox(entry, session).then(this.saveDraft(entry, session));
            }
            return this.isAppendToMailboxWithRole(Role.DRAFTS, (CreationMessage)entry.getValue(), session).handle((isAppendedToDraft, sink) -> {
                if (isAppendedToDraft.booleanValue()) {
                    sink.error((Throwable)new InvalidDraftKeywordsException("A draft message should be flagged as Draft"));
                } else {
                    sink.error((Throwable)((Object)new InvalidMailboxForCreationException("The only implemented feature is sending via outbox and draft saving")));
                }
            });
        });
    }

    private Mono<Void> assertNoOutbox(ValueWithId.CreationMessageEntry entry, MailboxSession session) {
        return this.isTargettingAMailboxWithRole(Role.OUTBOX, (CreationMessage)entry.getValue(), session).handle((targetsOutbox, sink) -> {
            if (targetsOutbox.booleanValue()) {
                sink.error((Throwable)((Object)new InvalidMailboxForCreationException("Mailbox ids can combine Outbox with other mailbox")));
            }
        });
    }

    private Mono<SetMessagesResponse.Builder> sendMailViaOutbox(ValueWithId.CreationMessageEntry entry, MailboxSession session) {
        if (!((CreationMessage)entry.getValue()).isValid()) {
            return Mono.error((Throwable)((Object)new MailboxInvalidMessageCreationException()));
        }
        return this.handleOutboxMessages(entry, session).map(created -> SetMessagesResponse.builder().created(created.getCreationId(), (MessageFullView)created.getValue()));
    }

    private Mono<SetMessagesResponse.Builder> saveDraft(ValueWithId.CreationMessageEntry entry, MailboxSession session) {
        return this.handleDraftMessages(entry, session).map(created -> SetMessagesResponse.builder().created(created.getCreationId(), (MessageFullView)created.getValue()));
    }

    @VisibleForTesting
    Mono<Void> assertIsUserOwnerOfMailboxes(List<MailboxId> mailboxIds, MailboxSession session) {
        return this.allMailboxOwned(mailboxIds, session).handle((allOwned, sink) -> {
            if (!allOwned.booleanValue()) {
                sink.error((Throwable)((Object)new MailboxNotOwnedException()));
            }
        });
    }

    private Mono<Boolean> allMailboxOwned(List<MailboxId> mailboxIds, MailboxSession session) {
        return Flux.fromIterable(mailboxIds).concatMap(id -> this.mailboxManager.getMailboxReactive(id, session)).map((Function)Throwing.function(MessageManager::getMailboxPath)).all(path -> path.belongsTo(session));
    }

    private Mono<ValueWithId.MessageWithId> handleOutboxMessages(ValueWithId.CreationMessageEntry entry, MailboxSession session) {
        return this.assertUserCanSendFrom(session.getUser(), ((CreationMessage)entry.getValue()).getFrom()).then(this.messageAppender.appendMessageInMailboxes(entry, (List<MailboxId>)this.toMailboxIds(entry), session)).flatMap(newMessage -> this.messageFullViewFactory.fromMetaDataWithContent((MessageFullViewFactory.MetaDataWithContent)newMessage).flatMap(Throwing.function(jmapMessage -> {
            Envelope envelope = EnvelopeUtils.fromMessage(jmapMessage);
            return this.messageSender.sendMessage((MessageFullViewFactory.MetaDataWithContent)newMessage, envelope, session).then(this.referenceUpdater.updateReferences((Map<String, String>)((CreationMessage)entry.getValue()).getHeaders(), session)).thenReturn((Object)new ValueWithId.MessageWithId(entry.getCreationId(), (MessageFullView)jmapMessage));
        }).sneakyThrow()));
    }

    @VisibleForTesting
    Mono<Void> assertUserCanSendFrom(Username connectedUser, Optional<CreationMessage.DraftEmailer> from) {
        return Mono.fromRunnable((Runnable)Throwing.runnable(() -> {
            Optional<Username> maybeFromUser = from.flatMap(CreationMessage.DraftEmailer::getEmail).map(Username::of);
            if (!this.canSendMailUsingIdentity(connectedUser, maybeFromUser)) {
                String allowedSender = connectedUser.asString();
                throw new MailboxSendingNotAllowedException(connectedUser, maybeFromUser);
            }
            LOG.debug("{} is allowed to send a mail using {} identity", (Object)connectedUser.asString(), (Object)from);
        }).sneakyThrow()).subscribeOn(Schedulers.elastic()).then();
    }

    private boolean canSendMailUsingIdentity(Username connectedUser, Optional<Username> maybeFromUser) {
        return maybeFromUser.filter(fromUser -> this.canSendFrom.userCanSendFrom(connectedUser, fromUser)).isPresent();
    }

    private Mono<ValueWithId.MessageWithId> handleDraftMessages(ValueWithId.CreationMessageEntry entry, MailboxSession session) {
        return this.messageAppender.appendMessageInMailboxes(entry, (List<MailboxId>)this.toMailboxIds(entry), session).flatMap(this.messageFullViewFactory::fromMetaDataWithContent).map(jmapMessage -> new ValueWithId.MessageWithId(entry.getCreationId(), (MessageFullView)jmapMessage));
    }

    private Mono<Boolean> isAppendToMailboxWithRole(Role role, CreationMessage entry, MailboxSession mailboxSession) {
        return this.getMailboxWithRole(mailboxSession, role).map(entry::isOnlyIn).switchIfEmpty(Mono.just((Object)false));
    }

    private Mono<Boolean> isTargettingAMailboxWithRole(Role role, CreationMessage entry, MailboxSession mailboxSession) {
        return this.getMailboxWithRole(mailboxSession, role).map(entry::isIn).switchIfEmpty(Mono.just((Object)false));
    }

    private Mono<MessageManager> getMailboxWithRole(MailboxSession mailboxSession, Role role) {
        return Flux.from((Publisher)this.systemMailboxesProvider.getMailboxByRole(role, mailboxSession.getUser())).next();
    }

    private SetError buildSetErrorFromValidationResult(List<ValidationResult> validationErrors) {
        return SetError.builder().type(SetError.Type.INVALID_PROPERTIES).properties(this.collectMessageProperties(validationErrors)).description(this.formatValidationErrorMessge(validationErrors)).build();
    }

    private String formatValidationErrorMessge(List<ValidationResult> validationErrors) {
        return validationErrors.stream().map(err -> err.getProperty() + ": " + err.getErrorMessage()).collect(Collectors.joining("\\n"));
    }

    private Set<MessageProperties.MessageProperty> collectMessageProperties(List<ValidationResult> validationErrors) {
        Splitter propertiesSplitter = Splitter.on((char)',').trimResults().omitEmptyStrings();
        return validationErrors.stream().flatMap(err -> propertiesSplitter.splitToList((CharSequence)err.getProperty()).stream()).flatMap(MessageProperties.MessageProperty::find).collect(Collectors.toSet());
    }
}

