/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import java.util.Optional;
import org.apache.james.core.Username;
import org.apache.james.mailbox.Authorizator;

public class FakeAuthorizator
implements Authorizator {
    private final Optional<Username> adminId;
    private final Optional<Username> delegatedUserId;

    public static FakeAuthorizator defaultReject() {
        return new FakeAuthorizator(Optional.empty(), Optional.empty());
    }

    public static FakeAuthorizator forUserAndAdmin(Username admin, Username user) {
        return new FakeAuthorizator(Optional.of(admin), Optional.of(user));
    }

    private FakeAuthorizator(Optional<Username> adminId, Optional<Username> userId) {
        this.adminId = adminId;
        this.delegatedUserId = userId;
    }

    public Authorizator.AuthorizationState canLoginAsOtherUser(Username userId, Username otherUserId) {
        if (!this.adminId.isPresent() || !this.delegatedUserId.isPresent()) {
            return Authorizator.AuthorizationState.NOT_ADMIN;
        }
        if (!this.adminId.get().equals((Object)userId)) {
            return Authorizator.AuthorizationState.NOT_ADMIN;
        }
        if (!otherUserId.equals((Object)this.delegatedUserId.get())) {
            return Authorizator.AuthorizationState.UNKNOWN_USER;
        }
        return Authorizator.AuthorizationState.ALLOWED;
    }
}

