/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.DeliverOneTimePasswordExtendedResult;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class DeliverOneTimePasswordExtendedRequest
extends ExtendedRequest {
    @NotNull
    public static final String DELIVER_OTP_REQUEST_OID = "1.3.6.1.4.1.30221.2.6.24";
    private static final byte TYPE_AUTHN_ID = -128;
    private static final byte TYPE_PASSWORD = -127;
    private static final byte TYPE_PREFERRED_DELIVERY_MECHANISM_NAMES = -94;
    private static final byte TYPE_PREFERRED_DELIVERY_MECHANISM_NAMES_AND_IDS = -93;
    private static final byte MESSAGE_SUBJECT_BER_TYPE = -124;
    private static final byte FULL_TEXT_BEFORE_OTP_BER_TYPE = -123;
    private static final byte FULL_TEXT_AFTER_OTP_BER_TYPE = -122;
    private static final byte COMPACT_TEXT_BEFORE_OTP_BER_TYPE = -121;
    private static final byte COMPACT_TEXT_AFTER_OTP_BER_TYPE = -120;
    private static final long serialVersionUID = 1259250969726758847L;
    @Nullable
    private final ASN1OctetString staticPassword;
    @NotNull
    private final List<ObjectPair<String, String>> preferredDeliveryMechanisms;
    @NotNull
    private final String authenticationID;
    @Nullable
    private final String compactTextAfterOTP;
    @Nullable
    private final String compactTextBeforeOTP;
    @Nullable
    private final String fullTextAfterOTP;
    @Nullable
    private final String fullTextBeforeOTP;
    @Nullable
    private final String messageSubject;

    public DeliverOneTimePasswordExtendedRequest(@NotNull String authenticationID, @Nullable String staticPassword, String ... preferredDeliveryMechanisms) {
        this(authenticationID, staticPassword, StaticUtils.toList(preferredDeliveryMechanisms), new Control[0]);
    }

    public DeliverOneTimePasswordExtendedRequest(@NotNull String authenticationID, @Nullable byte[] staticPassword, String ... preferredDeliveryMechanisms) {
        this(authenticationID, staticPassword, StaticUtils.toList(preferredDeliveryMechanisms), new Control[0]);
    }

    public DeliverOneTimePasswordExtendedRequest(@NotNull String authenticationID, @Nullable String staticPassword, @Nullable List<String> preferredDeliveryMechanisms, Control ... controls) {
        this(authenticationID, staticPassword == null ? null : new ASN1OctetString(-127, staticPassword), preferredDeliveryMechanisms, controls);
    }

    public DeliverOneTimePasswordExtendedRequest(@NotNull String authenticationID, @Nullable byte[] staticPassword, @Nullable List<String> preferredDeliveryMechanisms, Control ... controls) {
        this(authenticationID, staticPassword == null ? null : new ASN1OctetString(-127, staticPassword), preferredDeliveryMechanisms, controls);
    }

    private DeliverOneTimePasswordExtendedRequest(@NotNull String authenticationID, @Nullable ASN1OctetString staticPassword, @Nullable List<String> preferredDeliveryMechanisms, Control ... controls) {
        super(DELIVER_OTP_REQUEST_OID, DeliverOneTimePasswordExtendedRequest.encodeValue(authenticationID, staticPassword, preferredDeliveryMechanisms), controls);
        this.authenticationID = authenticationID;
        this.staticPassword = staticPassword;
        if (preferredDeliveryMechanisms == null || preferredDeliveryMechanisms.isEmpty()) {
            this.preferredDeliveryMechanisms = Collections.emptyList();
        } else {
            ArrayList<ObjectPair<String, Object>> l = new ArrayList<ObjectPair<String, Object>>(preferredDeliveryMechanisms.size());
            for (String s : preferredDeliveryMechanisms) {
                l.add(new ObjectPair<String, Object>(s, null));
            }
            this.preferredDeliveryMechanisms = Collections.unmodifiableList(l);
        }
        this.messageSubject = null;
        this.fullTextBeforeOTP = null;
        this.fullTextAfterOTP = null;
        this.compactTextBeforeOTP = null;
        this.compactTextAfterOTP = null;
    }

    public DeliverOneTimePasswordExtendedRequest(@NotNull String authenticationID, @Nullable String staticPassword, @Nullable String messageSubject, @Nullable String fullTextBeforeOTP, @Nullable String fullTextAfterOTP, @Nullable String compactTextBeforeOTP, @Nullable String compactTextAfterOTP, @Nullable List<ObjectPair<String, String>> preferredDeliveryMechanisms, Control ... controls) {
        this(authenticationID, staticPassword == null ? null : new ASN1OctetString(-127, staticPassword), messageSubject, fullTextBeforeOTP, fullTextAfterOTP, compactTextBeforeOTP, compactTextAfterOTP, preferredDeliveryMechanisms, controls);
    }

    public DeliverOneTimePasswordExtendedRequest(@NotNull String authenticationID, @Nullable byte[] staticPassword, @Nullable String messageSubject, @Nullable String fullTextBeforeOTP, @Nullable String fullTextAfterOTP, @Nullable String compactTextBeforeOTP, @Nullable String compactTextAfterOTP, @Nullable List<ObjectPair<String, String>> preferredDeliveryMechanisms, Control ... controls) {
        this(authenticationID, staticPassword == null ? null : new ASN1OctetString(-127, staticPassword), messageSubject, fullTextBeforeOTP, fullTextAfterOTP, compactTextBeforeOTP, compactTextAfterOTP, preferredDeliveryMechanisms, controls);
    }

    private DeliverOneTimePasswordExtendedRequest(@NotNull String authenticationID, @Nullable ASN1OctetString staticPassword, @Nullable String messageSubject, @Nullable String fullTextBeforeOTP, @Nullable String fullTextAfterOTP, @Nullable String compactTextBeforeOTP, @Nullable String compactTextAfterOTP, @Nullable List<ObjectPair<String, String>> preferredDeliveryMechanisms, Control ... controls) {
        super(DELIVER_OTP_REQUEST_OID, DeliverOneTimePasswordExtendedRequest.encodeValue(authenticationID, staticPassword, messageSubject, fullTextBeforeOTP, fullTextAfterOTP, compactTextBeforeOTP, compactTextAfterOTP, preferredDeliveryMechanisms), controls);
        this.authenticationID = authenticationID;
        this.staticPassword = staticPassword;
        this.messageSubject = messageSubject;
        this.fullTextBeforeOTP = fullTextBeforeOTP;
        this.fullTextAfterOTP = fullTextAfterOTP;
        this.compactTextBeforeOTP = compactTextBeforeOTP;
        this.compactTextAfterOTP = compactTextAfterOTP;
        this.preferredDeliveryMechanisms = preferredDeliveryMechanisms == null || preferredDeliveryMechanisms.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(preferredDeliveryMechanisms);
    }

    public DeliverOneTimePasswordExtendedRequest(@NotNull ExtendedRequest request) throws LDAPException {
        super(request);
        ASN1OctetString value = request.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_DELIVER_OTP_REQ_NO_VALUE.get());
        }
        ASN1OctetString password = null;
        String authnID = null;
        String subject = null;
        String fullBefore = null;
        String fullAfter = null;
        String compactBefore = null;
        String compactAfter = null;
        ArrayList<ObjectPair<String, Object>> pdmList = new ArrayList<ObjectPair<String, Object>>(10);
        try {
            block14: for (ASN1Element e : ASN1Sequence.decodeAsSequence(value.getValue()).elements()) {
                switch (e.getType()) {
                    case -128: {
                        authnID = ASN1OctetString.decodeAsOctetString(e).stringValue();
                        continue block14;
                    }
                    case -127: {
                        password = ASN1OctetString.decodeAsOctetString(e);
                        continue block14;
                    }
                    case -94: {
                        ASN1Element[] mechNameElements;
                        for (ASN1Element mechElement : mechNameElements = ASN1Sequence.decodeAsSequence(e).elements()) {
                            pdmList.add(new ObjectPair<String, Object>(ASN1OctetString.decodeAsOctetString(mechElement).stringValue(), null));
                        }
                        continue block14;
                    }
                    case -93: {
                        ASN1Element[] pdmElements;
                        for (ASN1Element pdmElement : pdmElements = ASN1Sequence.decodeAsSequence(e).elements()) {
                            ASN1Element[] mechElements = ASN1Sequence.decodeAsSequence(pdmElement).elements();
                            String mech = ASN1OctetString.decodeAsOctetString(mechElements[0]).stringValue();
                            String recipientID = mechElements.length > 1 ? ASN1OctetString.decodeAsOctetString(mechElements[1]).stringValue() : null;
                            pdmList.add(new ObjectPair<String, String>(mech, recipientID));
                        }
                        continue block14;
                    }
                    case -124: {
                        subject = ASN1OctetString.decodeAsOctetString(e).stringValue();
                        continue block14;
                    }
                    case -123: {
                        fullBefore = ASN1OctetString.decodeAsOctetString(e).stringValue();
                        continue block14;
                    }
                    case -122: {
                        fullAfter = ASN1OctetString.decodeAsOctetString(e).stringValue();
                        continue block14;
                    }
                    case -121: {
                        compactBefore = ASN1OctetString.decodeAsOctetString(e).stringValue();
                        continue block14;
                    }
                    case -120: {
                        compactAfter = ASN1OctetString.decodeAsOctetString(e).stringValue();
                        continue block14;
                    }
                    default: {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_DELIVER_OTP_REQ_UNEXPECTED_ELEMENT_TYPE.get(StaticUtils.toHex(e.getType())));
                    }
                }
            }
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_DELIVER_OTP_REQ_ERROR_PARSING_VALUE.get(StaticUtils.getExceptionMessage(e)), e);
        }
        if (authnID == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_DELIVER_OTP_REQ_NO_AUTHN_ID.get());
        }
        this.authenticationID = authnID;
        this.staticPassword = password;
        this.messageSubject = subject;
        this.fullTextBeforeOTP = fullBefore;
        this.fullTextAfterOTP = fullAfter;
        this.compactTextBeforeOTP = compactBefore;
        this.compactTextAfterOTP = compactAfter;
        this.preferredDeliveryMechanisms = pdmList == null || pdmList.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(pdmList);
    }

    @NotNull
    private static ASN1OctetString encodeValue(@NotNull String authenticationID, @Nullable ASN1OctetString staticPassword, @Nullable List<String> preferredDeliveryMechanisms) {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(3);
        elements.add(new ASN1OctetString(-128, authenticationID));
        if (staticPassword != null) {
            elements.add(staticPassword);
        }
        if (preferredDeliveryMechanisms != null && !preferredDeliveryMechanisms.isEmpty()) {
            ArrayList<ASN1OctetString> dmElements = new ArrayList<ASN1OctetString>(preferredDeliveryMechanisms.size());
            for (String s : preferredDeliveryMechanisms) {
                dmElements.add(new ASN1OctetString(s));
            }
            elements.add(new ASN1Sequence(-94, dmElements));
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    @NotNull
    private static ASN1OctetString encodeValue(@NotNull String authenticationID, @Nullable ASN1OctetString staticPassword, @Nullable String messageSubject, @Nullable String fullTextBeforeOTP, @Nullable String fullTextAfterOTP, @Nullable String compactTextBeforeOTP, @Nullable String compactTextAfterOTP, @Nullable List<ObjectPair<String, String>> preferredDeliveryMechanisms) {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(8);
        elements.add(new ASN1OctetString(-128, authenticationID));
        if (staticPassword != null) {
            elements.add(staticPassword);
        }
        if (messageSubject != null) {
            elements.add(new ASN1OctetString(-124, messageSubject));
        }
        if (fullTextBeforeOTP != null) {
            elements.add(new ASN1OctetString(-123, fullTextBeforeOTP));
        }
        if (fullTextAfterOTP != null) {
            elements.add(new ASN1OctetString(-122, fullTextAfterOTP));
        }
        if (compactTextBeforeOTP != null) {
            elements.add(new ASN1OctetString(-121, compactTextBeforeOTP));
        }
        if (compactTextAfterOTP != null) {
            elements.add(new ASN1OctetString(-120, compactTextAfterOTP));
        }
        if (preferredDeliveryMechanisms != null && !preferredDeliveryMechanisms.isEmpty()) {
            ArrayList<ASN1Sequence> pdmElements = new ArrayList<ASN1Sequence>(preferredDeliveryMechanisms.size());
            for (ObjectPair<String, String> p : preferredDeliveryMechanisms) {
                if (p.getSecond() == null) {
                    pdmElements.add(new ASN1Sequence(new ASN1OctetString(p.getFirst())));
                    continue;
                }
                pdmElements.add(new ASN1Sequence(new ASN1OctetString(p.getFirst()), new ASN1OctetString(p.getSecond())));
            }
            elements.add(new ASN1Sequence(-93, pdmElements));
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    @NotNull
    public String getAuthenticationID() {
        return this.authenticationID;
    }

    @Nullable
    public ASN1OctetString getStaticPassword() {
        return this.staticPassword;
    }

    @Nullable
    public List<String> getPreferredDeliveryMechanisms() {
        if (this.preferredDeliveryMechanisms.isEmpty()) {
            return null;
        }
        LinkedHashSet<String> s = new LinkedHashSet<String>(StaticUtils.computeMapCapacity(this.preferredDeliveryMechanisms.size()));
        for (ObjectPair<String, String> p : this.preferredDeliveryMechanisms) {
            s.add(p.getFirst());
        }
        return Collections.unmodifiableList(new ArrayList(s));
    }

    @NotNull
    public List<ObjectPair<String, String>> getPreferredDeliveryMechanismNamesAndIDs() {
        return this.preferredDeliveryMechanisms;
    }

    @Nullable
    public String getMessageSubject() {
        return this.messageSubject;
    }

    @Nullable
    public String getFullTextBeforeOTP() {
        return this.fullTextBeforeOTP;
    }

    @Nullable
    public String getFullTextAfterOTP() {
        return this.fullTextAfterOTP;
    }

    @Nullable
    public String getCompactTextBeforeOTP() {
        return this.compactTextBeforeOTP;
    }

    @Nullable
    public String getCompactTextAfterOTP() {
        return this.compactTextAfterOTP;
    }

    @Override
    @NotNull
    public DeliverOneTimePasswordExtendedResult process(@NotNull LDAPConnection connection, int depth) throws LDAPException {
        ExtendedResult extendedResponse = super.process(connection, depth);
        return new DeliverOneTimePasswordExtendedResult(extendedResponse);
    }

    @Override
    @NotNull
    public DeliverOneTimePasswordExtendedRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    @Override
    @NotNull
    public DeliverOneTimePasswordExtendedRequest duplicate(@Nullable Control[] controls) {
        DeliverOneTimePasswordExtendedRequest r = new DeliverOneTimePasswordExtendedRequest(this.authenticationID, this.staticPassword, this.messageSubject, this.fullTextBeforeOTP, this.fullTextAfterOTP, this.compactTextBeforeOTP, this.compactTextAfterOTP, this.preferredDeliveryMechanisms, controls);
        r.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
        return r;
    }

    @Override
    @NotNull
    public String getExtendedRequestName() {
        return ExtOpMessages.INFO_DELIVER_OTP_REQ_NAME.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        Control[] controls;
        buffer.append("DeliverOneTimePasswordExtendedRequest(authenticationID=");
        buffer.append(this.authenticationID);
        if (this.messageSubject != null) {
            buffer.append(", messageSubject='");
            buffer.append(this.messageSubject);
            buffer.append('\'');
        }
        if (this.fullTextBeforeOTP != null) {
            buffer.append(", fullTextBeforeOTP='");
            buffer.append(this.fullTextBeforeOTP);
            buffer.append('\'');
        }
        if (this.fullTextAfterOTP != null) {
            buffer.append(", fullTextAfterOTP='");
            buffer.append(this.fullTextAfterOTP);
            buffer.append('\'');
        }
        if (this.compactTextBeforeOTP != null) {
            buffer.append(", compactTextBeforeOTP='");
            buffer.append(this.compactTextBeforeOTP);
            buffer.append('\'');
        }
        if (this.compactTextAfterOTP != null) {
            buffer.append(", compactTextAfterOTP='");
            buffer.append(this.compactTextAfterOTP);
            buffer.append('\'');
        }
        if (this.preferredDeliveryMechanisms != null) {
            buffer.append(", preferredDeliveryMechanisms={");
            Iterator<ObjectPair<String, String>> iterator = this.preferredDeliveryMechanisms.iterator();
            while (iterator.hasNext()) {
                ObjectPair<String, String> p = iterator.next();
                buffer.append('\'');
                buffer.append(p.getFirst());
                if (p.getSecond() != null) {
                    buffer.append('(');
                    buffer.append(p.getSecond());
                    buffer.append(')');
                }
                buffer.append('\'');
                if (!iterator.hasNext()) continue;
                buffer.append(',');
            }
        }
        if ((controls = this.getControls()).length > 0) {
            buffer.append(", controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

