/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tools;

import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.unboundidds.tools.ParallelUpdate;
import com.unboundid.ldif.LDIFChangeRecord;
import com.unboundid.ldif.LDIFDeleteChangeRecord;
import com.unboundid.ldif.LDIFModifyDNChangeRecord;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

final class ParallelUpdateOperationQueue {
    private boolean endOfLDIF;
    @NotNull
    private final HashSet<DN> activeChanges;
    private final int capacity;
    private int size;
    @NotNull
    private final LinkedList<LDIFChangeRecord> opQueue;
    @NotNull
    private final Object queueLock;
    @NotNull
    private final ParallelUpdate parallelUpdate;

    ParallelUpdateOperationQueue(@NotNull ParallelUpdate parallelUpdate, int numThreads, int capacity) {
        this.parallelUpdate = parallelUpdate;
        this.capacity = capacity;
        this.endOfLDIF = false;
        this.activeChanges = new HashSet(numThreads);
        this.opQueue = new LinkedList();
        this.queueLock = new Object();
        this.size = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addChangeRecord(@NotNull LDIFChangeRecord changeRecord) throws InterruptedException {
        try {
            changeRecord.getParsedDN();
        }
        catch (LDAPException e) {
            Debug.debugException(e);
            this.parallelUpdate.reject(changeRecord, e);
            return;
        }
        Object object = this.queueLock;
        synchronized (object) {
            while (this.size >= this.capacity) {
                this.queueLock.wait(1000L);
            }
            this.opQueue.add(changeRecord);
            ++this.size;
            this.queueLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    LDIFChangeRecord getChangeRecord(DN ... completedDNs) {
        Object object = this.queueLock;
        synchronized (object) {
            for (DN dn : completedDNs) {
                this.activeChanges.remove(dn);
            }
            while (!this.endOfLDIF || !this.opQueue.isEmpty()) {
                if (this.opQueue.isEmpty()) {
                    try {
                        this.queueLock.wait(1000L);
                    }
                    catch (InterruptedException e) {
                        Debug.debugException(e);
                    }
                    continue;
                }
                Iterator iterator = this.opQueue.iterator();
                block13: while (iterator.hasNext()) {
                    DN targetDN;
                    LDIFChangeRecord r = (LDIFChangeRecord)iterator.next();
                    try {
                        targetDN = r.getParsedDN();
                    }
                    catch (LDAPException e) {
                        this.parallelUpdate.reject(r, e);
                        iterator.remove();
                        --this.size;
                        continue;
                    }
                    if (!this.activeChanges.isEmpty()) {
                        for (DN activeDN : this.activeChanges) {
                            if (!activeDN.isAncestorOf(targetDN, true)) continue;
                            continue block13;
                        }
                        if (r instanceof LDIFDeleteChangeRecord) {
                            for (DN activeDN : this.activeChanges) {
                                if (!activeDN.isDescendantOf(targetDN, false)) continue;
                                continue block13;
                            }
                        } else if (r instanceof LDIFModifyDNChangeRecord) {
                            DN newDN;
                            LDIFModifyDNChangeRecord modDNRecord = (LDIFModifyDNChangeRecord)r;
                            try {
                                newDN = modDNRecord.getNewDN();
                            }
                            catch (LDAPException e) {
                                this.parallelUpdate.reject(r, e);
                                iterator.remove();
                                --this.size;
                                continue;
                            }
                            for (DN activeDN : this.activeChanges) {
                                if (!activeDN.isDescendantOf(targetDN, false) && !activeDN.isAncestorOf(newDN, true) && !activeDN.isDescendantOf(newDN, false)) continue;
                                continue block13;
                            }
                            this.activeChanges.add(newDN);
                        }
                    }
                    this.activeChanges.add(targetDN);
                    iterator.remove();
                    --this.size;
                    this.queueLock.notifyAll();
                    return r;
                }
                try {
                    this.queueLock.wait(1000L);
                }
                catch (InterruptedException e) {
                    Debug.debugException(e);
                }
            }
        }
        return null;
    }

    public void waitUntilIdle() {
        Object object = this.queueLock;
        synchronized (object) {
            while (true) {
                if (this.opQueue.isEmpty() && this.activeChanges.isEmpty()) {
                    return;
                }
                try {
                    this.queueLock.wait(1000L);
                }
                catch (InterruptedException e) {
                    Debug.debugException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEndOfLDIF() {
        Object object = this.queueLock;
        synchronized (object) {
            this.endOfLDIF = true;
            this.queueLock.notifyAll();
        }
    }
}

