/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import com.github.fge.lambdas.Throwing;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.core.quota.QuotaCountUsage;
import org.apache.james.core.quota.QuotaSizeUsage;
import org.apache.james.events.Event;
import org.apache.james.events.EventBus;
import org.apache.james.events.RegistrationKey;
import org.apache.james.mailbox.MailboxAnnotationManager;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.MetadataWithMailboxId;
import org.apache.james.mailbox.SessionProvider;
import org.apache.james.mailbox.events.MailboxIdRegistrationKey;
import org.apache.james.mailbox.exception.InboxAlreadyCreated;
import org.apache.james.mailbox.exception.InsufficientRightsException;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxExistsException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.exception.SubscriptionException;
import org.apache.james.mailbox.exception.UnsupportedRightException;
import org.apache.james.mailbox.extension.PreDeletionHook;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxAnnotation;
import org.apache.james.mailbox.model.MailboxAnnotationKey;
import org.apache.james.mailbox.model.MailboxCounters;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxMetaData;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.MultimailboxesSearchQuery;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.model.ThreadId;
import org.apache.james.mailbox.model.UidValidity;
import org.apache.james.mailbox.model.search.MailboxNameExpression;
import org.apache.james.mailbox.model.search.MailboxQuery;
import org.apache.james.mailbox.model.search.PrefixedWildcard;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.mailbox.store.MailboxManagerConfiguration;
import org.apache.james.mailbox.store.MailboxReactorUtils;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.MessageFactory;
import org.apache.james.mailbox.store.MessageStorer;
import org.apache.james.mailbox.store.PreDeletionHooks;
import org.apache.james.mailbox.store.StoreMessageManager;
import org.apache.james.mailbox.store.StoreRightManager;
import org.apache.james.mailbox.store.event.EventFactory;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.ThreadIdGuessingAlgorithm;
import org.apache.james.mailbox.store.mail.model.impl.MessageParser;
import org.apache.james.mailbox.store.quota.QuotaComponents;
import org.apache.james.mailbox.store.search.MessageSearchIndex;
import org.apache.james.mailbox.store.user.SubscriptionMapper;
import org.apache.james.mailbox.store.user.model.Subscription;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;
import reactor.util.retry.RetryBackoffSpec;

public class StoreMailboxManager
implements MailboxManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(StoreMailboxManager.class);
    public static final char SQL_WILDCARD_CHAR = '%';
    public static final EnumSet<MailboxManager.MessageCapabilities> DEFAULT_NO_MESSAGE_CAPABILITIES = EnumSet.noneOf(MailboxManager.MessageCapabilities.class);
    public static final int MAX_ATTEMPTS = 3;
    public static final Duration MIN_BACKOFF = Duration.ofMillis(100L);
    public static final RetryBackoffSpec RETRY_BACKOFF_SPEC = Retry.backoff((long)3L, (Duration)MIN_BACKOFF);
    private static final int LOW_CONCURRENCY = 2;
    private final StoreRightManager storeRightManager;
    private final EventBus eventBus;
    private final MailboxSessionMapperFactory mailboxSessionMapperFactory;
    private final MailboxAnnotationManager annotationManager;
    private final MailboxPathLocker locker;
    private final MessageParser messageParser;
    private final MessageId.Factory messageIdFactory;
    private final SessionProvider sessionProvider;
    private final QuotaManager quotaManager;
    private final QuotaRootResolver quotaRootResolver;
    private final QuotaComponents quotaComponents;
    private final MessageSearchIndex index;
    private final PreDeletionHooks preDeletionHooks;
    protected final MailboxManagerConfiguration configuration;
    private final ThreadIdGuessingAlgorithm threadIdGuessingAlgorithm;

    @Inject
    public StoreMailboxManager(MailboxSessionMapperFactory mailboxSessionMapperFactory, SessionProvider sessionProvider, MailboxPathLocker locker, MessageParser messageParser, MessageId.Factory messageIdFactory, MailboxAnnotationManager annotationManager, EventBus eventBus, StoreRightManager storeRightManager, QuotaComponents quotaComponents, MessageSearchIndex searchIndex, MailboxManagerConfiguration configuration, PreDeletionHooks preDeletionHooks, ThreadIdGuessingAlgorithm threadIdGuessingAlgorithm) {
        Preconditions.checkNotNull((Object)eventBus);
        Preconditions.checkNotNull((Object)mailboxSessionMapperFactory);
        this.annotationManager = annotationManager;
        this.sessionProvider = sessionProvider;
        this.locker = locker;
        this.mailboxSessionMapperFactory = mailboxSessionMapperFactory;
        this.messageParser = messageParser;
        this.messageIdFactory = messageIdFactory;
        this.eventBus = eventBus;
        this.storeRightManager = storeRightManager;
        this.quotaRootResolver = quotaComponents.getQuotaRootResolver();
        this.quotaManager = quotaComponents.getQuotaManager();
        this.quotaComponents = quotaComponents;
        this.index = searchIndex;
        this.configuration = configuration;
        this.preDeletionHooks = preDeletionHooks;
        this.threadIdGuessingAlgorithm = threadIdGuessingAlgorithm;
    }

    public QuotaComponents getQuotaComponents() {
        return this.quotaComponents;
    }

    public MessageId.Factory getMessageIdFactory() {
        return this.messageIdFactory;
    }

    public SessionProvider getSessionProvider() {
        return this.sessionProvider;
    }

    public EnumSet<MailboxManager.MailboxCapabilities> getSupportedMailboxCapabilities() {
        return EnumSet.noneOf(MailboxManager.MailboxCapabilities.class);
    }

    public EnumSet<MailboxManager.MessageCapabilities> getSupportedMessageCapabilities() {
        return DEFAULT_NO_MESSAGE_CAPABILITIES;
    }

    public EnumSet<MailboxManager.SearchCapabilities> getSupportedSearchCapabilities() {
        return this.index.getSupportedCapabilities(this.getSupportedMessageCapabilities());
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    protected MessageSearchIndex getMessageSearchIndex() {
        return this.index;
    }

    public MailboxSessionMapperFactory getMapperFactory() {
        return this.mailboxSessionMapperFactory;
    }

    protected MailboxPathLocker getLocker() {
        return this.locker;
    }

    protected StoreRightManager getStoreRightManager() {
        return this.storeRightManager;
    }

    protected MessageParser getMessageParser() {
        return this.messageParser;
    }

    protected PreDeletionHooks getPreDeletionHooks() {
        return this.preDeletionHooks;
    }

    public ThreadIdGuessingAlgorithm getThreadIdGuessingAlgorithm() {
        return this.threadIdGuessingAlgorithm;
    }

    public MailboxSession createSystemSession(Username userName) {
        return this.sessionProvider.createSystemSession(userName);
    }

    public char getDelimiter() {
        return this.sessionProvider.getDelimiter();
    }

    public MailboxSession login(Username userid, String passwd) throws MailboxException {
        return this.sessionProvider.login(userid, passwd);
    }

    public MailboxSession loginAsOtherUser(Username adminUserid, String passwd, Username otherUserId) throws MailboxException {
        return this.sessionProvider.loginAsOtherUser(adminUserid, passwd, otherUserId);
    }

    public void logout(MailboxSession session) {
        this.sessionProvider.logout(session);
    }

    protected StoreMessageManager createMessageManager(Mailbox mailbox, MailboxSession session) throws MailboxException {
        return new StoreMessageManager(DEFAULT_NO_MESSAGE_CAPABILITIES, this.getMapperFactory(), this.getMessageSearchIndex(), this.getEventBus(), this.getLocker(), mailbox, this.quotaManager, this.getQuotaComponents().getQuotaRootResolver(), this.configuration.getBatchSizes(), this.getStoreRightManager(), this.preDeletionHooks, new MessageStorer.WithoutAttachment(this.mailboxSessionMapperFactory, this.messageIdFactory, new MessageFactory.StoreMessageFactory(), this.threadIdGuessingAlgorithm));
    }

    public MessageManager getMailbox(MailboxPath mailboxPath, MailboxSession session) throws MailboxException {
        return MailboxReactorUtils.block(this.getMailboxReactive(mailboxPath, session));
    }

    public Mono<MessageManager> getMailboxReactive(MailboxPath mailboxPath, MailboxSession session) {
        MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        return mapper.findMailboxByPath(mailboxPath).map(Throwing.function(mailboxRow -> {
            if (!this.assertUserHasAccessTo((Mailbox)mailboxRow, session)) {
                LOGGER.info("Mailbox '{}' does not belong to user '{}' but to '{}'", new Object[]{mailboxPath, session.getUser(), mailboxRow.getUser()});
                throw new MailboxNotFoundException(mailboxPath);
            }
            LOGGER.debug("Loaded mailbox {}", (Object)mailboxPath);
            return this.createMessageManager((Mailbox)mailboxRow, session);
        }).sneakyThrow()).switchIfEmpty(Mono.fromCallable(() -> {
            LOGGER.info("Mailbox '{}' not found.", (Object)mailboxPath);
            throw new MailboxNotFoundException(mailboxPath);
        }));
    }

    public MessageManager getMailbox(MailboxId mailboxId, MailboxSession session) throws MailboxException {
        return MailboxReactorUtils.block(this.getMailboxReactive(mailboxId, session));
    }

    public Publisher<MessageManager> getMailboxReactive(MailboxId mailboxId, MailboxSession session) {
        MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        return mapper.findMailboxById(mailboxId).map(Throwing.function(mailboxRow -> {
            if (!this.assertUserHasAccessTo((Mailbox)mailboxRow, session)) {
                LOGGER.info("Mailbox '{} {}' does not belong to user '{}' but to '{}'", new Object[]{mailboxRow.getMailboxId().serialize(), mailboxRow.generateAssociatedPath(), session.getUser(), mailboxRow.getUser()});
                throw new MailboxNotFoundException(mailboxId);
            }
            LOGGER.debug("Loaded mailbox {} {}", (Object)mailboxRow.getMailboxId().serialize(), (Object)mailboxRow.generateAssociatedPath());
            return this.createMessageManager((Mailbox)mailboxRow, session);
        }).sneakyThrow());
    }

    private boolean assertUserHasAccessTo(Mailbox mailbox, MailboxSession session) {
        return this.belongsToCurrentUser(mailbox, session) || this.userHasLookupRightsOn(mailbox, session);
    }

    private boolean belongsToCurrentUser(Mailbox mailbox, MailboxSession session) {
        return mailbox.generateAssociatedPath().belongsTo(session);
    }

    private boolean userHasLookupRightsOn(Mailbox mailbox, MailboxSession session) {
        return this.storeRightManager.hasRight(mailbox, MailboxACL.Right.Lookup, session);
    }

    public Optional<MailboxId> createMailbox(MailboxPath mailboxPath, MailboxSession mailboxSession) throws MailboxException {
        LOGGER.debug("createMailbox {}", (Object)mailboxPath);
        this.assertMailboxPathBelongToUser(mailboxSession, mailboxPath);
        if (mailboxPath.getName().isEmpty()) {
            LOGGER.warn("Ignoring mailbox with empty name");
        } else {
            MailboxPath sanitizedMailboxPath = mailboxPath.sanitize(mailboxSession.getPathDelimiter());
            sanitizedMailboxPath.assertAcceptable(mailboxSession.getPathDelimiter());
            if (MailboxReactorUtils.block(this.mailboxExists(sanitizedMailboxPath, mailboxSession)).booleanValue()) {
                throw new MailboxExistsException(sanitizedMailboxPath.asString());
            }
            List<MailboxId> mailboxIds = this.createMailboxesForPath(mailboxSession, sanitizedMailboxPath);
            if (!mailboxIds.isEmpty()) {
                return Optional.ofNullable((MailboxId)Iterables.getLast(mailboxIds));
            }
        }
        return Optional.empty();
    }

    private List<MailboxId> createMailboxesForPath(MailboxSession mailboxSession, MailboxPath sanitizedMailboxPath) {
        List intermediatePaths = sanitizedMailboxPath.getHierarchyLevels(this.getDelimiter());
        boolean isRootPath = intermediatePaths.size() == 1;
        return (List)intermediatePaths.stream().flatMap(Throwing.function(mailboxPath -> this.manageMailboxCreation(mailboxSession, isRootPath, (MailboxPath)mailboxPath)).sneakyThrow()).collect(ImmutableList.toImmutableList());
    }

    private Stream<MailboxId> manageMailboxCreation(MailboxSession mailboxSession, boolean isRootPath, MailboxPath mailboxPath) throws MailboxException {
        if (mailboxPath.isInbox()) {
            if (((Boolean)MailboxReactorUtils.block(this.hasInbox(mailboxSession))).booleanValue()) {
                return this.duplicatedINBOXCreation(isRootPath, mailboxPath);
            }
            return this.performConcurrentMailboxCreation(mailboxSession, MailboxPath.inbox((MailboxSession)mailboxSession)).stream();
        }
        return this.performConcurrentMailboxCreation(mailboxSession, mailboxPath).stream();
    }

    private Stream<MailboxId> duplicatedINBOXCreation(boolean isRootPath, MailboxPath mailbox) throws InboxAlreadyCreated {
        if (isRootPath) {
            throw new InboxAlreadyCreated(mailbox.getName());
        }
        return Stream.empty();
    }

    private List<MailboxId> performConcurrentMailboxCreation(MailboxSession mailboxSession, MailboxPath mailboxPath) throws MailboxException {
        ArrayList<MailboxId> mailboxIds = new ArrayList<MailboxId>();
        MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(mailboxSession);
        this.locker.executeWithLock(mailboxPath, () -> (Void)MailboxReactorUtils.block(mapper.executeReactive(mapper.create(mailboxPath, UidValidity.generate()).doOnNext(mailbox -> mailboxIds.add(mailbox.getMailboxId())).flatMap(mailbox -> this.eventBus.dispatch((Event)((EventFactory.MailboxAddedFinalStage)((EventFactory.RequireMailbox)((EventFactory.RequireSession)EventFactory.mailboxAdded().randomEventId()).mailboxSession(mailboxSession)).mailbox((Mailbox)mailbox)).build(), (RegistrationKey)new MailboxIdRegistrationKey(mailbox.getMailboxId())))).onErrorResume(e -> {
            if (e instanceof MailboxExistsException) {
                LOGGER.info("{} mailbox was created concurrently", (Object)mailboxPath.asString());
            } else if (e instanceof MailboxException) {
                return Mono.error((Throwable)e);
            }
            return Mono.empty();
        })), MailboxPathLocker.LockType.Write);
        return mailboxIds;
    }

    private void assertMailboxPathBelongToUser(MailboxSession mailboxSession, MailboxPath mailboxPath) throws MailboxException {
        if (!mailboxPath.belongsTo(mailboxSession)) {
            throw new InsufficientRightsException("mailboxPath '" + mailboxPath.asString() + "' does not belong to user '" + mailboxSession.getUser().asString() + "'");
        }
    }

    public void deleteMailbox(MailboxPath mailboxPath, MailboxSession session) throws MailboxException {
        LOGGER.info("deleteMailbox {}", (Object)mailboxPath);
        this.assertIsOwner(session, mailboxPath);
        MailboxMapper mailboxMapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        mailboxMapper.execute(() -> (Mailbox)MailboxReactorUtils.block(mailboxMapper.findMailboxByPath(mailboxPath).flatMap(mailbox -> this.doDeleteMailbox(mailboxMapper, (Mailbox)mailbox, session)).switchIfEmpty(Mono.error(() -> new MailboxNotFoundException(mailboxPath)))));
    }

    public Mailbox deleteMailbox(MailboxId mailboxId, MailboxSession session) throws MailboxException {
        LOGGER.info("deleteMailbox {}", (Object)mailboxId);
        MailboxMapper mailboxMapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        return mailboxMapper.execute(() -> (Mailbox)MailboxReactorUtils.block(mailboxMapper.findMailboxById(mailboxId).map(Throwing.function(mailbox -> {
            this.assertIsOwner(session, mailbox.generateAssociatedPath());
            return mailbox;
        }).sneakyThrow()).flatMap(mailbox -> this.doDeleteMailbox(mailboxMapper, (Mailbox)mailbox, session))));
    }

    private Mono<Mailbox> doDeleteMailbox(MailboxMapper mailboxMapper, Mailbox mailbox, MailboxSession session) {
        MessageMapper messageMapper = this.mailboxSessionMapperFactory.getMessageMapper(session);
        Mono quotaRootPublisher = Mono.fromCallable(() -> this.quotaRootResolver.getQuotaRoot(mailbox.generateAssociatedPath()));
        Mono messageCountPublisher = Mono.from(messageMapper.getMailboxCountersReactive(mailbox)).map(MailboxCounters::getCount);
        return quotaRootPublisher.zipWith(messageCountPublisher).flatMap(quotaRootWithMessageCount -> messageMapper.findInMailboxReactive(mailbox, MessageRange.all(), MessageMapper.FetchType.METADATA, -1).map(message -> MetadataWithMailboxId.from((MessageMetaData)message.metaData(), (MailboxId)message.getMailboxId())).collect(ImmutableList.toImmutableList()).flatMap(metadata -> {
            long totalSize = metadata.stream().map(MetadataWithMailboxId::getMessageMetaData).mapToLong(MessageMetaData::getSize).sum();
            return this.preDeletionHooks.runHooks(PreDeletionHook.DeleteOperation.from((List)metadata)).then(mailboxMapper.delete(mailbox)).then(this.eventBus.dispatch((Event)((EventFactory.MailboxDeletionFinalStage)((EventFactory.RequireQuotaSizeValue)((EventFactory.RequireQuotaCountValue)((EventFactory.RequireMailboxACL)((EventFactory.RequireQuotaRoot)((EventFactory.RequireMailbox)((EventFactory.RequireSession)EventFactory.mailboxDeleted().randomEventId()).mailboxSession(session)).mailbox(mailbox)).quotaRoot((QuotaRoot)quotaRootWithMessageCount.getT1())).mailboxACL(mailbox.getACL())).quotaCount(QuotaCountUsage.count((long)((Long)quotaRootWithMessageCount.getT2())))).quotaSize(QuotaSizeUsage.size((long)totalSize))).build(), (RegistrationKey)new MailboxIdRegistrationKey(mailbox.getMailboxId())));
        }).retryWhen((Retry)RETRY_BACKOFF_SPEC).thenReturn((Object)new Mailbox(mailbox)));
    }

    public List<MailboxManager.MailboxRenamedResult> renameMailbox(MailboxPath from, MailboxPath to, MailboxManager.RenameOption option, MailboxSession session) throws MailboxException {
        LOGGER.debug("renameMailbox {} to {}", (Object)from, (Object)to);
        MailboxPath sanitizedMailboxPath = to.sanitize(session.getPathDelimiter());
        this.validateDestinationPath(sanitizedMailboxPath, session);
        this.assertIsOwner(session, from);
        MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        return mapper.execute(() -> {
            Mailbox mailbox = MailboxReactorUtils.blockOptional(mapper.findMailboxByPath(from)).orElseThrow(() -> new MailboxNotFoundException(from));
            return this.renameSubscriptionsIfNeeded(this.doRenameMailbox(mailbox, sanitizedMailboxPath, session, mapper), option, session);
        });
    }

    private List<MailboxManager.MailboxRenamedResult> renameSubscriptionsIfNeeded(List<MailboxManager.MailboxRenamedResult> renamedResults, MailboxManager.RenameOption option, MailboxSession session) throws SubscriptionException {
        if (option == MailboxManager.RenameOption.RENAME_SUBSCRIPTIONS) {
            SubscriptionMapper subscriptionMapper = this.mailboxSessionMapperFactory.getSubscriptionMapper(session);
            List<Subscription> subscriptionsForUser = subscriptionMapper.findSubscriptionsForUser(session.getUser());
            renamedResults.forEach(Throwing.consumer(renamedResult -> {
                Subscription subscription = new Subscription(session.getUser(), renamedResult.getOriginPath().getName());
                if (subscriptionsForUser.contains(subscription)) {
                    subscriptionMapper.delete(subscription);
                    subscriptionMapper.save(new Subscription(session.getUser(), renamedResult.getDestinationPath().getName()));
                }
            }).sneakyThrow());
        }
        return renamedResults;
    }

    public List<MailboxManager.MailboxRenamedResult> renameMailbox(MailboxId mailboxId, MailboxPath newMailboxPath, MailboxManager.RenameOption option, MailboxSession session) throws MailboxException {
        LOGGER.debug("renameMailbox {} to {}", (Object)mailboxId, (Object)newMailboxPath);
        MailboxPath sanitizedMailboxPath = newMailboxPath.sanitize(session.getPathDelimiter());
        this.validateDestinationPath(sanitizedMailboxPath, session);
        MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        return mapper.execute(() -> {
            Mailbox mailbox = (Mailbox)mapper.findMailboxById(mailboxId).blockOptional().orElseThrow(() -> new MailboxNotFoundException(mailboxId));
            this.assertIsOwner(session, mailbox.generateAssociatedPath());
            return this.renameSubscriptionsIfNeeded(this.doRenameMailbox(mailbox, sanitizedMailboxPath, session, mapper), option, session);
        });
    }

    private void validateDestinationPath(MailboxPath newMailboxPath, MailboxSession session) throws MailboxException {
        if (MailboxReactorUtils.block(this.mailboxExists(newMailboxPath, session)).booleanValue()) {
            throw new MailboxExistsException(newMailboxPath.toString());
        }
        this.assertIsOwner(session, newMailboxPath);
        newMailboxPath.assertAcceptable(session.getPathDelimiter());
    }

    private void assertIsOwner(MailboxSession mailboxSession, MailboxPath mailboxPath) throws MailboxNotFoundException {
        if (!mailboxPath.belongsTo(mailboxSession)) {
            LOGGER.info("Mailbox {} does not belong to {}", (Object)mailboxPath.asString(), (Object)mailboxSession.getUser().asString());
            throw new MailboxNotFoundException(mailboxPath.asString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MailboxManager.MailboxRenamedResult> doRenameMailbox(Mailbox mailbox, MailboxPath newMailboxPath, MailboxSession session, MailboxMapper mapper) throws MailboxException {
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        MailboxPath from = mailbox.generateAssociatedPath();
        mailbox.setNamespace(newMailboxPath.getNamespace());
        mailbox.setUser(newMailboxPath.getUser());
        mailbox.setName(newMailboxPath.getName());
        try {
            MailboxReactorUtils.block(mapper.rename(mailbox).map(mailboxId -> {
                resultBuilder.add((Object)new MailboxManager.MailboxRenamedResult(mailboxId, from, newMailboxPath));
                return mailboxId;
            }));
            MailboxQuery.UserBound query = MailboxQuery.builder().userAndNamespaceFrom(from).expression((MailboxNameExpression)new PrefixedWildcard(from.getName() + this.getDelimiter())).build().asUserBound();
            this.locker.executeWithLock(from, () -> {
                MailboxReactorUtils.block(mapper.findMailboxWithPathLike(query).flatMap(sub -> {
                    String subOriginalName = sub.getName();
                    String subNewName = newMailboxPath.getName() + subOriginalName.substring(from.getName().length());
                    MailboxPath fromPath = new MailboxPath(from, subOriginalName);
                    sub.setName(subNewName);
                    return mapper.rename((Mailbox)sub).map(mailboxId -> {
                        resultBuilder.add((Object)new MailboxManager.MailboxRenamedResult(sub.getMailboxId(), fromPath, sub.generateAssociatedPath()));
                        return mailboxId;
                    }).retryWhen((Retry)Retry.backoff((long)5L, (Duration)Duration.ofMillis(10L))).then(Mono.fromRunnable(() -> LOGGER.debug("Rename mailbox sub-mailbox {} to {}", (Object)subOriginalName, (Object)subNewName)));
                }, 2).then());
                return null;
            }, MailboxPathLocker.LockType.Write);
            ImmutableList immutableList = resultBuilder.build();
            return immutableList;
        }
        finally {
            Flux.fromIterable((Iterable)resultBuilder.build()).concatMap(result -> this.eventBus.dispatch((Event)EventFactory.mailboxRenamed().randomEventId().mailboxSession(session).mailboxId(result.getMailboxId()).oldPath(result.getOriginPath()).newPath(result.getDestinationPath()).build(), (RegistrationKey)new MailboxIdRegistrationKey(result.getMailboxId()))).blockLast();
        }
    }

    public List<MessageRange> copyMessages(MessageRange set, MailboxPath from, MailboxPath to, MailboxSession session) throws MailboxException {
        StoreMessageManager toMailbox = (StoreMessageManager)this.getMailbox(to, session);
        StoreMessageManager fromMailbox = (StoreMessageManager)this.getMailbox(from, session);
        return this.copyMessages(set, session, toMailbox, fromMailbox);
    }

    public List<MessageRange> copyMessages(MessageRange set, MailboxId from, MailboxId to, MailboxSession session) throws MailboxException {
        StoreMessageManager toMailbox = (StoreMessageManager)this.getMailbox(to, session);
        StoreMessageManager fromMailbox = (StoreMessageManager)this.getMailbox(from, session);
        return this.copyMessages(set, session, toMailbox, fromMailbox);
    }

    private List<MessageRange> copyMessages(MessageRange set, MailboxSession session, StoreMessageManager toMailbox, StoreMessageManager fromMailbox) throws MailboxException {
        return this.configuration.getCopyBatcher().batchMessages(set, messageRange -> fromMailbox.copyTo(messageRange, toMailbox, session));
    }

    public List<MessageRange> moveMessages(MessageRange set, MailboxPath from, MailboxPath to, MailboxSession session) throws MailboxException {
        StoreMessageManager toMailbox = (StoreMessageManager)this.getMailbox(to, session);
        StoreMessageManager fromMailbox = (StoreMessageManager)this.getMailbox(from, session);
        return this.configuration.getMoveBatcher().batchMessages(set, messageRange -> fromMailbox.moveTo(messageRange, toMailbox, session));
    }

    public List<MessageRange> moveMessages(MessageRange set, MailboxId from, MailboxId to, MailboxSession session) throws MailboxException {
        StoreMessageManager toMailbox = (StoreMessageManager)this.getMailbox(to, session);
        StoreMessageManager fromMailbox = (StoreMessageManager)this.getMailbox(from, session);
        return this.configuration.getMoveBatcher().batchMessages(set, messageRange -> fromMailbox.moveTo(messageRange, toMailbox, session));
    }

    public Flux<MailboxMetaData> search(MailboxQuery expression, MailboxManager.MailboxSearchFetchType fetchType, MailboxSession session) {
        Mono mailboxesMono = this.searchMailboxes(expression, session, MailboxACL.Right.Lookup).collectList();
        return mailboxesMono.flatMapMany(mailboxes -> Flux.fromIterable((Iterable)mailboxes).filter(arg_0 -> ((MailboxQuery)expression).matches(arg_0)).transform(this.metadataTransformation(fetchType, session, (List<Mailbox>)mailboxes))).sort(MailboxMetaData.COMPARATOR);
    }

    private Function<Flux<Mailbox>, Flux<MailboxMetaData>> metadataTransformation(MailboxManager.MailboxSearchFetchType fetchType, MailboxSession session, List<Mailbox> mailboxes) {
        if (fetchType == MailboxManager.MailboxSearchFetchType.Counters) {
            return this.withCounters(session, mailboxes);
        }
        return this.withoutCounters(session, mailboxes);
    }

    private Function<Flux<Mailbox>, Flux<MailboxMetaData>> withCounters(MailboxSession session, List<Mailbox> mailboxes) {
        MessageMapper messageMapper = this.mailboxSessionMapperFactory.getMessageMapper(session);
        Map<MailboxPath, Boolean> parentMap = this.parentMap(mailboxes, session);
        int concurrency = 4;
        return mailboxFlux -> mailboxFlux.flatMap(mailbox -> this.retrieveCounters(messageMapper, (Mailbox)mailbox, session).map(Throwing.function(counters -> this.toMailboxMetadata(session, parentMap, (Mailbox)mailbox, (MailboxCounters)counters)).sneakyThrow()), concurrency);
    }

    private Map<MailboxPath, Boolean> parentMap(List<Mailbox> mailboxes, MailboxSession session) {
        return (Map)mailboxes.stream().map(Mailbox::generateAssociatedPath).flatMap(path -> {
            List hierarchyLevels = path.getHierarchyLevels(session.getPathDelimiter());
            return Lists.reverse((List)hierarchyLevels).stream().skip(1L);
        }).collect(ImmutableMap.toImmutableMap(Function.identity(), any -> true, (a, b) -> true));
    }

    private Function<Flux<Mailbox>, Flux<MailboxMetaData>> withoutCounters(MailboxSession session, List<Mailbox> mailboxes) {
        Map<MailboxPath, Boolean> parentMap = this.parentMap(mailboxes, session);
        return mailboxFlux -> mailboxFlux.map(Throwing.function(mailbox -> this.toMailboxMetadata(session, parentMap, (Mailbox)mailbox, MailboxCounters.empty((MailboxId)mailbox.getMailboxId()))).sneakyThrow());
    }

    private Mono<MailboxCounters> retrieveCounters(MessageMapper messageMapper, Mailbox mailbox, MailboxSession session) {
        return messageMapper.getMailboxCountersReactive(mailbox).filter(Throwing.predicate(counter -> this.storeRightManager.hasRight(mailbox, MailboxACL.Right.Read, session)).sneakyThrow()).switchIfEmpty(Mono.just((Object)MailboxCounters.empty((MailboxId)mailbox.getMailboxId())));
    }

    private Flux<Mailbox> searchMailboxes(MailboxQuery mailboxQuery, MailboxSession session, MailboxACL.Right right) {
        MailboxMapper mailboxMapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        Flux<Mailbox> baseMailboxes = mailboxMapper.findMailboxWithPathLike(StoreMailboxManager.toSingleUserQuery(mailboxQuery, session));
        Flux<Mailbox> delegatedMailboxes = this.getDelegatedMailboxes(mailboxMapper, mailboxQuery, right, session);
        return Flux.concat((Publisher[])new Publisher[]{baseMailboxes, delegatedMailboxes}).distinct().filter((Predicate)Throwing.predicate(mailbox -> this.storeRightManager.hasRight((Mailbox)mailbox, right, session)));
    }

    private Flux<MailboxId> accessibleMailboxIds(MultimailboxesSearchQuery.Namespace namespace, MailboxACL.Right right, MailboxSession session) {
        MailboxMapper mailboxMapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        Flux<MailboxId> baseMailboxes = mailboxMapper.userMailboxes(session.getUser());
        Flux<MailboxId> delegatedMailboxes = this.getDelegatedMailboxes(mailboxMapper, namespace, right, session);
        return Flux.concat((Publisher[])new Publisher[]{baseMailboxes, delegatedMailboxes}).distinct();
    }

    static MailboxQuery.UserBound toSingleUserQuery(MailboxQuery mailboxQuery, MailboxSession mailboxSession) {
        return MailboxQuery.builder().namespace(mailboxQuery.getNamespace().orElse("#private")).username(mailboxQuery.getUser().orElse(mailboxSession.getUser())).expression(mailboxQuery.getMailboxNameExpression().includeChildren()).build().asUserBound();
    }

    private Flux<Mailbox> getDelegatedMailboxes(MailboxMapper mailboxMapper, MailboxQuery mailboxQuery, MailboxACL.Right right, MailboxSession session) {
        if (mailboxQuery.isPrivateMailboxes(session)) {
            return Flux.empty();
        }
        return mailboxMapper.findNonPersonalMailboxes(session.getUser(), right);
    }

    private Flux<MailboxId> getDelegatedMailboxes(MailboxMapper mailboxMapper, MultimailboxesSearchQuery.Namespace namespace, MailboxACL.Right right, MailboxSession session) {
        if (!namespace.accessDelegatedMailboxes()) {
            return Flux.empty();
        }
        return mailboxMapper.findNonPersonalMailboxes(session.getUser(), right).map(Mailbox::getMailboxId);
    }

    private MailboxMetaData toMailboxMetadata(MailboxSession session, Map<MailboxPath, Boolean> parentMap, Mailbox mailbox, MailboxCounters counters) throws UnsupportedRightException {
        return new MailboxMetaData(mailbox.generateAssociatedPath(), mailbox.getMailboxId(), this.getDelimiter(), this.computeChildren(parentMap, mailbox), MailboxMetaData.Selectability.NONE, this.storeRightManager.getResolvedMailboxACL(mailbox, session), counters);
    }

    private MailboxMetaData.Children computeChildren(Map<MailboxPath, Boolean> parentMap, Mailbox mailbox) {
        if (parentMap.getOrDefault(mailbox.generateAssociatedPath(), false).booleanValue()) {
            return MailboxMetaData.Children.HAS_CHILDREN;
        }
        return MailboxMetaData.Children.HAS_NO_CHILDREN;
    }

    public Flux<MessageId> search(MultimailboxesSearchQuery expression, MailboxSession session, long limit) {
        return this.getInMailboxIds(expression, session).filter(id -> !expression.getNotInMailboxes().contains(id)).collect(ImmutableSet.toImmutableSet()).flatMapMany((Function)Throwing.function(ids -> this.index.search(session, (Collection<MailboxId>)ids, expression.getSearchQuery(), limit)));
    }

    public Flux<MessageId> getThread(ThreadId threadId, MailboxSession session) {
        return this.threadIdGuessingAlgorithm.getMessageIdsInThread(threadId, session);
    }

    private Flux<MailboxId> getInMailboxIds(MultimailboxesSearchQuery expression, MailboxSession session) {
        if (expression.getInMailboxes().isEmpty()) {
            return this.accessibleMailboxIds(expression.getNamespace(), MailboxACL.Right.Read, session);
        }
        return this.filterReadable((ImmutableSet<MailboxId>)expression.getInMailboxes(), session).filter(mailbox -> expression.getNamespace().keepAccessible(mailbox)).map(Mailbox::getMailboxId);
    }

    private Flux<Mailbox> filterReadable(ImmutableSet<MailboxId> inMailboxes, MailboxSession session) {
        MailboxMapper mailboxMapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        return Flux.fromIterable(inMailboxes).concatMap(mailboxMapper::findMailboxById).filter(Throwing.predicate(mailbox -> this.storeRightManager.hasRight((Mailbox)mailbox, MailboxACL.Right.Read, session)).sneakyThrow());
    }

    public Mono<Boolean> mailboxExists(MailboxPath mailboxPath, MailboxSession session) {
        MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        return mapper.pathExists(mailboxPath);
    }

    public void endProcessingRequest(MailboxSession session) {
        this.mailboxSessionMapperFactory.endProcessingRequest(session);
    }

    public void startProcessingRequest(MailboxSession session) {
    }

    public List<MailboxPath> list(MailboxSession session) throws MailboxException {
        return (List)MailboxReactorUtils.block(this.mailboxSessionMapperFactory.getMailboxMapper(session).list().map(Mailbox::generateAssociatedPath).distinct().collect(ImmutableList.toImmutableList()));
    }

    public boolean hasRight(MailboxPath mailboxPath, MailboxACL.Right right, MailboxSession session) throws MailboxException {
        return this.storeRightManager.hasRight(mailboxPath, right, session);
    }

    public boolean hasRight(MailboxId mailboxId, MailboxACL.Right right, MailboxSession session) throws MailboxException {
        return this.storeRightManager.hasRight(mailboxId, right, session);
    }

    public MailboxACL.Rfc4314Rights myRights(MailboxPath mailboxPath, MailboxSession session) throws MailboxException {
        return this.storeRightManager.myRights(mailboxPath, session);
    }

    public Mono<MailboxACL.Rfc4314Rights> myRights(MailboxId mailboxId, MailboxSession session) {
        return this.storeRightManager.myRights(mailboxId, session);
    }

    public MailboxACL.Rfc4314Rights myRights(Mailbox mailbox, MailboxSession session) {
        return this.storeRightManager.myRights(mailbox, session);
    }

    public List<MailboxACL.Rfc4314Rights> listRights(MailboxPath mailboxPath, MailboxACL.EntryKey key, MailboxSession session) throws MailboxException {
        return this.storeRightManager.listRights(mailboxPath, key, session);
    }

    public MailboxACL listRights(MailboxPath mailboxPath, MailboxSession session) throws MailboxException {
        return this.storeRightManager.listRights(mailboxPath, session);
    }

    public MailboxACL listRights(MailboxId mailboxId, MailboxSession session) throws MailboxException {
        return this.storeRightManager.listRights(mailboxId, session);
    }

    public void applyRightsCommand(MailboxPath mailboxPath, MailboxACL.ACLCommand mailboxACLCommand, MailboxSession session) throws MailboxException {
        this.storeRightManager.applyRightsCommand(mailboxPath, mailboxACLCommand, session);
    }

    public void applyRightsCommand(MailboxId mailboxId, MailboxACL.ACLCommand mailboxACLCommand, MailboxSession session) throws MailboxException {
        this.storeRightManager.applyRightsCommand(mailboxId, mailboxACLCommand, session);
    }

    public void setRights(MailboxPath mailboxPath, MailboxACL mailboxACL, MailboxSession session) throws MailboxException {
        this.storeRightManager.setRights(mailboxPath, mailboxACL, session);
    }

    public void setRights(MailboxId mailboxId, MailboxACL mailboxACL, MailboxSession session) throws MailboxException {
        this.storeRightManager.setRights(mailboxId, mailboxACL, session);
    }

    public List<MailboxAnnotation> getAllAnnotations(MailboxPath mailboxPath, MailboxSession session) throws MailboxException {
        return this.annotationManager.getAllAnnotations(mailboxPath, session);
    }

    public List<MailboxAnnotation> getAnnotationsByKeys(MailboxPath mailboxPath, MailboxSession session, Set<MailboxAnnotationKey> keys) throws MailboxException {
        return this.annotationManager.getAnnotationsByKeys(mailboxPath, session, keys);
    }

    public void updateAnnotations(MailboxPath mailboxPath, MailboxSession session, List<MailboxAnnotation> mailboxAnnotations) throws MailboxException {
        this.annotationManager.updateAnnotations(mailboxPath, session, mailboxAnnotations);
    }

    public boolean hasCapability(MailboxManager.MailboxCapabilities capability) {
        return this.getSupportedMailboxCapabilities().contains(capability);
    }

    public List<MailboxAnnotation> getAnnotationsByKeysWithOneDepth(MailboxPath mailboxPath, MailboxSession session, Set<MailboxAnnotationKey> keys) throws MailboxException {
        return this.annotationManager.getAnnotationsByKeysWithOneDepth(mailboxPath, session, keys);
    }

    public List<MailboxAnnotation> getAnnotationsByKeysWithAllDepth(MailboxPath mailboxPath, MailboxSession session, Set<MailboxAnnotationKey> keys) throws MailboxException {
        return this.annotationManager.getAnnotationsByKeysWithAllDepth(mailboxPath, session, keys);
    }

    public boolean hasChildren(MailboxPath mailboxPath, MailboxSession session) throws MailboxException {
        MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        return (Boolean)MailboxReactorUtils.block(mapper.findMailboxByPath(mailboxPath).flatMap(mailbox -> mapper.hasChildren((Mailbox)mailbox, session.getPathDelimiter())));
    }
}

