/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.api.pushsubscription;

import java.time.Clock;
import java.time.ZonedDateTime;
import java.util.Optional;
import org.apache.james.jmap.api.model.PushSubscription;
import org.apache.james.jmap.api.model.PushSubscriptionExpiredTime;
import org.apache.james.jmap.api.model.PushSubscriptionKeys;
import scala.Option;
import scala.jdk.javaapi.OptionConverters;

public class PushSubscriptionHelpers {
    public static boolean isInThePast(PushSubscriptionExpiredTime expire, Clock clock) {
        return expire.isBefore(ZonedDateTime.now(clock));
    }

    public static boolean isInThePast(Option<PushSubscriptionExpiredTime> expire, Clock clock) {
        return (Boolean)expire.map(value -> PushSubscriptionHelpers.isInThePast(value, clock)).getOrElse(() -> false);
    }

    public static PushSubscriptionExpiredTime evaluateExpiresTime(Optional<ZonedDateTime> inputTime, Clock clock) {
        ZonedDateTime now = ZonedDateTime.now(clock);
        ZonedDateTime maxExpiresTime = now.plusDays(PushSubscription.EXPIRES_TIME_MAX_DAY());
        return PushSubscriptionExpiredTime.apply(inputTime.filter(input -> input.isBefore(maxExpiresTime)).orElse(maxExpiresTime));
    }

    public static boolean isNotOutdatedSubscription(PushSubscription subscription, Clock clock) {
        return subscription.expires().isAfter(ZonedDateTime.now(clock));
    }

    public static boolean isInvalidPushSubscriptionKey(Option<PushSubscriptionKeys> keysOption) {
        return OptionConverters.toJava(keysOption).map(key -> key.p256dh().isEmpty() || key.auth().isEmpty()).orElse(false);
    }
}

