/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jspf.impl;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.james.jspf.executor.SPFResult;
import org.apache.james.jspf.impl.DefaultSPF;
import org.apache.james.jspf.impl.Log4JLogger;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;

public class SPFQuery {
    private static final int PASS_RCODE = 0;
    private static final int FAIL_RCODE = 1;
    private static final int SOFTFAIL_RCODE = 2;
    private static final int NEUTRAL_RCODE = 3;
    private static final int TEMP_ERROR_RCODE = 4;
    private static final int PERM_ERROR_RCODE = 5;
    private static final int NONE_RCODE = 6;
    private static final int UNKNOWN_RCODE = 255;
    private static final String CMD_IP = "ip";
    private static final char CHAR_IP = 'i';
    private static final String CMD_SENDER = "sender";
    private static final char CHAR_SENDER = 's';
    private static final String CMD_HELO = "helo";
    private static final char CHAR_HELO = 'h';
    private static final String CMD_DEBUG = "debug";
    private static final char CHAR_DEBUG = 'd';
    private static final String CMD_VERBOSE = "verbose";
    private static final char CHAR_VERBOSE = 'v';
    private static final String CMD_DEFAULT_EXP = "default-explanation";
    private static final char CHAR_DEFAULT_EXP = 'e';
    private static final String CMD_BEST_GUESS = "enable-best-guess";
    private static final char CHAR_BEST_GUESS = 'b';
    private static final String CMD_TRUSTED_FORWARDER = "enable-trusted-forwarder";
    private static final char CHAR_TRUSTED_FORWARDER = 't';
    private static Logger logger = Logger.getRootLogger();

    public static void main(String[] args) {
        String ip = null;
        String sender = null;
        String helo = null;
        String defaultExplanation = null;
        boolean useBestGuess = false;
        boolean useTrustedForwarder = false;
        SimpleLayout layout = new SimpleLayout();
        ConsoleAppender consoleAppender = new ConsoleAppender((Layout)layout);
        logger.addAppender((Appender)consoleAppender);
        logger.setLevel(Level.ERROR);
        Options options = SPFQuery.generateOptions();
        PosixParser parser = new PosixParser();
        try {
            CommandLine line = parser.parse(options, args);
            ip = line.getOptionValue('i');
            sender = line.getOptionValue('s');
            helo = line.getOptionValue('h');
            defaultExplanation = line.getOptionValue('e');
            useBestGuess = line.hasOption('b');
            useTrustedForwarder = line.hasOption('t');
            if (ip != null && sender != null && helo != null) {
                if (line.hasOption('d')) {
                    logger.setLevel(Level.DEBUG);
                }
                if (line.hasOption('v')) {
                    logger.setLevel(Level.TRACE);
                }
                DefaultSPF spf = new DefaultSPF(new Log4JLogger(logger));
                if (defaultExplanation != null) {
                    spf.setDefaultExplanation(defaultExplanation);
                }
                if (useBestGuess) {
                    spf.setUseBestGuess(true);
                }
                if (useTrustedForwarder) {
                    spf.setUseTrustedForwarder(true);
                }
                SPFResult result = spf.checkSPF(ip, sender, helo);
                System.out.println(result.getResult());
                System.out.println(result.getHeader());
                System.exit(SPFQuery.getReturnCode(result.getResult()));
            } else {
                SPFQuery.usage();
            }
        }
        catch (ParseException e) {
            SPFQuery.usage();
        }
    }

    private static Options generateOptions() {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)CMD_IP);
        OptionBuilder.withValueSeparator((char)'=');
        OptionBuilder.withArgName((String)CMD_IP);
        OptionBuilder.withDescription((String)"Sender IP address");
        OptionBuilder.isRequired();
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((char)'i'));
        OptionBuilder.withLongOpt((String)CMD_SENDER);
        OptionBuilder.withValueSeparator((char)'=');
        OptionBuilder.withArgName((String)CMD_SENDER);
        OptionBuilder.withDescription((String)"Sender address");
        OptionBuilder.isRequired();
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((char)'s'));
        OptionBuilder.withLongOpt((String)CMD_HELO);
        OptionBuilder.withValueSeparator((char)'=');
        OptionBuilder.withArgName((String)CMD_HELO);
        OptionBuilder.withDescription((String)"Helo name");
        OptionBuilder.isRequired();
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((char)'h'));
        OptionBuilder.withLongOpt((String)CMD_DEFAULT_EXP);
        OptionBuilder.withValueSeparator((char)'=');
        OptionBuilder.withArgName((String)"expl");
        OptionBuilder.withDescription((String)"Default explanation");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((char)'e'));
        OptionBuilder.withLongOpt((String)CMD_BEST_GUESS);
        OptionBuilder.withArgName((String)"bestguess");
        OptionBuilder.withDescription((String)"Enable 'best guess' rule");
        options.addOption(OptionBuilder.create((char)'b'));
        OptionBuilder.withLongOpt((String)CMD_TRUSTED_FORWARDER);
        OptionBuilder.withArgName((String)"trustedfwd");
        OptionBuilder.withDescription((String)"Enable 'trusted forwarder' rule");
        options.addOption(OptionBuilder.create((char)'t'));
        OptionBuilder.withLongOpt((String)CMD_DEBUG);
        OptionBuilder.withArgName((String)CMD_DEBUG);
        OptionBuilder.withDescription((String)"Enable debug");
        options.addOption(OptionBuilder.create((char)'d'));
        OptionBuilder.withLongOpt((String)CMD_VERBOSE);
        OptionBuilder.withArgName((String)CMD_VERBOSE);
        OptionBuilder.withDescription((String)"Enable verbose mode");
        options.addOption(OptionBuilder.create((char)'v'));
        return options;
    }

    private static void usage() {
        HelpFormatter hf = new HelpFormatter();
        hf.printHelp("SPFQuery", SPFQuery.generateOptions(), true);
        System.exit(255);
    }

    private static int getReturnCode(String result) {
        if (result.equals("pass")) {
            return 0;
        }
        if (result.equals("fail")) {
            return 1;
        }
        if (result.equals("softfail")) {
            return 2;
        }
        if (result.equals("neutral")) {
            return 3;
        }
        if (result.equals("temperror")) {
            return 4;
        }
        if (result.equals("permerror")) {
            return 5;
        }
        if (result.equals("none")) {
            return 6;
        }
        return 255;
    }
}

