/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.core.Domain;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.quota.MaxQuotaManager;
import org.apache.james.webadmin.dto.QuotaDomainDTO;
import org.apache.james.webadmin.dto.ValidatedQuotaDTO;

public class DomainQuotaService {
    private final MaxQuotaManager maxQuotaManager;

    @Inject
    public DomainQuotaService(MaxQuotaManager maxQuotaManager) {
        this.maxQuotaManager = maxQuotaManager;
    }

    public Optional<QuotaCountLimit> getMaxCountQuota(Domain domain) {
        return this.maxQuotaManager.getDomainMaxMessage(domain);
    }

    public void setMaxCountQuota(Domain domain, QuotaCountLimit quotaCount) throws MailboxException {
        this.maxQuotaManager.setDomainMaxMessage(domain, quotaCount);
    }

    public void remoteMaxQuotaCount(Domain domain) throws MailboxException {
        this.maxQuotaManager.removeDomainMaxMessage(domain);
    }

    public Optional<QuotaSizeLimit> getMaxSizeQuota(Domain domain) {
        return this.maxQuotaManager.getDomainMaxStorage(domain);
    }

    public void setMaxSizeQuota(Domain domain, QuotaSizeLimit quotaSize) throws MailboxException {
        this.maxQuotaManager.setDomainMaxStorage(domain, quotaSize);
    }

    public void remoteMaxQuotaSize(Domain domain) throws MailboxException {
        this.maxQuotaManager.removeDomainMaxStorage(domain);
    }

    public QuotaDomainDTO getQuota(Domain domain) throws MailboxException {
        return QuotaDomainDTO.builder().domain(ValidatedQuotaDTO.builder().count(this.maxQuotaManager.getDomainMaxMessage(domain)).size(this.maxQuotaManager.getDomainMaxStorage(domain))).global(ValidatedQuotaDTO.builder().count(this.maxQuotaManager.getGlobalMaxMessage()).size(this.maxQuotaManager.getGlobalMaxStorage())).computed(ValidatedQuotaDTO.builder().count(this.maxQuotaManager.getComputedMaxMessage(domain)).size(this.maxQuotaManager.getComputedMaxStorage(domain))).build();
    }

    public void defineQuota(Domain domain, ValidatedQuotaDTO quota) {
        try {
            if (quota.getCount().isPresent()) {
                this.maxQuotaManager.setDomainMaxMessage(domain, quota.getCount().get());
            } else {
                this.maxQuotaManager.removeDomainMaxMessage(domain);
            }
            if (quota.getSize().isPresent()) {
                this.maxQuotaManager.setDomainMaxStorage(domain, quota.getSize().get());
            } else {
                this.maxQuotaManager.removeDomainMaxStorage(domain);
            }
        }
        catch (MailboxException e) {
            throw new RuntimeException(e);
        }
    }
}

