/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.thirdparty.io.opencensus.stats;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.apache.ratis.thirdparty.io.opencensus.common.Duration;
import org.apache.ratis.thirdparty.io.opencensus.common.Function;
import org.apache.ratis.thirdparty.io.opencensus.internal.StringUtils;
import org.apache.ratis.thirdparty.io.opencensus.internal.Utils;
import org.apache.ratis.thirdparty.io.opencensus.stats.Aggregation;
import org.apache.ratis.thirdparty.io.opencensus.stats.AutoValue_View;
import org.apache.ratis.thirdparty.io.opencensus.stats.AutoValue_View_AggregationWindow_Cumulative;
import org.apache.ratis.thirdparty.io.opencensus.stats.AutoValue_View_AggregationWindow_Interval;
import org.apache.ratis.thirdparty.io.opencensus.stats.AutoValue_View_Name;
import org.apache.ratis.thirdparty.io.opencensus.stats.Measure;
import org.apache.ratis.thirdparty.io.opencensus.tags.TagKey;

@Immutable
public abstract class View {
    static final int NAME_MAX_LENGTH = 255;
    private static final Comparator<TagKey> TAG_KEY_COMPARATOR = new Comparator<TagKey>(){

        @Override
        public int compare(TagKey key1, TagKey key2) {
            return key1.getName().compareToIgnoreCase(key2.getName());
        }
    };

    View() {
    }

    public abstract Name getName();

    public abstract String getDescription();

    public abstract Measure getMeasure();

    public abstract Aggregation getAggregation();

    public abstract List<TagKey> getColumns();

    @Deprecated
    public abstract AggregationWindow getWindow();

    @Deprecated
    public static View create(Name name, String description, Measure measure, Aggregation aggregation, List<TagKey> columns, AggregationWindow window) {
        Utils.checkArgument(new HashSet<TagKey>(columns).size() == columns.size(), "Columns have duplicate.");
        ArrayList<TagKey> tagKeys = new ArrayList<TagKey>(columns);
        Collections.sort(tagKeys, TAG_KEY_COMPARATOR);
        return new AutoValue_View(name, description, measure, aggregation, Collections.unmodifiableList(tagKeys), window);
    }

    public static View create(Name name, String description, Measure measure, Aggregation aggregation, List<TagKey> columns) {
        Utils.checkArgument(new HashSet<TagKey>(columns).size() == columns.size(), "Columns have duplicate.");
        return View.create(name, description, measure, aggregation, columns, AggregationWindow.Cumulative.create());
    }

    @Deprecated
    @Immutable
    public static abstract class AggregationWindow {
        private AggregationWindow() {
        }

        public abstract <T> T match(Function<? super Cumulative, T> var1, Function<? super Interval, T> var2, Function<? super AggregationWindow, T> var3);

        @Deprecated
        @Immutable
        public static abstract class Interval
        extends AggregationWindow {
            private static final Duration ZERO = Duration.create(0L, 0);

            Interval() {
            }

            public abstract Duration getDuration();

            public static Interval create(Duration duration) {
                Utils.checkArgument(duration.compareTo(ZERO) > 0, "Duration must be positive");
                return new AutoValue_View_AggregationWindow_Interval(duration);
            }

            @Override
            public final <T> T match(Function<? super Cumulative, T> p0, Function<? super Interval, T> p1, Function<? super AggregationWindow, T> defaultFunction) {
                return p1.apply(this);
            }
        }

        @Deprecated
        @Immutable
        public static abstract class Cumulative
        extends AggregationWindow {
            private static final Cumulative CUMULATIVE = new AutoValue_View_AggregationWindow_Cumulative();

            Cumulative() {
            }

            public static Cumulative create() {
                return CUMULATIVE;
            }

            @Override
            public final <T> T match(Function<? super Cumulative, T> p0, Function<? super Interval, T> p1, Function<? super AggregationWindow, T> defaultFunction) {
                return p0.apply(this);
            }
        }
    }

    @Immutable
    public static abstract class Name {
        Name() {
        }

        public abstract String asString();

        public static Name create(String name) {
            Utils.checkArgument(StringUtils.isPrintableString(name) && name.length() <= 255, "Name should be a ASCII string with a length no greater than 255 characters.");
            return new AutoValue_View_Name(name);
        }
    }
}

