/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ProcessingMode;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QualifiedName;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.TableExpressionType;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Window;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.WindowReference;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.WindowSpecification;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class FunctionCall
extends Expression {
    private final QualifiedName name;
    private final Optional<Window> window;
    private final boolean distinct;
    private final Optional<ProcessingMode> processingMode;
    private final List<Expression> arguments;
    private final Optional<NullTreatment> nullTreatment;

    public FunctionCall(QualifiedName name, List<Expression> arguments) {
        super(null);
        this.name = Objects.requireNonNull(name, "name is null");
        this.window = Optional.empty();
        this.nullTreatment = Optional.empty();
        this.distinct = false;
        this.processingMode = Optional.empty();
        this.arguments = Objects.requireNonNull(arguments, "arguments is null");
    }

    public FunctionCall(QualifiedName name, boolean distinct, List<Expression> arguments) {
        super(null);
        this.name = Objects.requireNonNull(name, "name is null");
        this.window = Optional.empty();
        this.nullTreatment = Optional.empty();
        this.distinct = distinct;
        this.processingMode = Optional.empty();
        this.arguments = Objects.requireNonNull(arguments, "arguments is null");
    }

    public FunctionCall(QualifiedName name, Optional<ProcessingMode> processingMode, List<Expression> arguments) {
        super(null);
        this.name = Objects.requireNonNull(name, "name is null");
        this.window = Optional.empty();
        this.nullTreatment = Optional.empty();
        this.distinct = false;
        this.processingMode = Objects.requireNonNull(processingMode, "processingMode is null");
        this.arguments = Objects.requireNonNull(arguments, "arguments is null");
    }

    public FunctionCall(QualifiedName name, boolean distinct, Optional<ProcessingMode> processingMode, List<Expression> arguments) {
        super(null);
        this.name = Objects.requireNonNull(name, "name is null");
        this.window = Optional.empty();
        this.nullTreatment = Optional.empty();
        this.distinct = distinct;
        this.processingMode = Objects.requireNonNull(processingMode, "processingMode is null");
        this.arguments = Objects.requireNonNull(arguments, "arguments is null");
    }

    public FunctionCall(NodeLocation location, QualifiedName name, List<Expression> arguments) {
        this(location, name, false, Optional.empty(), arguments);
    }

    public FunctionCall(NodeLocation location, QualifiedName name, boolean distinct, Optional<ProcessingMode> processingMode, List<Expression> arguments) {
        super(Objects.requireNonNull(location, "location is null"));
        this.name = Objects.requireNonNull(name, "name is null");
        this.window = Optional.empty();
        this.nullTreatment = Optional.empty();
        this.distinct = distinct;
        this.processingMode = Objects.requireNonNull(processingMode, "processingMode is null");
        this.arguments = Objects.requireNonNull(arguments, "arguments is null");
    }

    public FunctionCall(NodeLocation location, QualifiedName name, Optional<Window> window, Optional<NullTreatment> nullTreatment, boolean distinct, List<Expression> arguments) {
        super(Objects.requireNonNull(location, "location is null"));
        this.name = name;
        this.window = window;
        this.nullTreatment = nullTreatment;
        this.distinct = distinct;
        this.processingMode = Optional.empty();
        this.arguments = arguments;
    }

    public FunctionCall(NodeLocation location, QualifiedName name, Optional<Window> window, Optional<NullTreatment> nullTreatment, boolean distinct, Optional<ProcessingMode> processingMode, List<Expression> arguments) {
        super(Objects.requireNonNull(location, "location is null"));
        this.name = name;
        this.window = window;
        this.nullTreatment = nullTreatment;
        this.distinct = distinct;
        this.processingMode = Objects.requireNonNull(processingMode, "processingMode is null");
        this.arguments = arguments;
    }

    public QualifiedName getName() {
        return this.name;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public Optional<ProcessingMode> getProcessingMode() {
        return this.processingMode;
    }

    public List<Expression> getArguments() {
        return this.arguments;
    }

    public Optional<Window> getWindow() {
        return this.window;
    }

    public Optional<NullTreatment> getNullTreatment() {
        return this.nullTreatment;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitFunctionCall(this, context);
    }

    public List<Node> getChildren() {
        ImmutableList.Builder nodes = ImmutableList.builder();
        nodes.addAll(this.arguments);
        return nodes.build();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionCall o = (FunctionCall)obj;
        return Objects.equals(this.name, o.name) && Objects.equals(this.distinct, o.distinct) && Objects.equals(this.processingMode, o.processingMode) && Objects.equals(this.arguments, o.arguments);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.distinct, this.processingMode, this.arguments);
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!FunctionCall.sameClass(this, other)) {
            return false;
        }
        FunctionCall otherFunction = (FunctionCall)other;
        return this.name.equals(otherFunction.name) && this.distinct == otherFunction.distinct && this.processingMode.equals(otherFunction.processingMode);
    }

    @Override
    public TableExpressionType getExpressionType() {
        return TableExpressionType.FUNCTION_CALL;
    }

    @Override
    public void serialize(ByteBuffer buffer) {
        this.name.serialize(buffer);
        ReadWriteIOUtils.write((Boolean)this.distinct, (ByteBuffer)buffer);
        ReadWriteIOUtils.write((int)this.arguments.size(), (ByteBuffer)buffer);
        for (Expression argument : this.arguments) {
            Expression.serialize(argument, buffer);
        }
        if (this.nullTreatment.isPresent()) {
            ReadWriteIOUtils.write((byte)1, (ByteBuffer)buffer);
            ReadWriteIOUtils.write((byte)((byte)this.nullTreatment.get().ordinal()), (ByteBuffer)buffer);
        } else {
            ReadWriteIOUtils.write((byte)0, (ByteBuffer)buffer);
        }
        if (this.window.isPresent()) {
            ReadWriteIOUtils.write((byte)1, (ByteBuffer)buffer);
            if (this.window.get() instanceof WindowReference) {
                ReadWriteIOUtils.write((byte)0, (ByteBuffer)buffer);
            } else {
                ReadWriteIOUtils.write((byte)1, (ByteBuffer)buffer);
            }
            this.window.get().serialize(buffer);
        } else {
            ReadWriteIOUtils.write((byte)0, (ByteBuffer)buffer);
        }
        if (this.processingMode.isPresent()) {
            ReadWriteIOUtils.write((Boolean)true, (ByteBuffer)buffer);
            ProcessingMode mode = this.processingMode.get();
            ReadWriteIOUtils.write((String)mode.getMode().name(), (ByteBuffer)buffer);
        } else {
            ReadWriteIOUtils.write((Boolean)false, (ByteBuffer)buffer);
        }
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        this.name.serialize(stream);
        ReadWriteIOUtils.write((Boolean)this.distinct, (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.arguments.size(), (OutputStream)stream);
        for (Expression argument : this.arguments) {
            Expression.serialize(argument, stream);
        }
        if (this.nullTreatment.isPresent()) {
            ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
            ReadWriteIOUtils.write((byte)((byte)this.nullTreatment.get().ordinal()), (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
        }
        if (this.window.isPresent()) {
            ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
            if (this.window.get() instanceof WindowReference) {
                ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
            } else {
                ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
            }
            this.window.get().serialize(stream);
        } else {
            ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
        }
        if (this.processingMode.isPresent()) {
            ReadWriteIOUtils.write((Boolean)true, (OutputStream)stream);
            ProcessingMode mode = this.processingMode.get();
            ReadWriteIOUtils.write((String)mode.getMode().name(), (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((Boolean)false, (OutputStream)stream);
        }
    }

    public FunctionCall(ByteBuffer byteBuffer) {
        super(null);
        this.name = QualifiedName.deserialize(byteBuffer);
        this.distinct = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        this.arguments = new ArrayList<Expression>(size);
        while (size-- > 0) {
            this.arguments.add(Expression.deserialize(byteBuffer));
        }
        this.nullTreatment = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer) == 1 ? Optional.of(NullTreatment.values()[ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer)]) : Optional.empty();
        this.window = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer) == 1 ? (ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer) == 0 ? Optional.of(new WindowReference(byteBuffer)) : Optional.of(new WindowSpecification(byteBuffer))) : Optional.empty();
        boolean hasProcessingMode = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        if (hasProcessingMode) {
            String modeName = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
            ProcessingMode.Mode mode = ProcessingMode.Mode.valueOf(modeName);
            this.processingMode = Optional.of(new ProcessingMode(null, mode));
        } else {
            this.processingMode = Optional.empty();
        }
    }

    public static enum NullTreatment {
        IGNORE,
        RESPECT;

    }
}

