/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule;

import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.Lookup;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.Rule;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.CorrelatedJoinNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.JoinNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.Patterns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations.QueryCardinalityUtil;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BooleanLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Captures;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Pattern;

public class RemoveUnreferencedScalarSubqueries
implements Rule<CorrelatedJoinNode> {
    private static final Pattern<CorrelatedJoinNode> PATTERN = Patterns.correlatedJoin().with(Patterns.CorrelatedJoin.filter().equalTo(BooleanLiteral.TRUE_LITERAL));

    @Override
    public Pattern<CorrelatedJoinNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(CorrelatedJoinNode correlatedJoinNode, Captures captures, Rule.Context context) {
        PlanNode input = correlatedJoinNode.getInput();
        PlanNode subquery = correlatedJoinNode.getSubquery();
        if (this.isUnreferencedScalar(input, context.getLookup()) && correlatedJoinNode.getCorrelation().isEmpty() && (correlatedJoinNode.getJoinType() == JoinNode.JoinType.INNER || correlatedJoinNode.getJoinType() == JoinNode.JoinType.RIGHT || QueryCardinalityUtil.isAtLeastScalar(subquery, context.getLookup()))) {
            return Rule.Result.ofPlanNode(subquery);
        }
        if (this.isUnreferencedScalar(subquery, context.getLookup())) {
            return Rule.Result.ofPlanNode(input);
        }
        return Rule.Result.empty();
    }

    private boolean isUnreferencedScalar(PlanNode planNode, Lookup lookup) {
        return planNode.getOutputSymbols().isEmpty() && QueryCardinalityUtil.isScalar(planNode, lookup);
    }
}

