/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.metric.overview;

import com.codahale.metrics.Clock;
import com.codahale.metrics.ExponentialMovingAverages;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MovingAverages;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.commons.enums.PipeRateAverage;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.metric.PipeRemainingOperator;
import org.apache.iotdb.commons.pipe.source.IoTDBNonDataRegionSource;
import org.apache.iotdb.db.pipe.source.schemaregion.IoTDBSchemaRegionSource;
import org.apache.iotdb.metrics.core.IoTDBMetricManager;
import org.apache.iotdb.metrics.core.type.IoTDBHistogram;
import org.apache.iotdb.metrics.impl.DoNothingMetricManager;
import org.apache.iotdb.metrics.type.Timer;

public class PipeDataNodeRemainingEventAndTimeOperator
extends PipeRemainingOperator {
    private final Set<IoTDBSchemaRegionSource> schemaRegionExtractors = Collections.newSetFromMap(new ConcurrentHashMap());
    private final AtomicInteger insertNodeEventCount = new AtomicInteger(0);
    private final AtomicInteger rawTabletEventCount = new AtomicInteger(0);
    private final AtomicInteger tsfileEventCount = new AtomicInteger(0);
    private final AtomicInteger heartbeatEventCount = new AtomicInteger(0);
    private final AtomicReference<Meter> dataRegionCommitMeter = new AtomicReference<Object>(null);
    private final AtomicReference<Meter> schemaRegionCommitMeter = new AtomicReference<Object>(null);
    private final IoTDBHistogram collectInvocationHistogram = (IoTDBHistogram)IoTDBMetricManager.getInstance().createHistogram();
    private Timer insertNodeTransferTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer tsfileTransferTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private double lastDataRegionCommitSmoothingValue = 9.223372036854776E18;
    private double lastSchemaRegionCommitSmoothingValue = 9.223372036854776E18;

    PipeDataNodeRemainingEventAndTimeOperator(String pipeName, long creationTime) {
        super(pipeName, creationTime);
    }

    void increaseInsertNodeEventCount() {
        this.insertNodeEventCount.incrementAndGet();
    }

    void decreaseInsertNodeEventCount() {
        this.insertNodeEventCount.decrementAndGet();
    }

    void increaseRawTabletEventCount() {
        this.rawTabletEventCount.incrementAndGet();
    }

    void decreaseRawTabletEventCount() {
        this.rawTabletEventCount.decrementAndGet();
    }

    void increaseTsFileEventCount() {
        this.tsfileEventCount.incrementAndGet();
    }

    void decreaseTsFileEventCount() {
        this.tsfileEventCount.decrementAndGet();
    }

    void increaseHeartbeatEventCount() {
        this.heartbeatEventCount.incrementAndGet();
    }

    void decreaseHeartbeatEventCount() {
        this.heartbeatEventCount.decrementAndGet();
    }

    public long getRemainingNonHeartbeatEvents() {
        long remainingEvents = (long)(this.tsfileEventCount.get() + this.rawTabletEventCount.get() + this.insertNodeEventCount.get()) + this.schemaRegionExtractors.stream().map(IoTDBNonDataRegionSource::getUnTransferredEventCount).reduce(Long::sum).orElse(0L);
        return remainingEvents >= 0L ? remainingEvents : 0L;
    }

    public int getInsertNodeEventCount() {
        return this.insertNodeEventCount.get();
    }

    public double getRemainingTime() {
        double schemaRegionRemainingTime;
        PipeRateAverage pipeRemainingTimeCommitRateAverageTime = PipeConfig.getInstance().getPipeRemainingTimeCommitRateAverageTime();
        double invocationValue = this.collectInvocationHistogram.getMean();
        double totalDataRegionWriteEventCount = (double)this.tsfileEventCount.get() * Math.max(invocationValue, 1.0) + (double)this.rawTabletEventCount.get() + (double)this.insertNodeEventCount.get();
        this.dataRegionCommitMeter.updateAndGet(meter -> {
            if (Objects.nonNull(meter)) {
                this.lastDataRegionCommitSmoothingValue = pipeRemainingTimeCommitRateAverageTime.getMeterRate(meter);
            }
            return meter;
        });
        double dataRegionRemainingTime = totalDataRegionWriteEventCount <= 0.0 ? 0.0 : (this.lastDataRegionCommitSmoothingValue <= 0.0 ? Double.MAX_VALUE : totalDataRegionWriteEventCount / this.lastDataRegionCommitSmoothingValue);
        long totalSchemaRegionWriteEventCount = this.schemaRegionExtractors.stream().map(IoTDBNonDataRegionSource::getUnTransferredEventCount).reduce(Long::sum).orElse(0L);
        this.schemaRegionCommitMeter.updateAndGet(meter -> {
            if (Objects.nonNull(meter)) {
                this.lastSchemaRegionCommitSmoothingValue = pipeRemainingTimeCommitRateAverageTime.getMeterRate(meter);
            }
            return meter;
        });
        if (totalSchemaRegionWriteEventCount <= 0L) {
            schemaRegionRemainingTime = 0.0;
        } else {
            double d = schemaRegionRemainingTime = this.lastSchemaRegionCommitSmoothingValue <= 0.0 ? Double.MAX_VALUE : (double)totalSchemaRegionWriteEventCount / this.lastSchemaRegionCommitSmoothingValue;
        }
        if (totalDataRegionWriteEventCount + (double)totalSchemaRegionWriteEventCount == 0.0) {
            this.notifyEmpty();
        } else {
            this.notifyNonEmpty();
        }
        double result = Math.max(dataRegionRemainingTime, schemaRegionRemainingTime);
        return result >= 3.1536E7 ? 3.1536E7 : result;
    }

    void register(IoTDBSchemaRegionSource extractor) {
        this.schemaRegionExtractors.add(extractor);
    }

    void markDataRegionCommit() {
        this.dataRegionCommitMeter.updateAndGet(meter -> {
            if (Objects.nonNull(meter)) {
                meter.mark();
            }
            return meter;
        });
    }

    void markSchemaRegionCommit() {
        this.schemaRegionCommitMeter.updateAndGet(meter -> {
            if (Objects.nonNull(meter)) {
                meter.mark();
            }
            return meter;
        });
    }

    void markTsFileCollectInvocationCount(long collectInvocationCount) {
        this.collectInvocationHistogram.update(Math.max(collectInvocationCount, 1L));
    }

    public void setInsertNodeTransferTimer(Timer insertNodeTransferTimer) {
        this.insertNodeTransferTimer = insertNodeTransferTimer;
    }

    public Timer getInsertNodeTransferTimer() {
        return this.insertNodeTransferTimer;
    }

    public void setTsFileTransferTimer(Timer tsFileTransferTimer) {
        this.tsfileTransferTimer = tsFileTransferTimer;
    }

    public Timer getTsFileTransferTimer() {
        return this.tsfileTransferTimer;
    }

    public synchronized void thawRate(boolean isStartPipe) {
        super.thawRate(isStartPipe);
        if (this.isStopped) {
            return;
        }
        this.dataRegionCommitMeter.compareAndSet(null, new Meter((MovingAverages)new ExponentialMovingAverages(), Clock.defaultClock()));
        this.schemaRegionCommitMeter.compareAndSet(null, new Meter((MovingAverages)new ExponentialMovingAverages(), Clock.defaultClock()));
    }

    public synchronized void freezeRate(boolean isStopPipe) {
        super.freezeRate(isStopPipe);
        this.dataRegionCommitMeter.set(null);
        this.schemaRegionCommitMeter.set(null);
    }
}

