/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.load.metrics;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.impl.DoNothingMetricManager;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.type.Counter;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ActiveLoadingFilesMetricsSet
implements IMetricSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActiveLoadingFilesMetricsSet.class);
    protected static final String FAILED_PREFIX = "failed - ";
    protected static final String PENDING_PREFIX = "pending - ";
    protected AtomicReference<AbstractMetricService> metricService = new AtomicReference();
    private final AtomicReference<String> failedDir = new AtomicReference();
    private final Set<String> pendingDirs = new CopyOnWriteArraySet<String>();
    protected Counter totalFailedFileCounter = DoNothingMetricManager.DO_NOTHING_COUNTER;
    protected Counter totalPendingFileCounter = DoNothingMetricManager.DO_NOTHING_COUNTER;
    protected Map<String, Counter> dir2PendingFileCounterMap = new ConcurrentHashMap<String, Counter>();

    public void updateTotalFailedFileCounter(long number) {
        this.totalFailedFileCounter.inc(number - this.totalFailedFileCounter.getCount());
    }

    public void updateTotalPendingFileCounter(long number) {
        this.totalPendingFileCounter.inc(number - this.totalPendingFileCounter.getCount());
    }

    public void updatePendingFileCounterInDir(String dirName, long number) {
        Counter counter = this.dir2PendingFileCounterMap.get(dirName);
        if (counter == null) {
            LOGGER.debug("Failed to update file counter, dir({}) does not exist", (Object)dirName);
            return;
        }
        counter.inc(number - counter.getCount());
    }

    public void updatePendingDirList(Set<String> givenListeningDirs) {
        if (this.metricService.get() == null || Objects.equals(this.pendingDirs, givenListeningDirs)) {
            return;
        }
        this.pendingDirs.clear();
        this.pendingDirs.addAll(givenListeningDirs);
        this.unbindDir2PendingFileCounters(this.metricService.get());
        this.rebindDir2PendingFileCounters();
    }

    protected void unbindDir2PendingFileCounters(AbstractMetricService metricService) {
        this.dir2PendingFileCounterMap.keySet().forEach(dir -> metricService.remove(MetricType.COUNTER, this.getMetricName(), new String[]{Tag.TYPE.toString(), PENDING_PREFIX + dir}));
        this.dir2PendingFileCounterMap.clear();
    }

    private void rebindDir2PendingFileCounters() {
        this.dir2PendingFileCounterMap.clear();
        if (!this.pendingDirs.isEmpty()) {
            for (String dir : this.pendingDirs) {
                this.dir2PendingFileCounterMap.put(dir, this.metricService.get().getOrCreateCounter(this.getMetricName(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), PENDING_PREFIX + dir}));
            }
        }
    }

    public void updateFailedDir(String dirName) {
        if (this.metricService.get() == null || Objects.equals(this.failedDir.get(), dirName)) {
            return;
        }
        this.failedDir.set(dirName);
        this.unbindFailedDirCounter(this.metricService.get());
        this.rebindFailedDirCounter();
    }

    protected void unbindFailedDirCounter(AbstractMetricService metricService) {
        this.totalFailedFileCounter = DoNothingMetricManager.DO_NOTHING_COUNTER;
        metricService.remove(MetricType.COUNTER, this.getMetricName(), new String[]{Tag.TYPE.toString(), FAILED_PREFIX + this.failedDir.get()});
    }

    private void rebindFailedDirCounter() {
        this.totalFailedFileCounter = this.metricService.get().getOrCreateCounter(this.getMetricName(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), FAILED_PREFIX + this.failedDir.get()});
    }

    public void bindTo(AbstractMetricService metricService) {
        this.metricService.set(metricService);
        this.bindOtherCounters(metricService);
    }

    protected abstract void bindOtherCounters(AbstractMetricService var1);

    public void unbindFrom(AbstractMetricService metricService) {
        this.unbindDir2PendingFileCounters(metricService);
        this.unbindFailedDirCounter(metricService);
        this.unbindOtherCounters(metricService);
    }

    protected abstract void unbindOtherCounters(AbstractMetricService var1);

    protected abstract String getMetricName();
}

