/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.serialization;

import com.google.common.io.CharStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.milo.opcua.stack.core.UaRuntimeException;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.DataTypeCodec;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.OpcUaXmlDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.OpcUaDefaultXmlEncoding;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.XmlElement;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.util.ArrayUtil;
import org.eclipse.milo.opcua.stack.core.util.SecureXmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class OpcUaXmlStreamDecoder
implements UaDecoder {
    private final DocumentBuilder builder;
    private Document document;
    private Node currentNode;
    private final SerializationContext context;

    public OpcUaXmlStreamDecoder(SerializationContext context) {
        this.context = context;
        try {
            this.builder = SecureXmlUtil.SHARED_DOCUMENT_BUILDER_FACTORY.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new UaRuntimeException(0x80020000L, (Throwable)e);
        }
    }

    public OpcUaXmlStreamDecoder setInput(Document document) {
        this.document = document;
        this.currentNode = document.getFirstChild();
        return this;
    }

    public OpcUaXmlStreamDecoder setInput(Reader reader) throws IOException, SAXException {
        return this.setInput(new ByteArrayInputStream(CharStreams.toString((Readable)reader).getBytes(StandardCharsets.UTF_8)));
    }

    public OpcUaXmlStreamDecoder setInput(InputStream inputStream) throws IOException, SAXException {
        return this.setInput(this.builder.parse(inputStream));
    }

    private boolean currentNode(String field) throws UaSerializationException {
        if (this.currentNode == null) {
            throw new UaSerializationException(0x80070000L, "currentNode==null");
        }
        return field == null || field.equals(this.currentNode.getLocalName());
    }

    @Override
    public Boolean readBoolean(String field) throws UaSerializationException {
        if (this.currentNode(field)) {
            try {
                Boolean bl = DatatypeConverter.parseBoolean((String)this.currentNode.getTextContent());
                return bl;
            }
            catch (IllegalArgumentException e) {
                throw new UaSerializationException(0x80070000L, (Throwable)e);
            }
            finally {
                this.currentNode = this.currentNode.getNextSibling();
            }
        }
        return false;
    }

    @Override
    public Byte readSByte(String field) throws UaSerializationException {
        if (this.currentNode(field)) {
            try {
                Byte by = DatatypeConverter.parseByte((String)this.currentNode.getTextContent());
                return by;
            }
            catch (IllegalArgumentException e) {
                throw new UaSerializationException(0x80070000L, (Throwable)e);
            }
            finally {
                this.currentNode = this.currentNode.getNextSibling();
            }
        }
        return (byte)0;
    }

    @Override
    public Short readInt16(String field) throws UaSerializationException {
        if (this.currentNode(field)) {
            try {
                Short s = DatatypeConverter.parseShort((String)this.currentNode.getTextContent());
                return s;
            }
            catch (NumberFormatException e) {
                throw new UaSerializationException(0x80070000L, (Throwable)e);
            }
            finally {
                this.currentNode = this.currentNode.getNextSibling();
            }
        }
        return (short)0;
    }

    @Override
    public Integer readInt32(String field) throws UaSerializationException {
        if (this.currentNode(field)) {
            try {
                Integer n = DatatypeConverter.parseInt((String)this.currentNode.getTextContent());
                return n;
            }
            catch (NumberFormatException e) {
                throw new UaSerializationException(0x80070000L, (Throwable)e);
            }
            finally {
                this.currentNode = this.currentNode.getNextSibling();
            }
        }
        return 0;
    }

    @Override
    public Long readInt64(String field) throws UaSerializationException {
        if (this.currentNode(field)) {
            try {
                Long l = DatatypeConverter.parseLong((String)this.currentNode.getTextContent());
                return l;
            }
            catch (NumberFormatException e) {
                throw new UaSerializationException(0x80070000L, (Throwable)e);
            }
            finally {
                this.currentNode = this.currentNode.getNextSibling();
            }
        }
        return 0L;
    }

    @Override
    public UByte readByte(String field) throws UaSerializationException {
        if (this.currentNode(field)) {
            try {
                UByte uByte = Unsigned.ubyte(DatatypeConverter.parseShort((String)this.currentNode.getTextContent()));
                return uByte;
            }
            catch (NumberFormatException e) {
                throw new UaSerializationException(0x80070000L, (Throwable)e);
            }
            finally {
                this.currentNode = this.currentNode.getNextSibling();
            }
        }
        return UByte.MIN;
    }

    @Override
    public UShort readUInt16(String field) throws UaSerializationException {
        if (this.currentNode(field)) {
            try {
                UShort uShort = Unsigned.ushort(DatatypeConverter.parseInt((String)this.currentNode.getTextContent()));
                return uShort;
            }
            catch (NumberFormatException e) {
                throw new UaSerializationException(0x80070000L, (Throwable)e);
            }
            finally {
                this.currentNode = this.currentNode.getNextSibling();
            }
        }
        return UShort.MIN;
    }

    @Override
    public UInteger readUInt32(String field) throws UaSerializationException {
        if (this.currentNode(field)) {
            try {
                UInteger uInteger = Unsigned.uint(DatatypeConverter.parseLong((String)this.currentNode.getTextContent()));
                return uInteger;
            }
            catch (NumberFormatException e) {
                throw new UaSerializationException(0x80070000L, (Throwable)e);
            }
            finally {
                this.currentNode = this.currentNode.getNextSibling();
            }
        }
        return UInteger.MIN;
    }

    @Override
    public ULong readUInt64(String field) throws UaSerializationException {
        if (this.currentNode(field)) {
            try {
                ULong uLong = Unsigned.ulong(DatatypeConverter.parseInteger((String)this.currentNode.getTextContent()));
                return uLong;
            }
            catch (NumberFormatException e) {
                throw new UaSerializationException(0x80070000L, (Throwable)e);
            }
            finally {
                this.currentNode = this.currentNode.getNextSibling();
            }
        }
        return ULong.MIN;
    }

    @Override
    public Float readFloat(String field) throws UaSerializationException {
        if (this.currentNode(field)) {
            try {
                Float f = Float.valueOf(DatatypeConverter.parseFloat((String)this.currentNode.getTextContent()));
                return f;
            }
            catch (NumberFormatException e) {
                throw new UaSerializationException(0x80070000L, (Throwable)e);
            }
            finally {
                this.currentNode = this.currentNode.getNextSibling();
            }
        }
        return Float.valueOf(0.0f);
    }

    @Override
    public Double readDouble(String field) throws UaSerializationException {
        if (this.currentNode(field)) {
            try {
                Double d = DatatypeConverter.parseDouble((String)this.currentNode.getTextContent());
                return d;
            }
            catch (NumberFormatException e) {
                throw new UaSerializationException(0x80070000L, (Throwable)e);
            }
            finally {
                this.currentNode = this.currentNode.getNextSibling();
            }
        }
        return 0.0;
    }

    @Override
    public String readString(String field) throws UaSerializationException {
        if (this.currentNode(field)) {
            try {
                String string = this.currentNode.getTextContent();
                return string;
            }
            finally {
                this.currentNode = this.currentNode.getNextSibling();
            }
        }
        return null;
    }

    @Override
    public DateTime readDateTime(String field) throws UaSerializationException {
        if (this.currentNode(field)) {
            try {
                Calendar calendar = DatatypeConverter.parseDateTime((String)this.currentNode.getTextContent());
                DateTime dateTime = new DateTime(calendar.getTime());
                return dateTime;
            }
            catch (IllegalArgumentException e) {
                throw new UaSerializationException(0x80070000L, (Throwable)e);
            }
            finally {
                this.currentNode = this.currentNode.getNextSibling();
            }
        }
        return DateTime.NULL_VALUE;
    }

    @Override
    public UUID readGuid(String field) throws UaSerializationException {
        if (this.currentNode(field)) {
            try {
                UUID uUID = UUID.fromString(this.currentNode.getTextContent());
                return uUID;
            }
            catch (IllegalArgumentException e) {
                throw new UaSerializationException(0x80070000L, (Throwable)e);
            }
            finally {
                this.currentNode = this.currentNode.getNextSibling();
            }
        }
        return new UUID(0L, 0L);
    }

    @Override
    public ByteString readByteString(String field) throws UaSerializationException {
        if (this.currentNode(field)) {
            try {
                byte[] bs = DatatypeConverter.parseBase64Binary((String)this.currentNode.getTextContent());
                ByteString byteString = ByteString.of(bs);
                return byteString;
            }
            catch (IllegalArgumentException e) {
                throw new UaSerializationException(0x80070000L, (Throwable)e);
            }
            finally {
                this.currentNode = this.currentNode.getNextSibling();
            }
        }
        return ByteString.NULL_VALUE;
    }

    @Override
    public XmlElement readXmlElement(String field) throws UaSerializationException {
        if (this.currentNode(field)) {
            try {
                XmlElement xmlElement = OpcUaXmlStreamDecoder.nodeToXmlElement(this.currentNode);
                return xmlElement;
            }
            finally {
                this.currentNode = this.currentNode.getNextSibling();
            }
        }
        return XmlElement.of(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeId readNodeId(String field) throws UaSerializationException {
        if (this.currentNode(field)) {
            Node idNode = this.currentNode.getFirstChild();
            try {
                if (idNode != null) {
                    String textContent = idNode.getTextContent();
                    NodeId nodeId = NodeId.parseSafe(textContent).orElseThrow(() -> new UaSerializationException(0x80070000L, "invalid NodeId: " + textContent));
                    return nodeId;
                }
                NodeId nodeId = NodeId.NULL_VALUE;
                return nodeId;
            }
            finally {
                this.currentNode = this.currentNode.getNextSibling();
            }
        }
        return NodeId.NULL_VALUE;
    }

    @Override
    public ExpandedNodeId readExpandedNodeId(String field) throws UaSerializationException {
        if (this.currentNode(field)) {
            Node expandedIdNode = this.currentNode.getFirstChild();
            try {
                if (expandedIdNode != null) {
                    ExpandedNodeId expandedNodeId = ExpandedNodeId.parse(expandedIdNode.getTextContent());
                    return expandedNodeId;
                }
                ExpandedNodeId expandedNodeId = ExpandedNodeId.NULL_VALUE;
                return expandedNodeId;
            }
            catch (UaRuntimeException e) {
                throw new UaSerializationException(0x80070000L, (Throwable)e);
            }
            finally {
                this.currentNode = this.currentNode.getNextSibling();
            }
        }
        return ExpandedNodeId.NULL_VALUE;
    }

    @Override
    public StatusCode readStatusCode(String field) throws UaSerializationException {
        if (this.currentNode(field)) {
            try {
                long code = 0L;
                Node codeNode = this.currentNode.getFirstChild();
                if (codeNode != null) {
                    code = DatatypeConverter.parseUnsignedInt((String)codeNode.getTextContent());
                }
                StatusCode statusCode = new StatusCode(code);
                return statusCode;
            }
            catch (NumberFormatException e) {
                throw new UaSerializationException(0x80070000L, (Throwable)e);
            }
            finally {
                this.currentNode = this.currentNode.getNextSibling();
            }
        }
        return new StatusCode(0L);
    }

    @Override
    public QualifiedName readQualifiedName(String field) throws UaSerializationException {
        if (this.currentNode(field)) {
            try {
                Node nameNode;
                Map<String, Node> children = OpcUaXmlStreamDecoder.nodeMap(this.currentNode.getChildNodes());
                int namespaceIndex = 0;
                String name = null;
                Node namespaceIndexNode = children.get("NamespaceIndex");
                if (namespaceIndexNode != null) {
                    namespaceIndex = DatatypeConverter.parseInt((String)namespaceIndexNode.getTextContent());
                }
                if ((nameNode = children.get("Name")) != null) {
                    name = nameNode.getTextContent();
                }
                QualifiedName qualifiedName = new QualifiedName(namespaceIndex, name);
                return qualifiedName;
            }
            catch (Throwable t) {
                throw new UaSerializationException(0x80070000L, t);
            }
            finally {
                this.currentNode = this.currentNode.getNextSibling();
            }
        }
        return QualifiedName.NULL_VALUE;
    }

    @Override
    public LocalizedText readLocalizedText(String field) throws UaSerializationException {
        if (this.currentNode(field)) {
            try {
                Node textNode;
                Map<String, Node> children = OpcUaXmlStreamDecoder.nodeMap(this.currentNode.getChildNodes());
                String locale = null;
                String text = null;
                Node localeNode = children.get("Locale");
                if (localeNode != null) {
                    locale = localeNode.getTextContent();
                }
                if ((textNode = children.get("Text")) != null) {
                    text = textNode.getTextContent();
                }
                LocalizedText localizedText = new LocalizedText(locale, text);
                return localizedText;
            }
            catch (Throwable t) {
                throw new UaSerializationException(0x80070000L, t);
            }
            finally {
                this.currentNode = this.currentNode.getNextSibling();
            }
        }
        return LocalizedText.NULL_VALUE;
    }

    @Override
    public ExtensionObject readExtensionObject(String field) throws UaSerializationException {
        NodeId typeId = NodeId.NULL_VALUE;
        ExtensionObject extensionObject = new ExtensionObject(new XmlElement(""), NodeId.NULL_VALUE);
        if (this.currentNode(field)) {
            Node node = this.currentNode;
            try {
                Node bodyNode;
                Map<String, Node> children = OpcUaXmlStreamDecoder.nodeMap(this.currentNode.getChildNodes());
                Node typeIdNode = children.get("TypeId");
                if (typeIdNode != null) {
                    this.currentNode = typeIdNode;
                    typeId = this.readNodeId("TypeId");
                }
                if ((bodyNode = children.get("Body")) != null) {
                    if ("ByteString".equals(bodyNode.getLocalName()) && "http://opcfoundation.org/UA/2008/02/Types.xsd".equals(bodyNode.getNamespaceURI())) {
                        this.currentNode = bodyNode;
                        extensionObject = new ExtensionObject(this.readByteString("ByteString"), typeId);
                    } else {
                        extensionObject = new ExtensionObject(OpcUaXmlStreamDecoder.nodeToXmlElement(bodyNode.getFirstChild()), typeId);
                    }
                }
                ExtensionObject extensionObject2 = extensionObject;
                return extensionObject2;
            }
            catch (Throwable t) {
                throw new UaSerializationException(0x80070000L, t);
            }
            finally {
                this.currentNode = node.getNextSibling();
            }
        }
        return extensionObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataValue readDataValue(String field) throws UaSerializationException {
        if (this.currentNode(field)) {
            Node node = this.currentNode;
            Map<String, Node> children = OpcUaXmlStreamDecoder.nodeMap(this.currentNode.getChildNodes());
            Variant value = Variant.NULL_VALUE;
            StatusCode statusCode = StatusCode.GOOD;
            DateTime sourceTimestamp = null;
            UShort sourcePicoseconds = null;
            DateTime serverTimestamp = null;
            UShort serverPicoseconds = null;
            try {
                Node serverPicosecondsNode;
                Node serverTimestampNode;
                Node sourcePicosecondsNode;
                Node sourceTimestampNode;
                Node statusCodeNode;
                Node valueNode = children.get("Value");
                if (valueNode != null) {
                    this.currentNode = valueNode;
                    value = this.readVariant("Value");
                }
                if ((statusCodeNode = children.get("StatusCode")) != null) {
                    this.currentNode = statusCodeNode;
                    statusCode = this.readStatusCode("StatusCode");
                }
                if ((sourceTimestampNode = children.get("SourceTimestamp")) != null) {
                    this.currentNode = sourceTimestampNode;
                    sourceTimestamp = this.readDateTime("SourceTimestamp");
                }
                if ((sourcePicosecondsNode = children.get("SourcePicoseconds")) != null) {
                    this.currentNode = sourcePicosecondsNode;
                    sourcePicoseconds = this.readUInt16("SourcePicoseconds");
                }
                if ((serverTimestampNode = children.get("ServerTimestamp")) != null) {
                    this.currentNode = serverTimestampNode;
                    serverTimestamp = this.readDateTime("ServerTimestamp");
                }
                if ((serverPicosecondsNode = children.get("ServerPicoseconds")) != null) {
                    this.currentNode = serverPicosecondsNode;
                    serverPicoseconds = this.readUInt16("ServerPicoseconds");
                }
                DataValue dataValue = new DataValue(value, statusCode, sourceTimestamp, sourcePicoseconds, serverTimestamp, serverPicoseconds);
                return dataValue;
            }
            finally {
                this.currentNode = node.getNextSibling();
            }
        }
        return new DataValue(Variant.NULL_VALUE);
    }

    @Override
    public Variant readVariant(String field) throws UaSerializationException {
        if (this.currentNode(field)) {
            Node node = this.currentNode;
            try {
                this.currentNode = node.getFirstChild().getFirstChild();
                Object value = this.readVariantValue();
                Variant variant = new Variant(value);
                return variant;
            }
            catch (Throwable t) {
                throw new UaSerializationException(0x80070000L, t);
            }
            finally {
                this.currentNode = node.getNextSibling();
            }
        }
        return Variant.NULL_VALUE;
    }

    public Object readVariantValue() {
        if (this.currentNode(null)) {
            Node node = this.currentNode;
            String nodeName = node.getLocalName();
            if (nodeName.startsWith("ListOf")) {
                String type = nodeName.substring(6);
                ArrayList<Object> values = new ArrayList<Object>();
                NodeList childNodes = node.getChildNodes();
                for (int i = 0; i < childNodes.getLength(); ++i) {
                    this.currentNode = childNodes.item(i);
                    if (this.currentNode.getNodeType() != 1) continue;
                    values.add(this.readBuiltinType(type, type));
                }
                Object array = Array.newInstance(OpcUaXmlStreamDecoder.builtinTypeClass(type), values.size());
                for (int i = 0; i < values.size(); ++i) {
                    Array.set(array, i, values.get(i));
                }
                return array;
            }
            if (nodeName.equals("Matrix")) {
                ArrayList<Integer> dimensions = new ArrayList<Integer>();
                Node child = node.getFirstChild();
                for (int i = 0; i < child.getChildNodes().getLength(); ++i) {
                    this.currentNode = child.getChildNodes().item(i);
                    if (this.currentNode.getNodeType() != 1) continue;
                    dimensions.add(this.readInt32("Int32"));
                }
                ArrayList<Object> elements = new ArrayList<Object>();
                child = child.getNextSibling();
                for (int i = 0; i < child.getChildNodes().getLength(); ++i) {
                    this.currentNode = child.getChildNodes().item(i);
                    if (this.currentNode.getNodeType() != 1) continue;
                    String type = this.currentNode.getLocalName();
                    elements.add(this.readBuiltinType(type, type));
                }
                Class<?> clazz = elements.get(0).getClass();
                Object array = Array.newInstance(clazz, elements.size());
                for (int i = 0; i < elements.size(); ++i) {
                    Array.set(array, i, elements.get(i));
                }
                int[] dims = new int[dimensions.size()];
                for (int i = 0; i < dimensions.size(); ++i) {
                    dims[i] = (Integer)dimensions.get(i);
                }
                return ArrayUtil.unflatten(array, dims);
            }
            return this.readBuiltinType(nodeName, nodeName);
        }
        return null;
    }

    private Object readBuiltinType(String field, String type) {
        switch (type) {
            case "Boolean": {
                return this.readBoolean(field);
            }
            case "SByte": {
                return this.readSByte(field);
            }
            case "Int16": {
                return this.readInt16(field);
            }
            case "Int32": {
                return this.readInt32(field);
            }
            case "Int64": {
                return this.readInt64(field);
            }
            case "Byte": {
                return this.readByte(field);
            }
            case "UInt16": {
                return this.readUInt16(field);
            }
            case "UInt32": {
                return this.readUInt32(field);
            }
            case "UInt64": {
                return this.readUInt64(field);
            }
            case "Float": {
                return this.readFloat(field);
            }
            case "Double": {
                return this.readDouble(field);
            }
            case "String": {
                return this.readString(field);
            }
            case "DateTime": {
                return this.readDateTime(field);
            }
            case "Guid": {
                return this.readGuid(field);
            }
            case "ByteString": {
                return this.readByteString(field);
            }
            case "XmlElement": {
                return this.readXmlElement(field);
            }
            case "NodeId": {
                return this.readNodeId(field);
            }
            case "ExpandedNodeId": {
                return this.readExpandedNodeId(field);
            }
            case "StatusCode": {
                return this.readStatusCode(field);
            }
            case "QualifiedName": {
                return this.readQualifiedName(field);
            }
            case "LocalizedText": {
                return this.readLocalizedText(field);
            }
            case "ExtensionObject": {
                return this.readExtensionObject(field);
            }
            case "DataValue": {
                return this.readDataValue(field);
            }
            case "Variant": {
                return this.readVariant(field);
            }
            case "DiagnosticInfo": {
                return this.readDiagnosticInfo(field);
            }
        }
        throw new UaSerializationException(0x80070000L, "not builtin type: " + type);
    }

    private static Class<?> builtinTypeClass(String type) {
        switch (type) {
            case "Boolean": {
                return Boolean.class;
            }
            case "SByte": {
                return Byte.class;
            }
            case "Int16": {
                return Short.class;
            }
            case "Int32": {
                return Integer.class;
            }
            case "Int64": {
                return Long.class;
            }
            case "Byte": {
                return UByte.class;
            }
            case "UInt16": {
                return UShort.class;
            }
            case "UInt32": {
                return UInteger.class;
            }
            case "UInt64": {
                return ULong.class;
            }
            case "Float": {
                return Float.class;
            }
            case "Double": {
                return Double.class;
            }
            case "String": {
                return String.class;
            }
            case "DateTime": {
                return DateTime.class;
            }
            case "Guid": {
                return UUID.class;
            }
            case "ByteString": {
                return ByteString.class;
            }
            case "XmlElement": {
                return XmlElement.class;
            }
            case "NodeId": {
                return NodeId.class;
            }
            case "ExpandedNodeId": {
                return ExpandedNodeId.class;
            }
            case "StatusCode": {
                return StatusCode.class;
            }
            case "QualifiedName": {
                return QualifiedName.class;
            }
            case "LocalizedText": {
                return LocalizedText.class;
            }
            case "ExtensionObject": {
                return ExtensionObject.class;
            }
            case "DataValue": {
                return DataValue.class;
            }
            case "Variant": {
                return Variant.class;
            }
            case "DiagnosticInfo": {
                return DiagnosticInfo.class;
            }
        }
        throw new UaSerializationException(0x80070000L, "not builtin type: " + type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DiagnosticInfo readDiagnosticInfo(String field) throws UaSerializationException {
        if (this.currentNode(field)) {
            Node node = this.currentNode;
            Map<String, Node> children = OpcUaXmlStreamDecoder.nodeMap(node.getChildNodes());
            int symbolicId = -1;
            int namespaceUri = -1;
            int locale = -1;
            int localizedText = -1;
            String additionalInfo = null;
            StatusCode innerStatusCode = null;
            DiagnosticInfo innerDiagnosticInfo = null;
            Node child = children.get("SymbolicId");
            if (child != null) {
                this.currentNode = child;
                symbolicId = this.readInt32("SymbolicId");
            }
            if ((child = children.get("NamespaceUri")) != null) {
                this.currentNode = child;
                namespaceUri = this.readInt32("NamespaceUri");
            }
            if ((child = children.get("Locale")) != null) {
                this.currentNode = child;
                locale = this.readInt32("Locale");
            }
            if ((child = children.get("LocalizedText")) != null) {
                this.currentNode = child;
                localizedText = this.readInt32("LocalizedText");
            }
            if ((child = children.get("AdditionalInfo")) != null) {
                this.currentNode = child;
                additionalInfo = this.readString("AdditionalInfo");
            }
            if ((child = children.get("InnerStatusCode")) != null) {
                this.currentNode = child;
                innerStatusCode = this.readStatusCode("InnerStatusCode");
            }
            if ((child = children.get("InnerDiagnosticInfo")) != null) {
                this.currentNode = child;
                innerDiagnosticInfo = this.readDiagnosticInfo("InnerDiagnosticInfo");
            }
            try {
                DiagnosticInfo diagnosticInfo = new DiagnosticInfo(namespaceUri, symbolicId, locale, localizedText, additionalInfo, innerStatusCode, innerDiagnosticInfo);
                return diagnosticInfo;
            }
            finally {
                this.currentNode = node.getNextSibling();
            }
        }
        return DiagnosticInfo.NULL_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UaMessage readMessage(String field) throws UaSerializationException {
        if (this.currentNode(field)) {
            Node node = this.currentNode;
            String typeName = node.getLocalName();
            DataTypeCodec codec = this.context.getDataTypeManager().getCodec("http://opcfoundation.org/UA/2008/02/Types.xsd", String.format("//xs:element[@name='%s']", typeName));
            if (codec instanceof OpcUaXmlDataTypeCodec) {
                this.currentNode = node.getFirstChild();
                try {
                    UaMessage uaMessage = (UaMessage)((OpcUaXmlDataTypeCodec)codec).decode(this.context, this);
                    return uaMessage;
                }
                finally {
                    this.currentNode = node.getNextSibling();
                }
            }
            throw new UaSerializationException(0x80070000L, "no codec registered: " + typeName);
        }
        return null;
    }

    @Override
    public <T extends Enum<?>> T readEnum(String field, Class<T> enumType) throws UaSerializationException {
        if (this.currentNode(field)) {
            try {
                String s = this.currentNode.getTextContent();
                int lastIndex = s.lastIndexOf("_");
                if (lastIndex != -1) {
                    Enum enum_;
                    try {
                        int value = Integer.parseInt(s.substring(lastIndex + 1));
                        Method m = enumType.getDeclaredMethod("from", Integer.TYPE);
                        Object o = m.invoke(null, value);
                        enum_ = (Enum)enumType.cast(o);
                    }
                    catch (ClassCastException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                        throw new UaSerializationException(0x80070000L, (Throwable)e);
                    }
                    return (T)enum_;
                }
                throw new UaSerializationException(0x80070000L, "invalid enum value: " + s);
            }
            finally {
                this.currentNode = this.currentNode.getNextSibling();
            }
        }
        try {
            return (T)((Enum)enumType.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new UaSerializationException(0x80070000L, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object readStruct(String field, NodeId dataTypeId) throws UaSerializationException {
        if (this.currentNode(field)) {
            Node node = this.currentNode;
            OpcUaXmlDataTypeCodec codec = (OpcUaXmlDataTypeCodec)this.context.getDataTypeManager().getCodec(OpcUaDefaultXmlEncoding.ENCODING_NAME, dataTypeId);
            if (codec == null) {
                throw new UaSerializationException(0x80070000L, "no codec registered: " + dataTypeId);
            }
            try {
                this.currentNode = node.getFirstChild();
                Object t = codec.decode(this.context, this);
                return t;
            }
            finally {
                this.currentNode = node.getNextSibling();
            }
        }
        return null;
    }

    @Override
    public Object readStruct(String field, ExpandedNodeId dataTypeId) throws UaSerializationException {
        return dataTypeId.toNodeId(this.context.getNamespaceTable()).map(id -> this.readStruct(field, (NodeId)id)).orElseThrow(() -> new UaSerializationException(0x80070000L, "no codec registered: " + dataTypeId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object readStruct(String field, DataTypeCodec codec) throws UaSerializationException {
        if (codec instanceof OpcUaXmlDataTypeCodec) {
            OpcUaXmlDataTypeCodec xmlCodec = (OpcUaXmlDataTypeCodec)codec;
            if (this.currentNode(field)) {
                Node node = this.currentNode;
                try {
                    this.currentNode = node.getFirstChild();
                    Object t = xmlCodec.decode(this.context, this);
                    return t;
                }
                finally {
                    this.currentNode = node.getNextSibling();
                }
            }
            return null;
        }
        throw new UaSerializationException(0x80070000L, (Throwable)new IllegalArgumentException("codec: " + codec));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] readArray(String field, Function<String, T> decoder, Class<T> clazz) throws UaSerializationException {
        if (this.currentNode(field)) {
            int i;
            Node node = this.currentNode;
            ArrayList<T> values = new ArrayList<T>();
            Node listNode = node.getFirstChild();
            if (listNode != null) {
                NodeList children = listNode.getChildNodes();
                for (i = 0; i < children.getLength(); ++i) {
                    this.currentNode = children.item(i);
                    if (this.currentNode.getNodeType() != 1) continue;
                    values.add(decoder.apply(this.currentNode.getLocalName()));
                }
            }
            try {
                this.checkArrayLength(values.size());
                Object array = Array.newInstance(clazz, values.size());
                for (i = 0; i < values.size(); ++i) {
                    Array.set(array, i, values.get(i));
                }
                Object[] objectArray = (Object[])array;
                return objectArray;
            }
            finally {
                this.currentNode = node.getNextSibling();
            }
        }
        return null;
    }

    @Override
    public Boolean[] readBooleanArray(String field) throws UaSerializationException {
        return this.readArray(field, this::readBoolean, Boolean.class);
    }

    @Override
    public Byte[] readSByteArray(String field) throws UaSerializationException {
        return this.readArray(field, this::readSByte, Byte.class);
    }

    @Override
    public Short[] readInt16Array(String field) throws UaSerializationException {
        return this.readArray(field, this::readInt16, Short.class);
    }

    @Override
    public Integer[] readInt32Array(String field) throws UaSerializationException {
        return this.readArray(field, this::readInt32, Integer.class);
    }

    @Override
    public Long[] readInt64Array(String field) throws UaSerializationException {
        return this.readArray(field, this::readInt64, Long.class);
    }

    @Override
    public UByte[] readByteArray(String field) throws UaSerializationException {
        return this.readArray(field, this::readByte, UByte.class);
    }

    @Override
    public UShort[] readUInt16Array(String field) throws UaSerializationException {
        return this.readArray(field, this::readUInt16, UShort.class);
    }

    @Override
    public UInteger[] readUInt32Array(String field) throws UaSerializationException {
        return this.readArray(field, this::readUInt32, UInteger.class);
    }

    @Override
    public ULong[] readUInt64Array(String field) throws UaSerializationException {
        return this.readArray(field, this::readUInt64, ULong.class);
    }

    @Override
    public Float[] readFloatArray(String field) throws UaSerializationException {
        return this.readArray(field, this::readFloat, Float.class);
    }

    @Override
    public Double[] readDoubleArray(String field) throws UaSerializationException {
        return this.readArray(field, this::readDouble, Double.class);
    }

    @Override
    public String[] readStringArray(String field) throws UaSerializationException {
        return this.readArray(field, this::readString, String.class);
    }

    @Override
    public DateTime[] readDateTimeArray(String field) throws UaSerializationException {
        return this.readArray(field, this::readDateTime, DateTime.class);
    }

    @Override
    public UUID[] readGuidArray(String field) throws UaSerializationException {
        return this.readArray(field, this::readGuid, UUID.class);
    }

    @Override
    public ByteString[] readByteStringArray(String field) throws UaSerializationException {
        return this.readArray(field, this::readByteString, ByteString.class);
    }

    @Override
    public XmlElement[] readXmlElementArray(String field) throws UaSerializationException {
        return this.readArray(field, this::readXmlElement, XmlElement.class);
    }

    @Override
    public NodeId[] readNodeIdArray(String field) throws UaSerializationException {
        return this.readArray(field, this::readNodeId, NodeId.class);
    }

    @Override
    public ExpandedNodeId[] readExpandedNodeIdArray(String field) throws UaSerializationException {
        return this.readArray(field, this::readExpandedNodeId, ExpandedNodeId.class);
    }

    @Override
    public StatusCode[] readStatusCodeArray(String field) throws UaSerializationException {
        return this.readArray(field, this::readStatusCode, StatusCode.class);
    }

    @Override
    public QualifiedName[] readQualifiedNameArray(String field) throws UaSerializationException {
        return this.readArray(field, this::readQualifiedName, QualifiedName.class);
    }

    @Override
    public LocalizedText[] readLocalizedTextArray(String field) throws UaSerializationException {
        return this.readArray(field, this::readLocalizedText, LocalizedText.class);
    }

    @Override
    public ExtensionObject[] readExtensionObjectArray(String field) throws UaSerializationException {
        return this.readArray(field, this::readExtensionObject, ExtensionObject.class);
    }

    @Override
    public DataValue[] readDataValueArray(String field) throws UaSerializationException {
        return this.readArray(field, this::readDataValue, DataValue.class);
    }

    @Override
    public Variant[] readVariantArray(String field) throws UaSerializationException {
        return this.readArray(field, this::readVariant, Variant.class);
    }

    @Override
    public DiagnosticInfo[] readDiagnosticInfoArray(String field) throws UaSerializationException {
        return this.readArray(field, this::readDiagnosticInfo, DiagnosticInfo.class);
    }

    @Override
    public <T extends Enum<?>> Object[] readEnumArray(String field, Class<T> enumType) throws UaSerializationException {
        return this.readArray(field, s -> this.readEnum((String)s, enumType), enumType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] readStructArray(String field, NodeId dataTypeId) throws UaSerializationException {
        if (this.currentNode(field)) {
            Node node = this.currentNode;
            OpcUaXmlDataTypeCodec codec = (OpcUaXmlDataTypeCodec)this.context.getDataTypeManager().getCodec(OpcUaDefaultXmlEncoding.ENCODING_NAME, dataTypeId);
            if (codec == null) {
                throw new UaSerializationException(0x80070000L, "no codec registered: " + dataTypeId);
            }
            ArrayList<Object> values = new ArrayList<Object>();
            Node listNode = node.getFirstChild();
            NodeList children = listNode.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                this.currentNode = children.item(i);
                if (this.currentNode.getNodeType() != 1) continue;
                values.add(this.readStruct(this.currentNode.getLocalName(), dataTypeId));
            }
            try {
                Object array = Array.newInstance(codec.getType(), values.size());
                for (int i = 0; i < values.size(); ++i) {
                    Array.set(array, i, values.get(i));
                }
                Object[] objectArray = (Object[])array;
                return objectArray;
            }
            finally {
                this.currentNode = node.getNextSibling();
            }
        }
        return null;
    }

    @Override
    public Object[] readStructArray(String field, ExpandedNodeId dataTypeId) throws UaSerializationException {
        NodeId dataTypeNodeId = dataTypeId.toNodeId(this.context.getNamespaceTable()).orElse(null);
        if (dataTypeNodeId != null) {
            return this.readStructArray(field, dataTypeNodeId);
        }
        if (dataTypeId.isLocal()) {
            throw new UaSerializationException(0x80070000L, "namespace not registered: " + dataTypeId.getNamespaceUri());
        }
        throw new UaSerializationException(0x80070000L, "ExpandedNodeId not local: " + dataTypeId);
    }

    private void checkArrayLength(int length) throws UaSerializationException {
        if (length > this.context.getEncodingLimits().getMaxMessageSize()) {
            throw new UaSerializationException(0x80080000L, String.format("array length exceeds max message size (length=%s, max=%s)", length, this.context.getEncodingLimits().getMaxMessageSize()));
        }
    }

    private static XmlElement nodeToXmlElement(Node node) throws UaSerializationException {
        try {
            StringWriter sw = new StringWriter();
            Transformer transformer = SecureXmlUtil.SHARED_TRANSFORMER_FACTORY.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(new DOMSource(node), new StreamResult(sw));
            return new XmlElement(sw.toString());
        }
        catch (TransformerException e) {
            throw new UaSerializationException(0x80070000L, (Throwable)e);
        }
    }

    private static Map<String, Node> nodeMap(NodeList nodeList) {
        LinkedHashMap<String, Node> nodeMap = new LinkedHashMap<String, Node>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            nodeMap.put(node.getLocalName(), node);
        }
        return nodeMap;
    }
}

