/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.subscription.task.execution;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.pipe.agent.task.execution.PipeSubtaskExecutor;
import org.apache.iotdb.commons.pipe.agent.task.execution.PipeSubtaskScheduler;
import org.apache.iotdb.commons.subscription.config.SubscriptionConfig;
import org.apache.iotdb.db.pipe.agent.task.execution.PipeConnectorSubtaskExecutor;
import org.apache.iotdb.db.subscription.task.execution.SubscriptionSubtaskScheduler;
import org.apache.iotdb.db.subscription.task.subtask.SubscriptionReceiverSubtask;

public class SubscriptionSubtaskExecutor
extends PipeConnectorSubtaskExecutor {
    private static final AtomicInteger id = new AtomicInteger(0);
    private final AtomicLong submittedReceiverSubtasks = new AtomicLong(0L);

    public SubscriptionSubtaskExecutor() {
        super(SubscriptionConfig.getInstance().getSubscriptionSubtaskExecutorMaxThreadNum(), ThreadName.SUBSCRIPTION_EXECUTOR_POOL.getName() + "-" + id.getAndIncrement());
    }

    protected PipeSubtaskScheduler schedulerSupplier(PipeSubtaskExecutor executor) {
        return new SubscriptionSubtaskScheduler((SubscriptionSubtaskExecutor)executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeReceiverSubtask(SubscriptionReceiverSubtask subtask, long timeoutMs) throws Exception {
        if (!super.hasAvailableThread()) {
            subtask.call();
            return;
        }
        this.submittedReceiverSubtasks.incrementAndGet();
        try {
            ListenableFuture future = this.subtaskWorkerThreadPoolExecutor.submit((Callable)subtask);
            try {
                future.get(timeoutMs, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                future.cancel(true);
                throw e;
            }
            catch (ExecutionException | TimeoutException e) {
                future.cancel(true);
                throw e;
            }
        }
        finally {
            this.submittedReceiverSubtasks.decrementAndGet();
        }
    }

    public boolean hasSubmittedReceiverSubtasks() {
        return this.submittedReceiverSubtasks.get() > 0L;
    }
}

