/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cli.utils;

import java.io.InputStream;
import java.io.PrintStream;
import org.apache.iotdb.cli.type.ExitType;
import org.apache.iotdb.cli.utils.IoTPrinter;
import org.jline.reader.LineReader;

public class CliContext {
    private final InputStream in;
    private final PrintStream out;
    private final PrintStream err;
    private final IoTPrinter printer;
    private final ExitType exitType;
    private LineReader lineReader;

    public CliContext(InputStream in, PrintStream out, PrintStream err, ExitType exitType) {
        this.in = in;
        this.out = out;
        this.err = err;
        this.exitType = exitType;
        this.printer = new IoTPrinter(out);
    }

    public InputStream getIn() {
        return this.in;
    }

    public PrintStream getOut() {
        return this.out;
    }

    public PrintStream getErr() {
        return this.err;
    }

    public IoTPrinter getPrinter() {
        return this.printer;
    }

    public ExitType getExitType() {
        return this.exitType;
    }

    public LineReader getLineReader() {
        return this.lineReader;
    }

    public void setLineReader(LineReader lineReader) {
        this.lineReader = lineReader;
    }

    public void exit(int exitCode) {
        if (this.exitType != ExitType.SYSTEM_EXIT) {
            throw new RuntimeException("Exiting with code " + exitCode);
        }
        System.exit(exitCode);
    }
}

