/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.auth;

import java.util.EnumSet;
import org.apache.polaris.core.entity.PolarisPrivilege;

public enum PolarisAuthorizableOperation {
    LIST_NAMESPACES(PolarisPrivilege.NAMESPACE_LIST),
    CREATE_NAMESPACE(PolarisPrivilege.NAMESPACE_CREATE),
    LOAD_NAMESPACE_METADATA(PolarisPrivilege.NAMESPACE_READ_PROPERTIES),
    NAMESPACE_EXISTS(PolarisPrivilege.NAMESPACE_LIST),
    DROP_NAMESPACE(PolarisPrivilege.NAMESPACE_DROP),
    UPDATE_NAMESPACE_PROPERTIES(PolarisPrivilege.NAMESPACE_WRITE_PROPERTIES),
    LIST_TABLES(PolarisPrivilege.TABLE_LIST),
    CREATE_TABLE_DIRECT(PolarisPrivilege.TABLE_CREATE),
    CREATE_TABLE_DIRECT_WITH_WRITE_DELEGATION(EnumSet.of(PolarisPrivilege.TABLE_CREATE, PolarisPrivilege.TABLE_WRITE_DATA)),
    CREATE_TABLE_STAGED(PolarisPrivilege.TABLE_CREATE),
    CREATE_TABLE_STAGED_WITH_WRITE_DELEGATION(EnumSet.of(PolarisPrivilege.TABLE_CREATE, PolarisPrivilege.TABLE_WRITE_DATA)),
    REGISTER_TABLE(PolarisPrivilege.TABLE_CREATE),
    LOAD_TABLE(PolarisPrivilege.TABLE_READ_PROPERTIES),
    LOAD_TABLE_WITH_READ_DELEGATION(PolarisPrivilege.TABLE_READ_DATA),
    LOAD_TABLE_WITH_WRITE_DELEGATION(PolarisPrivilege.TABLE_WRITE_DATA),
    UPDATE_TABLE(PolarisPrivilege.TABLE_WRITE_PROPERTIES),
    UPDATE_TABLE_FOR_STAGED_CREATE(PolarisPrivilege.TABLE_CREATE),
    DROP_TABLE_WITHOUT_PURGE(PolarisPrivilege.TABLE_DROP),
    DROP_TABLE_WITH_PURGE(EnumSet.of(PolarisPrivilege.TABLE_DROP, PolarisPrivilege.TABLE_WRITE_DATA)),
    TABLE_EXISTS(PolarisPrivilege.TABLE_LIST),
    RENAME_TABLE(PolarisPrivilege.TABLE_DROP, EnumSet.of(PolarisPrivilege.TABLE_LIST, PolarisPrivilege.TABLE_CREATE)),
    COMMIT_TRANSACTION(EnumSet.of(PolarisPrivilege.TABLE_WRITE_PROPERTIES, PolarisPrivilege.TABLE_CREATE)),
    LIST_VIEWS(PolarisPrivilege.VIEW_LIST),
    CREATE_VIEW(PolarisPrivilege.VIEW_CREATE),
    LOAD_VIEW(PolarisPrivilege.VIEW_READ_PROPERTIES),
    REPLACE_VIEW(PolarisPrivilege.VIEW_WRITE_PROPERTIES),
    DROP_VIEW(PolarisPrivilege.VIEW_DROP),
    VIEW_EXISTS(PolarisPrivilege.VIEW_LIST),
    RENAME_VIEW(PolarisPrivilege.VIEW_DROP, EnumSet.of(PolarisPrivilege.VIEW_LIST, PolarisPrivilege.VIEW_CREATE)),
    REPORT_METRICS(EnumSet.noneOf(PolarisPrivilege.class)),
    SEND_NOTIFICATIONS(EnumSet.of(PolarisPrivilege.TABLE_CREATE, PolarisPrivilege.TABLE_WRITE_PROPERTIES, PolarisPrivilege.TABLE_DROP, PolarisPrivilege.NAMESPACE_CREATE, PolarisPrivilege.NAMESPACE_DROP)),
    LIST_CATALOGS(PolarisPrivilege.CATALOG_LIST),
    CREATE_CATALOG(PolarisPrivilege.CATALOG_CREATE),
    GET_CATALOG(PolarisPrivilege.CATALOG_READ_PROPERTIES),
    UPDATE_CATALOG(PolarisPrivilege.CATALOG_WRITE_PROPERTIES),
    DELETE_CATALOG(PolarisPrivilege.CATALOG_DROP),
    LIST_PRINCIPALS(PolarisPrivilege.PRINCIPAL_LIST),
    CREATE_PRINCIPAL(PolarisPrivilege.PRINCIPAL_CREATE),
    GET_PRINCIPAL(PolarisPrivilege.PRINCIPAL_READ_PROPERTIES),
    UPDATE_PRINCIPAL(PolarisPrivilege.PRINCIPAL_WRITE_PROPERTIES),
    DELETE_PRINCIPAL(PolarisPrivilege.PRINCIPAL_DROP),
    ROTATE_CREDENTIALS(PolarisPrivilege.PRINCIPAL_ROTATE_CREDENTIALS),
    RESET_CREDENTIALS(PolarisPrivilege.PRINCIPAL_RESET_CREDENTIALS),
    LIST_PRINCIPAL_ROLES_ASSIGNED(PolarisPrivilege.PRINCIPAL_LIST_GRANTS),
    ASSIGN_PRINCIPAL_ROLE(PolarisPrivilege.PRINCIPAL_ROLE_MANAGE_GRANTS_ON_SECURABLE),
    REVOKE_PRINCIPAL_ROLE(PolarisPrivilege.PRINCIPAL_ROLE_MANAGE_GRANTS_ON_SECURABLE, PolarisPrivilege.PRINCIPAL_MANAGE_GRANTS_FOR_GRANTEE),
    LIST_PRINCIPAL_ROLES(PolarisPrivilege.PRINCIPAL_ROLE_LIST),
    CREATE_PRINCIPAL_ROLE(PolarisPrivilege.PRINCIPAL_ROLE_CREATE),
    GET_PRINCIPAL_ROLE(PolarisPrivilege.PRINCIPAL_ROLE_READ_PROPERTIES),
    UPDATE_PRINCIPAL_ROLE(PolarisPrivilege.PRINCIPAL_ROLE_WRITE_PROPERTIES),
    DELETE_PRINCIPAL_ROLE(PolarisPrivilege.PRINCIPAL_ROLE_DROP),
    LIST_ASSIGNEE_PRINCIPALS_FOR_PRINCIPAL_ROLE(PolarisPrivilege.PRINCIPAL_ROLE_LIST_GRANTS),
    LIST_CATALOG_ROLES_FOR_PRINCIPAL_ROLE(PolarisPrivilege.PRINCIPAL_ROLE_LIST_GRANTS),
    ASSIGN_CATALOG_ROLE_TO_PRINCIPAL_ROLE(PolarisPrivilege.CATALOG_ROLE_MANAGE_GRANTS_ON_SECURABLE),
    REVOKE_CATALOG_ROLE_FROM_PRINCIPAL_ROLE(PolarisPrivilege.CATALOG_ROLE_MANAGE_GRANTS_ON_SECURABLE, PolarisPrivilege.PRINCIPAL_ROLE_MANAGE_GRANTS_FOR_GRANTEE),
    LIST_CATALOG_ROLES(PolarisPrivilege.CATALOG_ROLE_LIST),
    CREATE_CATALOG_ROLE(PolarisPrivilege.CATALOG_ROLE_CREATE),
    GET_CATALOG_ROLE(PolarisPrivilege.CATALOG_ROLE_READ_PROPERTIES),
    UPDATE_CATALOG_ROLE(PolarisPrivilege.CATALOG_ROLE_WRITE_PROPERTIES),
    DELETE_CATALOG_ROLE(PolarisPrivilege.CATALOG_ROLE_DROP),
    LIST_ASSIGNEE_PRINCIPAL_ROLES_FOR_CATALOG_ROLE(PolarisPrivilege.CATALOG_ROLE_LIST_GRANTS),
    LIST_GRANTS_FOR_CATALOG_ROLE(PolarisPrivilege.CATALOG_ROLE_LIST_GRANTS),
    ADD_ROOT_GRANT_TO_PRINCIPAL_ROLE(PolarisPrivilege.SERVICE_MANAGE_ACCESS),
    REVOKE_ROOT_GRANT_FROM_PRINCIPAL_ROLE(PolarisPrivilege.SERVICE_MANAGE_ACCESS, PolarisPrivilege.PRINCIPAL_ROLE_MANAGE_GRANTS_FOR_GRANTEE),
    LIST_GRANTS_ON_ROOT(PolarisPrivilege.SERVICE_MANAGE_ACCESS),
    ADD_PRINCIPAL_GRANT_TO_PRINCIPAL_ROLE(PolarisPrivilege.PRINCIPAL_MANAGE_GRANTS_ON_SECURABLE),
    REVOKE_PRINCIPAL_GRANT_FROM_PRINCIPAL_ROLE(PolarisPrivilege.PRINCIPAL_MANAGE_GRANTS_ON_SECURABLE, PolarisPrivilege.PRINCIPAL_ROLE_MANAGE_GRANTS_FOR_GRANTEE),
    LIST_GRANTS_ON_PRINCIPAL(PolarisPrivilege.PRINCIPAL_LIST_GRANTS),
    ADD_PRINCIPAL_ROLE_GRANT_TO_PRINCIPAL_ROLE(PolarisPrivilege.PRINCIPAL_ROLE_MANAGE_GRANTS_ON_SECURABLE),
    REVOKE_PRINCIPAL_ROLE_GRANT_FROM_PRINCIPAL_ROLE(PolarisPrivilege.PRINCIPAL_ROLE_MANAGE_GRANTS_ON_SECURABLE, PolarisPrivilege.PRINCIPAL_ROLE_MANAGE_GRANTS_FOR_GRANTEE),
    LIST_GRANTS_ON_PRINCIPAL_ROLE(PolarisPrivilege.PRINCIPAL_ROLE_LIST_GRANTS),
    ADD_CATALOG_ROLE_GRANT_TO_CATALOG_ROLE(PolarisPrivilege.CATALOG_ROLE_MANAGE_GRANTS_ON_SECURABLE),
    REVOKE_CATALOG_ROLE_GRANT_FROM_CATALOG_ROLE(PolarisPrivilege.CATALOG_ROLE_MANAGE_GRANTS_ON_SECURABLE, PolarisPrivilege.CATALOG_ROLE_MANAGE_GRANTS_FOR_GRANTEE),
    LIST_GRANTS_ON_CATALOG_ROLE(PolarisPrivilege.CATALOG_ROLE_LIST_GRANTS),
    ADD_CATALOG_GRANT_TO_CATALOG_ROLE(PolarisPrivilege.CATALOG_MANAGE_GRANTS_ON_SECURABLE),
    REVOKE_CATALOG_GRANT_FROM_CATALOG_ROLE(PolarisPrivilege.CATALOG_MANAGE_GRANTS_ON_SECURABLE, PolarisPrivilege.CATALOG_ROLE_MANAGE_GRANTS_FOR_GRANTEE),
    LIST_GRANTS_ON_CATALOG(PolarisPrivilege.CATALOG_LIST_GRANTS),
    ADD_NAMESPACE_GRANT_TO_CATALOG_ROLE(PolarisPrivilege.NAMESPACE_MANAGE_GRANTS_ON_SECURABLE),
    REVOKE_NAMESPACE_GRANT_FROM_CATALOG_ROLE(PolarisPrivilege.NAMESPACE_MANAGE_GRANTS_ON_SECURABLE, PolarisPrivilege.CATALOG_ROLE_MANAGE_GRANTS_FOR_GRANTEE),
    LIST_GRANTS_ON_NAMESPACE(PolarisPrivilege.NAMESPACE_LIST_GRANTS),
    ADD_TABLE_GRANT_TO_CATALOG_ROLE(PolarisPrivilege.TABLE_MANAGE_GRANTS_ON_SECURABLE),
    REVOKE_TABLE_GRANT_FROM_CATALOG_ROLE(PolarisPrivilege.TABLE_MANAGE_GRANTS_ON_SECURABLE, PolarisPrivilege.CATALOG_ROLE_MANAGE_GRANTS_FOR_GRANTEE),
    LIST_GRANTS_ON_TABLE(PolarisPrivilege.TABLE_LIST_GRANTS),
    ADD_VIEW_GRANT_TO_CATALOG_ROLE(PolarisPrivilege.VIEW_MANAGE_GRANTS_ON_SECURABLE),
    REVOKE_VIEW_GRANT_FROM_CATALOG_ROLE(PolarisPrivilege.VIEW_MANAGE_GRANTS_ON_SECURABLE, PolarisPrivilege.CATALOG_ROLE_MANAGE_GRANTS_FOR_GRANTEE),
    LIST_GRANTS_ON_VIEW(PolarisPrivilege.VIEW_LIST_GRANTS),
    CREATE_POLICY(PolarisPrivilege.POLICY_CREATE),
    LOAD_POLICY(PolarisPrivilege.POLICY_READ),
    DROP_POLICY(PolarisPrivilege.POLICY_DROP),
    UPDATE_POLICY(PolarisPrivilege.POLICY_WRITE),
    LIST_POLICY(PolarisPrivilege.POLICY_LIST),
    ATTACH_POLICY_TO_CATALOG(PolarisPrivilege.POLICY_ATTACH, PolarisPrivilege.CATALOG_ATTACH_POLICY),
    ATTACH_POLICY_TO_NAMESPACE(PolarisPrivilege.POLICY_ATTACH, PolarisPrivilege.NAMESPACE_ATTACH_POLICY),
    ATTACH_POLICY_TO_TABLE(PolarisPrivilege.POLICY_ATTACH, PolarisPrivilege.TABLE_ATTACH_POLICY),
    DETACH_POLICY_FROM_CATALOG(PolarisPrivilege.POLICY_DETACH, PolarisPrivilege.CATALOG_DETACH_POLICY),
    DETACH_POLICY_FROM_NAMESPACE(PolarisPrivilege.POLICY_DETACH, PolarisPrivilege.NAMESPACE_DETACH_POLICY),
    DETACH_POLICY_FROM_TABLE(PolarisPrivilege.POLICY_DETACH, PolarisPrivilege.TABLE_DETACH_POLICY),
    GET_APPLICABLE_POLICIES_ON_CATALOG(PolarisPrivilege.CATALOG_READ_PROPERTIES),
    GET_APPLICABLE_POLICIES_ON_NAMESPACE(PolarisPrivilege.NAMESPACE_READ_PROPERTIES),
    GET_APPLICABLE_POLICIES_ON_TABLE(PolarisPrivilege.TABLE_READ_PROPERTIES),
    ADD_POLICY_GRANT_TO_CATALOG_ROLE(PolarisPrivilege.POLICY_MANAGE_GRANTS_ON_SECURABLE),
    REVOKE_POLICY_GRANT_FROM_CATALOG_ROLE(PolarisPrivilege.POLICY_MANAGE_GRANTS_ON_SECURABLE, PolarisPrivilege.CATALOG_ROLE_MANAGE_GRANTS_FOR_GRANTEE),
    ASSIGN_TABLE_UUID(PolarisPrivilege.TABLE_ASSIGN_UUID),
    UPGRADE_TABLE_FORMAT_VERSION(PolarisPrivilege.TABLE_UPGRADE_FORMAT_VERSION),
    ADD_TABLE_SCHEMA(PolarisPrivilege.TABLE_ADD_SCHEMA),
    SET_TABLE_CURRENT_SCHEMA(PolarisPrivilege.TABLE_SET_CURRENT_SCHEMA),
    ADD_TABLE_PARTITION_SPEC(PolarisPrivilege.TABLE_ADD_PARTITION_SPEC),
    ADD_TABLE_SORT_ORDER(PolarisPrivilege.TABLE_ADD_SORT_ORDER),
    SET_TABLE_DEFAULT_SORT_ORDER(PolarisPrivilege.TABLE_SET_DEFAULT_SORT_ORDER),
    ADD_TABLE_SNAPSHOT(PolarisPrivilege.TABLE_ADD_SNAPSHOT),
    SET_TABLE_SNAPSHOT_REF(PolarisPrivilege.TABLE_SET_SNAPSHOT_REF),
    REMOVE_TABLE_SNAPSHOTS(PolarisPrivilege.TABLE_REMOVE_SNAPSHOTS),
    REMOVE_TABLE_SNAPSHOT_REF(PolarisPrivilege.TABLE_REMOVE_SNAPSHOT_REF),
    SET_TABLE_LOCATION(PolarisPrivilege.TABLE_SET_LOCATION),
    SET_TABLE_PROPERTIES(PolarisPrivilege.TABLE_SET_PROPERTIES),
    REMOVE_TABLE_PROPERTIES(PolarisPrivilege.TABLE_REMOVE_PROPERTIES),
    SET_TABLE_STATISTICS(PolarisPrivilege.TABLE_SET_STATISTICS),
    REMOVE_TABLE_STATISTICS(PolarisPrivilege.TABLE_REMOVE_STATISTICS),
    REMOVE_TABLE_PARTITION_SPECS(PolarisPrivilege.TABLE_REMOVE_PARTITION_SPECS);

    private final EnumSet<PolarisPrivilege> privilegesOnTarget;
    private final EnumSet<PolarisPrivilege> privilegesOnSecondary;

    private PolarisAuthorizableOperation(PolarisPrivilege targetPrivilege) {
        this(targetPrivilege == null ? null : EnumSet.of(targetPrivilege), null);
    }

    private PolarisAuthorizableOperation(EnumSet<PolarisPrivilege> privilegesOnTarget) {
        this(privilegesOnTarget, null);
    }

    private PolarisAuthorizableOperation(PolarisPrivilege targetPrivilege, EnumSet<PolarisPrivilege> privilegesOnSecondary) {
        this(targetPrivilege == null ? null : EnumSet.of(targetPrivilege), privilegesOnSecondary);
    }

    private PolarisAuthorizableOperation(PolarisPrivilege targetPrivilege, PolarisPrivilege secondaryPrivilege) {
        this(targetPrivilege == null ? null : EnumSet.of(targetPrivilege), secondaryPrivilege == null ? null : EnumSet.of(secondaryPrivilege));
    }

    private PolarisAuthorizableOperation(EnumSet<PolarisPrivilege> privilegesOnTarget, EnumSet<PolarisPrivilege> privilegesOnSecondary) {
        this.privilegesOnTarget = privilegesOnTarget == null ? EnumSet.noneOf(PolarisPrivilege.class) : privilegesOnTarget;
        this.privilegesOnSecondary = privilegesOnSecondary == null ? EnumSet.noneOf(PolarisPrivilege.class) : privilegesOnSecondary;
    }

    public EnumSet<PolarisPrivilege> getPrivilegesOnTarget() {
        return this.privilegesOnTarget;
    }

    public EnumSet<PolarisPrivilege> getPrivilegesOnSecondary() {
        return this.privilegesOnSecondary;
    }
}

