/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.storage;

public enum StorageAccessProperty {
    AWS_KEY_ID(String.class, "s3.access-key-id", "the aws access key id"),
    AWS_SECRET_KEY(String.class, "s3.secret-access-key", "the aws access key secret"),
    AWS_TOKEN(String.class, "s3.session-token", "the aws scoped access token"),
    AWS_SESSION_TOKEN_EXPIRES_AT_MS(String.class, "s3.session-token-expires-at-ms", "the time the aws session token expires, in milliseconds", true, true),
    AWS_ENDPOINT(String.class, "s3.endpoint", "the S3 endpoint to use for requests", false),
    AWS_PATH_STYLE_ACCESS(Boolean.class, "s3.path-style-access", "whether to use S3 path style access", false),
    CLIENT_REGION(String.class, "client.region", "region to configure client for making requests to AWS"),
    AWS_REFRESH_CREDENTIALS_ENDPOINT(String.class, "client.refresh-credentials-endpoint", "the endpoint to load vended credentials for a table from the catalog", false, false),
    GCS_ACCESS_TOKEN(String.class, "gcs.oauth2.token", "the gcs scoped access token"),
    GCS_ACCESS_TOKEN_EXPIRES_AT(String.class, "gcs.oauth2.token-expires-at", "the time the gcs access token expires, in milliseconds", true, true),
    GCS_REFRESH_CREDENTIALS_ENDPOINT(String.class, "gcs.oauth2.refresh-credentials-endpoint", "the endpoint to load vended credentials for a table from the catalog", false, false),
    AZURE_ACCESS_TOKEN(String.class, "", "the azure scoped access token"),
    AZURE_SAS_TOKEN(String.class, "adls.sas-token.", "an azure shared access signature token"),
    AZURE_REFRESH_CREDENTIALS_ENDPOINT(String.class, "adls.refresh-credentials-endpoint", "the endpoint to load vended credentials for a table from the catalog", false, false),
    EXPIRATION_TIME(Long.class, "expiration-time", "the expiration time for the access token, in milliseconds", true, true);

    private final Class valueType;
    private final String propertyName;
    private final String description;
    private final boolean isCredential;
    private final boolean isExpirationTimestamp;

    private StorageAccessProperty(Class valueType, String propertyName, String description) {
        this(valueType, propertyName, description, true);
    }

    private StorageAccessProperty(Class valueType, String propertyName, String description, boolean isCredential) {
        this(valueType, propertyName, description, isCredential, false);
    }

    private StorageAccessProperty(Class valueType, String propertyName, String description, boolean isCredential, boolean isExpirationTimestamp) {
        this.valueType = valueType;
        this.propertyName = propertyName;
        this.description = description;
        this.isCredential = isCredential;
        this.isExpirationTimestamp = isExpirationTimestamp;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public boolean isCredential() {
        return this.isCredential;
    }

    public boolean isExpirationTimestamp() {
        return this.isExpirationTimestamp;
    }
}

