/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.persistence.pagination;

import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.polaris.core.persistence.pagination.PageToken;
import org.apache.polaris.core.persistence.pagination.PageTokenUtil;
import org.apache.polaris.core.persistence.pagination.Token;

public class Page<T> {
    private final PageToken request;
    private final List<T> items;
    @Nullable
    private final Token nextToken;

    private Page(PageToken request, @Nullable Token nextToken, List<T> items) {
        this.request = request;
        this.nextToken = nextToken;
        this.items = items;
    }

    public static <T> Page<T> fromItems(List<T> items) {
        return new Page<T>(PageToken.readEverything(), null, items);
    }

    public static <R, T> Page<R> mapped(PageToken request, Stream<T> items, Function<T, R> mapper, Function<T, Token> tokenBuilder) {
        List data;
        Object last = null;
        if (!request.paginationRequested()) {
            data = items.map(mapper).collect(Collectors.toList());
        } else {
            data = new ArrayList(request.pageSize().orElse(10));
            Iterator it = Spliterators.iterator(items.spliterator());
            int limit = request.pageSize().orElse(Integer.MAX_VALUE);
            while (it.hasNext() && data.size() < limit) {
                last = it.next();
                data.add(mapper.apply(last));
            }
            if (data.size() < limit || !it.hasNext()) {
                last = null;
            }
        }
        return new Page(request, tokenBuilder.apply(last), data);
    }

    public List<T> items() {
        return this.items;
    }

    @Nullable
    public String encodedResponseToken() {
        return PageTokenUtil.encodePageToken(this.request, this.nextToken);
    }

    public <R> Page<R> map(Function<T, R> mapper) {
        return new Page(this.request, this.nextToken, this.items.stream().map(mapper).collect(Collectors.toList()));
    }
}

