/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.persistence.bootstrap;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.apache.polaris.core.persistence.bootstrap.SchemaOptions;
import org.immutables.value.Generated;

@Generated(from="SchemaOptions", generator="Immutables")
public final class ImmutableSchemaOptions
implements SchemaOptions {
    @Nullable
    private final Integer schemaVersion;
    @Nullable
    private final String schemaFile;
    private transient int hashCode;

    private ImmutableSchemaOptions(@Nullable Integer schemaVersion, @Nullable String schemaFile) {
        this.schemaVersion = schemaVersion;
        this.schemaFile = schemaFile;
    }

    @Override
    @Nullable
    public Integer schemaVersion() {
        return this.schemaVersion;
    }

    @Override
    @Nullable
    public String schemaFile() {
        return this.schemaFile;
    }

    public final ImmutableSchemaOptions withSchemaVersion(@Nullable Integer value) {
        if (Objects.equals(this.schemaVersion, value)) {
            return this;
        }
        return ImmutableSchemaOptions.validate(new ImmutableSchemaOptions(value, this.schemaFile));
    }

    public final ImmutableSchemaOptions withSchemaFile(@Nullable String value) {
        if (Objects.equals(this.schemaFile, value)) {
            return this;
        }
        return ImmutableSchemaOptions.validate(new ImmutableSchemaOptions(this.schemaVersion, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSchemaOptions && this.equalsByValue((ImmutableSchemaOptions)another);
    }

    private boolean equalsByValue(ImmutableSchemaOptions another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return Objects.equals(this.schemaVersion, another.schemaVersion) && Objects.equals(this.schemaFile, another.schemaFile);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.schemaVersion);
        h += (h << 5) + Objects.hashCode(this.schemaFile);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SchemaOptions").omitNullValues().add("schemaVersion", (Object)this.schemaVersion).add("schemaFile", (Object)this.schemaFile).toString();
    }

    private static ImmutableSchemaOptions validate(ImmutableSchemaOptions instance) {
        instance.validate();
        return instance;
    }

    public static ImmutableSchemaOptions copyOf(SchemaOptions instance) {
        if (instance instanceof ImmutableSchemaOptions) {
            return (ImmutableSchemaOptions)instance;
        }
        return ImmutableSchemaOptions.builder().from(instance).build();
    }

    public Builder toBuilder() {
        return ImmutableSchemaOptions.builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SchemaOptions", generator="Immutables")
    public static final class Builder {
        private Integer schemaVersion;
        private String schemaFile;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(SchemaOptions instance) {
            String schemaFileValue;
            Objects.requireNonNull(instance, "instance");
            Integer schemaVersionValue = instance.schemaVersion();
            if (schemaVersionValue != null) {
                this.schemaVersion(schemaVersionValue);
            }
            if ((schemaFileValue = instance.schemaFile()) != null) {
                this.schemaFile(schemaFileValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder schemaVersion(@Nullable Integer schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder schemaFile(@Nullable String schemaFile) {
            this.schemaFile = schemaFile;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder clear() {
            this.schemaVersion = null;
            this.schemaFile = null;
            return this;
        }

        public ImmutableSchemaOptions build() {
            return ImmutableSchemaOptions.validate(new ImmutableSchemaOptions(this.schemaVersion, this.schemaFile));
        }
    }
}

