/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.extension.persistence.impl.eclipselink;

import jakarta.persistence.EntityManager;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.polaris.extension.persistence.impl.eclipselink.models.ModelSequenceId;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.platform.database.PostgreSQLPlatform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PolarisSequenceUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolarisSequenceUtil.class);
    private static final AtomicBoolean initialized = new AtomicBoolean(false);

    private PolarisSequenceUtil() {
    }

    private static void throwIfNotInitialized() {
        if (!initialized.get()) {
            throw new IllegalStateException("Sequence util has not been initialized");
        }
    }

    private static DatabasePlatform getDatabasePlatform(EntityManager session) {
        EntityManagerImpl entityManagerImpl = (EntityManagerImpl)session.unwrap(EntityManagerImpl.class);
        return entityManagerImpl.getDatabaseSession().getPlatform();
    }

    private static void removeSequence(EntityManager session) {
        LOGGER.info("Renaming legacy sequence `POLARIS_SEQ` to `POLARIS_SEQ_UNUSED`");
        String renameSequenceQuery = "ALTER SEQUENCE POLARIS_SEQ RENAME TO POLARIS_SEQ_UNUSED";
        session.createNativeQuery(renameSequenceQuery).executeUpdate();
    }

    public static void initialize(EntityManager session) {
        DatabasePlatform databasePlatform = PolarisSequenceUtil.getDatabasePlatform(session);
        if (!initialized.get()) {
            if (databasePlatform instanceof PostgreSQLPlatform) {
                Optional<Long> result = Optional.empty();
                LOGGER.info("Checking if the sequence POLARIS_SEQ exists");
                String checkSequenceQuery = "SELECT COUNT(*) FROM information_schema.sequences WHERE sequence_name IN ('polaris_seq', 'POLARIS_SEQ')";
                int sequenceExists = ((Number)session.createNativeQuery(checkSequenceQuery).getSingleResult()).intValue();
                if (sequenceExists > 0) {
                    LOGGER.info("POLARIS_SEQ exists, calling NEXTVAL");
                    long queryResult = (Long)session.createNativeQuery("SELECT NEXTVAL('POLARIS_SEQ')").getSingleResult();
                    result = Optional.of(queryResult);
                } else {
                    LOGGER.info("POLARIS_SEQ does not exist, skipping NEXTVAL");
                }
                result.ifPresent(r -> {
                    ModelSequenceId modelSequenceId = new ModelSequenceId();
                    modelSequenceId.setId((Long)r);
                    session.persist((Object)modelSequenceId);
                    session.flush();
                    PolarisSequenceUtil.removeSequence(session);
                });
            }
            initialized.set(true);
        }
    }

    public static Long getNewId(EntityManager session) {
        PolarisSequenceUtil.throwIfNotInitialized();
        ModelSequenceId modelSequenceId = new ModelSequenceId();
        session.persist((Object)modelSequenceId);
        session.flush();
        return modelSequenceId.getId();
    }
}

