/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import java.io.IOException;
import java.util.Set;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionKey;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.io.BaseTaskWriter;
import org.apache.iceberg.io.FileAppenderFactory;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PartitionedWriter<T>
extends BaseTaskWriter<T> {
    private static final Logger LOG = LoggerFactory.getLogger(PartitionedWriter.class);
    private final Set<PartitionKey> completedPartitions = Sets.newHashSet();
    private PartitionKey currentKey = null;
    private BaseTaskWriter.RollingFileWriter currentWriter = null;

    protected PartitionedWriter(PartitionSpec spec, FileFormat format, FileAppenderFactory<T> appenderFactory, OutputFileFactory fileFactory, FileIO io, long targetFileSize) {
        super(spec, format, appenderFactory, fileFactory, io, targetFileSize);
    }

    protected abstract PartitionKey partition(T var1);

    @Override
    public void write(T row) throws IOException {
        PartitionKey key = this.partition(row);
        if (!key.equals((Object)this.currentKey)) {
            if (this.currentKey != null) {
                this.currentWriter.close();
                this.completedPartitions.add(this.currentKey);
            }
            if (this.completedPartitions.contains(key)) {
                PartitionKey existingKey = (PartitionKey)Iterables.find(this.completedPartitions, x$0 -> key.equals(x$0), null);
                LOG.warn("Duplicate key: {} == {}", (Object)existingKey, (Object)key);
                throw new IllegalStateException("Already closed files for partition: " + key.toPath());
            }
            this.currentKey = key.copy();
            this.currentWriter = new BaseTaskWriter.RollingFileWriter((StructLike)this.currentKey);
        }
        this.currentWriter.write(row);
    }

    @Override
    public void close() throws IOException {
        if (this.currentWriter != null) {
            this.currentWriter.close();
        }
    }
}

