/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.actions;

import java.util.List;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.ContentScanTask;

public abstract class RewriteGroupBase<I, T extends ContentScanTask<F>, F extends ContentFile<F>> {
    private final I info;
    private final List<T> fileScanTasks;
    private final long maxOutputFileSize;
    private final long inputSplitSize;
    private final int expectedOutputFiles;

    RewriteGroupBase(I info, List<T> fileScanTasks, long maxOutputFileSize, long inputSplitSize, int expectedOutputFiles) {
        this.info = info;
        this.fileScanTasks = fileScanTasks;
        this.maxOutputFileSize = maxOutputFileSize;
        this.inputSplitSize = inputSplitSize;
        this.expectedOutputFiles = expectedOutputFiles;
    }

    public I info() {
        return this.info;
    }

    public List<T> fileScanTasks() {
        return this.fileScanTasks;
    }

    public long inputFilesSizeInBytes() {
        return this.fileScanTasks.stream().mapToLong(ContentScanTask::length).sum();
    }

    public int inputFileNum() {
        return this.fileScanTasks.size();
    }

    public long maxOutputFileSize() {
        return this.maxOutputFileSize;
    }

    public long inputSplitSize() {
        return this.inputSplitSize;
    }

    public int expectedOutputFiles() {
        return this.expectedOutputFiles;
    }
}

