/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.iceberg.BaseFile;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.GenericDataFile;
import org.apache.iceberg.GenericDeleteFile;
import org.apache.iceberg.GenericManifestEntry;
import org.apache.iceberg.InheritableMetadata;
import org.apache.iceberg.InternalData;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.PartitionData;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.avro.AvroIterable;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.expressions.Evaluator;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.InclusiveMetricsEvaluator;
import org.apache.iceberg.expressions.Projections;
import org.apache.iceberg.io.CloseableGroup;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.metrics.Counter;
import org.apache.iceberg.metrics.ScanMetrics;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.PartitionSet;

public class ManifestReader<F extends ContentFile<F>>
extends CloseableGroup
implements CloseableIterable<F> {
    static final ImmutableList<String> ALL_COLUMNS = ImmutableList.of((Object)"*");
    private static final Set<String> STATS_COLUMNS = ImmutableSet.of((Object)"value_counts", (Object)"null_value_counts", (Object)"nan_value_counts", (Object)"lower_bounds", (Object)"upper_bounds", (Object)"record_count", (Object[])new String[0]);
    private final InputFile file;
    private final InheritableMetadata inheritableMetadata;
    private final Long firstRowId;
    private final FileType content;
    private final PartitionSpec spec;
    private final Schema fileSchema;
    private PartitionSet partitionSet = null;
    private Expression partFilter = Expressions.alwaysTrue();
    private Expression rowFilter = Expressions.alwaysTrue();
    private Schema fileProjection = null;
    private Collection<String> columns = null;
    private boolean caseSensitive = true;
    private ScanMetrics scanMetrics = ScanMetrics.noop();
    private Evaluator lazyEvaluator = null;
    private InclusiveMetricsEvaluator lazyMetricsEvaluator = null;

    protected ManifestReader(InputFile file, int specId, Map<Integer, PartitionSpec> specsById, InheritableMetadata inheritableMetadata, FileType content) {
        this(file, specId, specsById, inheritableMetadata, null, content);
    }

    protected ManifestReader(InputFile file, int specId, Map<Integer, PartitionSpec> specsById, InheritableMetadata inheritableMetadata, Long firstRowId, FileType content) {
        Preconditions.checkArgument((firstRowId == null || content == FileType.DATA_FILES ? 1 : 0) != 0, (Object)"First row ID is not valid for delete manifests");
        this.file = file;
        this.inheritableMetadata = inheritableMetadata;
        this.firstRowId = firstRowId;
        this.content = content;
        this.spec = specsById != null ? specsById.get(specId) : this.readPartitionSpec(file);
        this.fileSchema = new Schema(DataFile.getType((Types.StructType)this.spec.rawPartitionType()).fields());
    }

    private <T extends ContentFile<T>> PartitionSpec readPartitionSpec(InputFile inputFile) {
        Map<String, String> metadata = ManifestReader.readMetadata(inputFile);
        int specId = 0;
        String specProperty = metadata.get("partition-spec-id");
        if (specProperty != null) {
            specId = Integer.parseInt(specProperty);
        }
        Schema schema = SchemaParser.fromJson(metadata.get("schema"));
        return PartitionSpecParser.fromJsonFields(schema, specId, metadata.get("partition-spec"));
    }

    private static <T extends ContentFile<T>> Map<String, String> readMetadata(InputFile inputFile) {
        Map<String, String> metadata;
        block9: {
            try (CloseableIterable headerReader = InternalData.read(FileFormat.AVRO, inputFile).project(ManifestEntry.getSchema(Types.StructType.of((Types.NestedField[])new Types.NestedField[0])).select(new String[]{"status"})).build();){
                if (headerReader instanceof AvroIterable) {
                    metadata = ((AvroIterable)headerReader).getMetadata();
                    break block9;
                }
                throw new RuntimeException("Reader does not support metadata reading: " + headerReader.getClass().getName());
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }
        return metadata;
    }

    public boolean isDeleteManifestReader() {
        return this.content == FileType.DELETE_FILES;
    }

    public InputFile file() {
        return this.file;
    }

    public Schema schema() {
        return this.fileSchema;
    }

    public PartitionSpec spec() {
        return this.spec;
    }

    public ManifestReader<F> select(Collection<String> newColumns) {
        Preconditions.checkState((this.fileProjection == null ? 1 : 0) != 0, (Object)"Cannot select columns using both select(String...) and project(Schema)");
        this.columns = newColumns;
        return this;
    }

    public ManifestReader<F> project(Schema newFileProjection) {
        Preconditions.checkState((this.columns == null ? 1 : 0) != 0, (Object)"Cannot select columns using both select(String...) and project(Schema)");
        this.fileProjection = newFileProjection;
        return this;
    }

    public ManifestReader<F> filterPartitions(Expression expr) {
        this.partFilter = Expressions.and((Expression)this.partFilter, (Expression)expr);
        return this;
    }

    public ManifestReader<F> filterPartitions(PartitionSet partitions) {
        this.partitionSet = partitions;
        return this;
    }

    public ManifestReader<F> filterRows(Expression expr) {
        this.rowFilter = Expressions.and((Expression)this.rowFilter, (Expression)expr);
        return this;
    }

    public ManifestReader<F> caseSensitive(boolean isCaseSensitive) {
        this.caseSensitive = isCaseSensitive;
        return this;
    }

    ManifestReader<F> scanMetrics(ScanMetrics newScanMetrics) {
        this.scanMetrics = newScanMetrics;
        return this;
    }

    CloseableIterable<ManifestEntry<F>> entries() {
        return this.entries(false);
    }

    private CloseableIterable<ManifestEntry<F>> entries(boolean onlyLive) {
        if (this.hasRowFilter() || this.hasPartitionFilter() || this.partitionSet != null) {
            Evaluator evaluator = this.evaluator();
            InclusiveMetricsEvaluator metricsEvaluator = this.metricsEvaluator();
            boolean requireStatsProjection = ManifestReader.requireStatsProjection(this.rowFilter, this.columns);
            Collection<String> projectColumns = requireStatsProjection ? ManifestReader.withStatsColumns(this.columns) : this.columns;
            CloseableIterable<ManifestEntry<F>> entries = this.open(ManifestReader.projection(this.fileSchema, this.fileProjection, projectColumns, this.caseSensitive));
            return CloseableIterable.filter((Counter)(this.content == FileType.DATA_FILES ? this.scanMetrics.skippedDataFiles() : this.scanMetrics.skippedDeleteFiles()), onlyLive ? this.filterLiveEntries(entries) : entries, entry -> entry != null && evaluator.eval(entry.file().partition()) && metricsEvaluator.eval(entry.file()) && this.inPartitionSet(entry.file()));
        }
        CloseableIterable<ManifestEntry<F>> entries = this.open(ManifestReader.projection(this.fileSchema, this.fileProjection, this.columns, this.caseSensitive));
        return onlyLive ? this.filterLiveEntries(entries) : entries;
    }

    private boolean hasRowFilter() {
        return this.rowFilter != null && this.rowFilter != Expressions.alwaysTrue();
    }

    private boolean hasPartitionFilter() {
        return this.partFilter != null && this.partFilter != Expressions.alwaysTrue();
    }

    private boolean inPartitionSet(F fileToCheck) {
        return this.partitionSet == null || this.partitionSet.contains(fileToCheck.specId(), fileToCheck.partition());
    }

    private CloseableIterable<ManifestEntry<F>> open(Schema projection) {
        FileFormat format = FileFormat.fromFileName((CharSequence)this.file.location());
        Preconditions.checkArgument((format != null ? 1 : 0) != 0, (String)"Unable to determine format of manifest: %s", (Object)this.file.location());
        ArrayList fields = Lists.newArrayList();
        fields.addAll(projection.asStruct().fields());
        if (projection.findField(DataFile.RECORD_COUNT.fieldId()) == null) {
            fields.add(DataFile.RECORD_COUNT);
        }
        if (projection.findField(DataFile.FIRST_ROW_ID.fieldId()) == null) {
            fields.add(DataFile.FIRST_ROW_ID);
        }
        fields.add(MetadataColumns.ROW_POSITION);
        CloseableIterable reader = InternalData.read(format, this.file).project(ManifestEntry.wrapFileSchema(Types.StructType.of((List)fields))).setRootType(GenericManifestEntry.class).setCustomType(2, this.content.fileClass()).setCustomType(102, PartitionData.class).reuseContainers().build();
        this.addCloseable((Closeable)reader);
        CloseableIterable withMetadata = CloseableIterable.transform(reader, this.inheritableMetadata::apply);
        return CloseableIterable.transform((CloseableIterable)withMetadata, ManifestReader.idAssigner(this.firstRowId));
    }

    CloseableIterable<ManifestEntry<F>> liveEntries() {
        return this.entries(true);
    }

    private CloseableIterable<ManifestEntry<F>> filterLiveEntries(CloseableIterable<ManifestEntry<F>> entries) {
        return CloseableIterable.filter(entries, this::isLiveEntry);
    }

    private boolean isLiveEntry(ManifestEntry<F> entry) {
        return entry != null && entry.status() != ManifestEntry.Status.DELETED;
    }

    public CloseableIterator<F> iterator() {
        boolean dropStats = ManifestReader.dropStats(this.columns);
        return CloseableIterable.transform(this.liveEntries(), e -> (ContentFile)e.file().copy(!dropStats)).iterator();
    }

    private static Schema projection(Schema schema, Schema project, Collection<String> columns, boolean caseSensitive) {
        if (columns != null) {
            if (caseSensitive) {
                return schema.select(columns);
            }
            return schema.caseInsensitiveSelect(columns);
        }
        if (project != null) {
            return project;
        }
        return schema;
    }

    private Evaluator evaluator() {
        if (this.lazyEvaluator == null) {
            Expression projected = Projections.inclusive((PartitionSpec)this.spec, (boolean)this.caseSensitive).project(this.rowFilter);
            Expression finalPartFilter = Expressions.and((Expression)projected, (Expression)this.partFilter);
            this.lazyEvaluator = finalPartFilter != null ? new Evaluator(this.spec.partitionType(), finalPartFilter, this.caseSensitive) : new Evaluator(this.spec.partitionType(), (Expression)Expressions.alwaysTrue(), this.caseSensitive);
        }
        return this.lazyEvaluator;
    }

    private InclusiveMetricsEvaluator metricsEvaluator() {
        if (this.lazyMetricsEvaluator == null) {
            this.lazyMetricsEvaluator = this.rowFilter != null ? new InclusiveMetricsEvaluator(this.spec.schema(), this.rowFilter, this.caseSensitive) : new InclusiveMetricsEvaluator(this.spec.schema(), (Expression)Expressions.alwaysTrue(), this.caseSensitive);
        }
        return this.lazyMetricsEvaluator;
    }

    private static boolean requireStatsProjection(Expression rowFilter, Collection<String> columns) {
        return rowFilter != Expressions.alwaysTrue() && columns != null && !columns.containsAll((Collection<?>)ALL_COLUMNS) && !columns.containsAll(STATS_COLUMNS);
    }

    static boolean dropStats(Collection<String> columns) {
        if (columns != null && !columns.containsAll((Collection<?>)ALL_COLUMNS)) {
            Sets.SetView intersection = Sets.intersection((Set)Sets.newHashSet(columns), STATS_COLUMNS);
            return intersection.isEmpty() || intersection.equals(Sets.newHashSet((Object[])new String[]{"record_count"}));
        }
        return false;
    }

    static List<String> withStatsColumns(Collection<String> columns) {
        if (columns.containsAll((Collection<?>)ALL_COLUMNS)) {
            return Lists.newArrayList(columns);
        }
        ArrayList projectColumns = Lists.newArrayList(columns);
        projectColumns.addAll(STATS_COLUMNS);
        return projectColumns;
    }

    private static <F extends ContentFile<F>> Function<ManifestEntry<F>, ManifestEntry<F>> idAssigner(final Long firstRowId) {
        if (firstRowId != null) {
            return new Function<ManifestEntry<F>, ManifestEntry<F>>(){
                private long nextRowId;
                {
                    this.nextRowId = firstRowId;
                }

                @Override
                public ManifestEntry<F> apply(ManifestEntry<F> entry) {
                    BaseFile file;
                    if (entry.file() instanceof BaseFile && entry.status() != ManifestEntry.Status.DELETED && null == (file = (BaseFile)entry.file()).firstRowId()) {
                        file.setFirstRowId(this.nextRowId);
                        this.nextRowId += file.recordCount();
                    }
                    return entry;
                }
            };
        }
        return entry -> {
            if (entry.file() instanceof BaseFile) {
                ((BaseFile)entry.file()).setFirstRowId(null);
            }
            return entry;
        };
    }

    protected static enum FileType {
        DATA_FILES(GenericDataFile.class),
        DELETE_FILES(GenericDeleteFile.class);

        private final Class<? extends StructLike> fileClass;

        private FileType(Class<? extends StructLike> fileClass) {
            this.fileClass = fileClass;
        }

        private Class<? extends StructLike> fileClass() {
            return this.fileClass;
        }
    }
}

