/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.mutiny.impl;

import io.smallrye.faulttolerance.core.Completer;
import io.smallrye.faulttolerance.core.Future;
import io.smallrye.faulttolerance.core.invocation.AsyncSupport;
import io.smallrye.faulttolerance.core.invocation.Invoker;
import io.smallrye.mutiny.Uni;

public class UniSupport<T>
implements AsyncSupport<T, Uni<T>> {
    public String mustDescription() {
        return "return " + Uni.class.getSimpleName();
    }

    public String doesDescription() {
        return "returns " + Uni.class.getSimpleName();
    }

    public boolean applies(Class<?>[] parameterTypes, Class<?> returnType) {
        return Uni.class.equals(returnType);
    }

    public Uni<T> createComplete(T value) {
        return Uni.createFrom().item(value);
    }

    public Future<T> toFuture(Invoker<Uni<T>> invoker) {
        Completer completer = Completer.create();
        try {
            ((Uni)invoker.proceed()).subscribe().with(arg_0 -> ((Completer)completer).complete(arg_0), arg_0 -> ((Completer)completer).completeWithError(arg_0));
        }
        catch (Exception e) {
            completer.completeWithError((Throwable)e);
        }
        return completer.future();
    }

    public Uni<T> fromFuture(Invoker<Future<T>> invoker) {
        return Uni.createFrom().emitter(em -> {
            try {
                ((Future)invoker.proceed()).then((value, error) -> {
                    if (error == null) {
                        em.complete(value);
                    } else {
                        em.fail(error);
                    }
                });
            }
            catch (Exception e) {
                em.fail((Throwable)e);
            }
        });
    }
}

