/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.storage;

import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.ServiceOptions;
import jakarta.annotation.Nullable;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.time.Clock;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.polaris.core.storage.PolarisStorageConfigurationInfo;
import org.apache.polaris.core.storage.PolarisStorageIntegration;
import org.apache.polaris.core.storage.PolarisStorageIntegrationProvider;
import org.apache.polaris.core.storage.aws.AwsCredentialsStorageIntegration;
import org.apache.polaris.core.storage.aws.AwsStorageConfigurationInfo;
import org.apache.polaris.core.storage.aws.StsClientProvider;
import org.apache.polaris.core.storage.azure.AzureCredentialsStorageIntegration;
import org.apache.polaris.core.storage.azure.AzureStorageConfigurationInfo;
import org.apache.polaris.core.storage.gcp.GcpCredentialsStorageIntegration;
import org.apache.polaris.core.storage.gcp.GcpStorageConfigurationInfo;
import org.apache.polaris.service.storage.PolarisStorageIntegrationProviderImpl;
import org.apache.polaris.service.storage.StorageConfiguration;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;

@ApplicationScoped
public class PolarisStorageIntegrationProviderImpl
implements PolarisStorageIntegrationProvider {
    private final StsClientProvider stsClientProvider;
    private final Optional<AwsCredentialsProvider> stsCredentials;
    private final Supplier<GoogleCredentials> gcpCredsProvider;

    @Inject
    public PolarisStorageIntegrationProviderImpl(StorageConfiguration storageConfiguration, StsClientProvider stsClientProvider, Clock clock) {
        this(stsClientProvider, Optional.ofNullable(storageConfiguration.stsCredentials()), storageConfiguration.gcpCredentialsSupplier(clock));
    }

    public PolarisStorageIntegrationProviderImpl(StsClientProvider stsClientProvider, Optional<AwsCredentialsProvider> stsCredentials, Supplier<GoogleCredentials> gcpCredsProvider) {
        this.stsClientProvider = stsClientProvider;
        this.stsCredentials = stsCredentials;
        this.gcpCredsProvider = gcpCredsProvider;
    }

    @Nullable
    public <T extends PolarisStorageConfigurationInfo> PolarisStorageIntegration<T> getStorageIntegrationForConfig(PolarisStorageConfigurationInfo polarisStorageConfigurationInfo) {
        if (polarisStorageConfigurationInfo == null) {
            return null;
        }
        return switch (2.$SwitchMap$org$apache$polaris$core$storage$PolarisStorageConfigurationInfo$StorageType[polarisStorageConfigurationInfo.getStorageType().ordinal()]) {
            case 1 -> new AwsCredentialsStorageIntegration((AwsStorageConfigurationInfo)polarisStorageConfigurationInfo, this.stsClientProvider, this.stsCredentials);
            case 2 -> new GcpCredentialsStorageIntegration((GcpStorageConfigurationInfo)polarisStorageConfigurationInfo, this.gcpCredsProvider.get(), (HttpTransportFactory)ServiceOptions.getFromServiceLoader(HttpTransportFactory.class, NetHttpTransport::new));
            case 3 -> new AzureCredentialsStorageIntegration((AzureStorageConfigurationInfo)polarisStorageConfigurationInfo);
            case 4 -> new /* Unavailable Anonymous Inner Class!! */;
            default -> throw new IllegalArgumentException("Unknown storage type " + String.valueOf(polarisStorageConfigurationInfo.getStorageType()));
        };
    }

    public PolarisStorageIntegrationProviderImpl() {
    }
}

