/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.catalog.policy;

import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.rest.RESTUtil;
import org.apache.polaris.core.auth.PolarisAuthorizer;
import org.apache.polaris.core.catalog.ExternalCatalogFactory;
import org.apache.polaris.core.config.FeatureConfiguration;
import org.apache.polaris.core.config.RealmConfig;
import org.apache.polaris.core.context.CallContext;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.core.persistence.PolarisMetaStoreManager;
import org.apache.polaris.core.persistence.resolver.ResolutionManifestFactory;
import org.apache.polaris.core.policy.PolicyType;
import org.apache.polaris.core.secrets.UserSecretsManager;
import org.apache.polaris.service.catalog.CatalogPrefixParser;
import org.apache.polaris.service.catalog.api.PolarisCatalogPolicyApiService;
import org.apache.polaris.service.catalog.common.CatalogAdapter;
import org.apache.polaris.service.catalog.policy.PolicyCatalogHandler;
import org.apache.polaris.service.types.AttachPolicyRequest;
import org.apache.polaris.service.types.CreatePolicyRequest;
import org.apache.polaris.service.types.DetachPolicyRequest;
import org.apache.polaris.service.types.GetApplicablePoliciesResponse;
import org.apache.polaris.service.types.ListPoliciesResponse;
import org.apache.polaris.service.types.LoadPolicyResponse;
import org.apache.polaris.service.types.PolicyIdentifier;
import org.apache.polaris.service.types.UpdatePolicyRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
public class PolicyCatalogAdapter
implements PolarisCatalogPolicyApiService,
CatalogAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolicyCatalogAdapter.class);
    private final RealmContext realmContext;
    private final RealmConfig realmConfig;
    private final CallContext callContext;
    private final ResolutionManifestFactory resolutionManifestFactory;
    private final PolarisMetaStoreManager metaStoreManager;
    private final PolarisAuthorizer polarisAuthorizer;
    private final CatalogPrefixParser prefixParser;
    private final UserSecretsManager userSecretsManager;
    private final Instance<ExternalCatalogFactory> externalCatalogFactories;

    @Inject
    public PolicyCatalogAdapter(RealmContext realmContext, CallContext callContext, ResolutionManifestFactory resolutionManifestFactory, PolarisMetaStoreManager metaStoreManager, PolarisAuthorizer polarisAuthorizer, CatalogPrefixParser prefixParser, UserSecretsManager userSecretsManager, @Any Instance<ExternalCatalogFactory> externalCatalogFactories) {
        this.realmContext = realmContext;
        this.callContext = callContext;
        this.realmConfig = callContext.getRealmConfig();
        this.resolutionManifestFactory = resolutionManifestFactory;
        this.metaStoreManager = metaStoreManager;
        this.polarisAuthorizer = polarisAuthorizer;
        this.prefixParser = prefixParser;
        this.userSecretsManager = userSecretsManager;
        this.externalCatalogFactories = externalCatalogFactories;
    }

    private PolicyCatalogHandler newHandlerWrapper(SecurityContext securityContext, String prefix) {
        FeatureConfiguration.enforceFeatureEnabledOrThrow((RealmConfig)this.realmConfig, (FeatureConfiguration)FeatureConfiguration.ENABLE_POLICY_STORE);
        this.validatePrincipal(securityContext);
        return new PolicyCatalogHandler(this.callContext, this.resolutionManifestFactory, this.metaStoreManager, securityContext, this.prefixParser.prefixToCatalogName(this.realmContext, prefix), this.polarisAuthorizer, this.userSecretsManager, this.externalCatalogFactories);
    }

    public Response createPolicy(String prefix, String namespace, CreatePolicyRequest createPolicyRequest, RealmContext realmContext, SecurityContext securityContext) {
        Namespace ns = this.decodeNamespace(namespace);
        PolicyCatalogHandler handler = this.newHandlerWrapper(securityContext, prefix);
        LoadPolicyResponse response = handler.createPolicy(ns, createPolicyRequest);
        return Response.ok((Object)response).build();
    }

    public Response listPolicies(String prefix, String namespace, String pageToken, Integer pageSize, String policyType, RealmContext realmContext, SecurityContext securityContext) {
        Namespace ns = this.decodeNamespace(namespace);
        PolicyType type = policyType != null ? PolicyType.fromName((String)RESTUtil.decodeString((String)policyType)) : null;
        PolicyCatalogHandler handler = this.newHandlerWrapper(securityContext, prefix);
        ListPoliciesResponse response = handler.listPolicies(ns, type);
        return Response.ok((Object)response).build();
    }

    public Response loadPolicy(String prefix, String namespace, String policyName, RealmContext realmContext, SecurityContext securityContext) {
        Namespace ns = this.decodeNamespace(namespace);
        PolicyIdentifier identifier = new PolicyIdentifier(ns, RESTUtil.decodeString((String)policyName));
        PolicyCatalogHandler handler = this.newHandlerWrapper(securityContext, prefix);
        LoadPolicyResponse response = handler.loadPolicy(identifier);
        return Response.ok((Object)response).build();
    }

    public Response updatePolicy(String prefix, String namespace, String policyName, UpdatePolicyRequest updatePolicyRequest, RealmContext realmContext, SecurityContext securityContext) {
        Namespace ns = this.decodeNamespace(namespace);
        PolicyIdentifier identifier = new PolicyIdentifier(ns, RESTUtil.decodeString((String)policyName));
        PolicyCatalogHandler handler = this.newHandlerWrapper(securityContext, prefix);
        LoadPolicyResponse response = handler.updatePolicy(identifier, updatePolicyRequest);
        return Response.ok((Object)response).build();
    }

    public Response dropPolicy(String prefix, String namespace, String policyName, Boolean detachAll, RealmContext realmContext, SecurityContext securityContext) {
        Namespace ns = this.decodeNamespace(namespace);
        PolicyIdentifier identifier = new PolicyIdentifier(ns, RESTUtil.decodeString((String)policyName));
        PolicyCatalogHandler handler = this.newHandlerWrapper(securityContext, prefix);
        handler.dropPolicy(identifier, detachAll != null && detachAll != false);
        return Response.noContent().build();
    }

    public Response attachPolicy(String prefix, String namespace, String policyName, AttachPolicyRequest attachPolicyRequest, RealmContext realmContext, SecurityContext securityContext) {
        Namespace ns = this.decodeNamespace(namespace);
        PolicyIdentifier identifier = new PolicyIdentifier(ns, RESTUtil.decodeString((String)policyName));
        PolicyCatalogHandler handler = this.newHandlerWrapper(securityContext, prefix);
        handler.attachPolicy(identifier, attachPolicyRequest);
        return Response.noContent().build();
    }

    public Response detachPolicy(String prefix, String namespace, String policyName, DetachPolicyRequest detachPolicyRequest, RealmContext realmContext, SecurityContext securityContext) {
        Namespace ns = this.decodeNamespace(namespace);
        PolicyIdentifier identifier = new PolicyIdentifier(ns, RESTUtil.decodeString((String)policyName));
        PolicyCatalogHandler handler = this.newHandlerWrapper(securityContext, prefix);
        handler.detachPolicy(identifier, detachPolicyRequest);
        return Response.noContent().build();
    }

    public Response getApplicablePolicies(String prefix, String pageToken, Integer pageSize, String namespace, String targetName, String policyType, RealmContext realmContext, SecurityContext securityContext) {
        Namespace ns = namespace != null ? this.decodeNamespace(namespace) : null;
        String target = targetName != null ? RESTUtil.decodeString((String)targetName) : null;
        PolicyType type = policyType != null ? PolicyType.fromName((String)RESTUtil.decodeString((String)policyType)) : null;
        PolicyCatalogHandler handler = this.newHandlerWrapper(securityContext, prefix);
        GetApplicablePoliciesResponse response = handler.getApplicablePolicies(ns, target, type);
        return Response.ok((Object)response).build();
    }

    public PolicyCatalogAdapter() {
    }
}

