/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.connection.hive;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import org.apache.polaris.core.admin.model.ConnectionConfigInfo;
import org.apache.polaris.core.admin.model.HiveConnectionConfigInfo;
import org.apache.polaris.core.connection.AuthenticationParametersDpo;
import org.apache.polaris.core.connection.ConnectionConfigInfoDpo;
import org.apache.polaris.core.connection.ConnectionType;
import org.apache.polaris.core.identity.dpo.ServiceIdentityInfoDpo;
import org.apache.polaris.core.secrets.UserSecretsManager;

public class HiveConnectionConfigInfoDpo
extends ConnectionConfigInfoDpo {
    private final String warehouse;

    public HiveConnectionConfigInfoDpo(@JsonProperty(value="uri", required=true) @Nonnull String uri, @JsonProperty(value="authenticationParameters", required=false) @Nullable AuthenticationParametersDpo authenticationParameters, @JsonProperty(value="warehouse", required=false) @Nullable String warehouse, @JsonProperty(value="serviceIdentity", required=false) @Nullable ServiceIdentityInfoDpo serviceIdentity) {
        super(ConnectionType.HIVE.getCode(), uri, authenticationParameters, serviceIdentity);
        this.warehouse = warehouse;
    }

    public String getWarehouse() {
        return this.warehouse;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("connectionTypeCode", this.getConnectionTypeCode()).add("uri", (Object)this.getUri()).add("warehouse", (Object)this.getWarehouse()).add("authenticationParameters", (Object)this.getAuthenticationParameters().toString()).toString();
    }

    @Override
    @Nonnull
    public Map<String, String> asIcebergCatalogProperties(UserSecretsManager secretsManager) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("uri", this.getUri());
        if (this.getWarehouse() != null) {
            properties.put("warehouse", this.getWarehouse());
        }
        if (this.getAuthenticationParameters() != null) {
            properties.putAll(this.getAuthenticationParameters().asIcebergCatalogProperties(secretsManager));
        }
        return properties;
    }

    @Override
    public ConnectionConfigInfoDpo withServiceIdentity(@Nonnull ServiceIdentityInfoDpo serviceIdentityInfo) {
        return new HiveConnectionConfigInfoDpo(this.getUri(), this.getAuthenticationParameters(), this.warehouse, serviceIdentityInfo);
    }

    @Override
    public ConnectionConfigInfo asConnectionConfigInfoModel() {
        return HiveConnectionConfigInfo.builder().setConnectionType(ConnectionConfigInfo.ConnectionTypeEnum.HIVE).setUri(this.getUri()).setWarehouse(this.getWarehouse()).setAuthenticationParameters(this.getAuthenticationParameters().asAuthenticationParametersModel()).build();
    }
}

