/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.indirection;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;

public class ProxyIndirectionHandler<T>
implements InvocationHandler,
Serializable {
    private ValueHolderInterface<T> valueHolder;

    public ProxyIndirectionHandler() {
    }

    private ProxyIndirectionHandler(ValueHolderInterface<T> valueHolder) {
        this.valueHolder = valueHolder;
    }

    @Override
    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        Object result = null;
        try {
            if (m.getName().equals("toString")) {
                if (this.valueHolder.isInstantiated()) {
                    if (this.valueHolder.getValue() == null) {
                        result = "null";
                    } else {
                        String toString = PrivilegedAccessHelper.callDoPrivilegedWithException(() -> (String)PrivilegedAccessHelper.invokeMethod(m, this.valueHolder.getValue(), args));
                        result = "{ " + toString + " }";
                    }
                } else {
                    result = "{ IndirectProxy: not instantiated }";
                }
            } else if (m.getName().equals("equals") && this.valueHolder.getValue() == null && args[0] == null) {
                result = Boolean.TRUE;
            } else {
                Object value = this.valueHolder.getValue();
                if (value == null) {
                    throw ValidationException.nullUnderlyingValueHolderValue(m.getName());
                }
                result = PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.invokeMethod(m, value, args));
            }
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (Exception e) {
            throw QueryException.unexpectedInvocation(e.getMessage());
        }
        return result;
    }

    public static <T> Object newProxyInstance(Class<?> anInterface, Class<?>[] interfaces, ValueHolderInterface<T> valueHolder) {
        ClassLoader classLoader = PrivilegedAccessHelper.callDoPrivileged(() -> PrivilegedAccessHelper.getClassLoaderForClass(anInterface));
        return Proxy.newProxyInstance(classLoader, interfaces, new ProxyIndirectionHandler<T>(valueHolder));
    }

    public ValueHolderInterface<T> getValueHolder() {
        return this.valueHolder;
    }

    public void setValueHolder(ValueHolderInterface<T> value) {
        this.valueHolder = value;
    }
}

