/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.sas;

import java.util.Locale;

public final class AccountSasResourceType {
    private boolean service;
    private boolean container;
    private boolean object;

    public static AccountSasResourceType parse(String resourceTypesString) {
        AccountSasResourceType resourceType = new AccountSasResourceType();
        block5: for (int i = 0; i < resourceTypesString.length(); ++i) {
            char c = resourceTypesString.charAt(i);
            switch (c) {
                case 's': {
                    resourceType.service = true;
                    continue block5;
                }
                case 'c': {
                    resourceType.container = true;
                    continue block5;
                }
                case 'o': {
                    resourceType.object = true;
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "%s could not be parsed from '%s' due to invalid value %s.", "Resource Types", resourceTypesString, Character.valueOf(c)));
                }
            }
        }
        return resourceType;
    }

    public boolean isService() {
        return this.service;
    }

    public AccountSasResourceType setService(boolean service) {
        this.service = service;
        return this;
    }

    public boolean isContainer() {
        return this.container;
    }

    public AccountSasResourceType setContainer(boolean container) {
        this.container = container;
        return this;
    }

    public boolean isObject() {
        return this.object;
    }

    public AccountSasResourceType setObject(boolean object) {
        this.object = object;
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.service) {
            builder.append('s');
        }
        if (this.container) {
            builder.append('c');
        }
        if (this.object) {
            builder.append('o');
        }
        return builder.toString();
    }
}

