/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.iceberg.metrics.Counter;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.util.ExceptionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tasks {
    private static final Logger LOG = LoggerFactory.getLogger(Tasks.class);

    private Tasks() {
    }

    private static Collection<Throwable> waitFor(Collection<Future<?>> futures) {
        while (true) {
            int numFinished = 0;
            for (Future<?> future : futures) {
                if (!future.isDone()) continue;
                ++numFinished;
            }
            if (numFinished == futures.size()) {
                ArrayList uncaught = Lists.newArrayList();
                for (Future<?> future : futures) {
                    try {
                        future.get();
                    }
                    catch (InterruptedException e) {
                        LOG.warn("Interrupted while getting future results", (Throwable)e);
                        for (Throwable t : uncaught) {
                            e.addSuppressed(t);
                        }
                        Thread.currentThread().interrupt();
                        throw new RuntimeException(e);
                    }
                    catch (CancellationException e) {
                    }
                    catch (ExecutionException e) {
                        Throwable cause = e.getCause();
                        if (cause instanceof Error) {
                            for (Throwable t : uncaught) {
                                cause.addSuppressed(t);
                            }
                            throw (Error)cause;
                        }
                        if (cause != null) {
                            uncaught.add(e);
                        }
                        LOG.warn("Task threw uncaught exception", cause);
                    }
                }
                return uncaught;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                LOG.warn("Interrupted while waiting for tasks to finish", (Throwable)e);
                for (Future<?> future : futures) {
                    future.cancel(true);
                }
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
    }

    public static Builder<Integer> range(int upTo) {
        return new Builder<Integer>(new Range(upTo));
    }

    public static <I> Builder<I> foreach(Iterator<I> items) {
        return new Builder(() -> items);
    }

    public static <I> Builder<I> foreach(Iterable<I> items) {
        return new Builder<I>(items);
    }

    @SafeVarargs
    public static <I> Builder<I> foreach(I ... items) {
        return new Builder<I>(Arrays.asList(items));
    }

    public static <I> Builder<I> foreach(Stream<I> items) {
        return new Builder(items::iterator);
    }

    private static <E extends Exception> void throwOne(Collection<Throwable> exceptions, Class<E> allowedException) throws E {
        Iterator<Throwable> iter = exceptions.iterator();
        Throwable exception = iter.next();
        Class<?> exceptionClass = exception.getClass();
        while (iter.hasNext()) {
            Throwable other = iter.next();
            if (exceptionClass.isInstance(other)) continue;
            exception.addSuppressed(other);
        }
        ExceptionUtil.castAndThrow((Throwable)exception, allowedException);
    }

    private static class Range
    implements Iterable<Integer> {
        private int size;

        Range(int size) {
            this.size = size;
        }

        @Override
        public Iterator<Integer> iterator() {
            return new Iterator<Integer>(){
                private int current = 0;

                @Override
                public boolean hasNext() {
                    return this.current < size;
                }

                @Override
                public Integer next() {
                    int ret = this.current++;
                    return ret;
                }
            };
        }
    }

    public static class Builder<I> {
        private final Iterable<I> items;
        private ExecutorService service = null;
        private FailureTask<I, ?> onFailure = null;
        private boolean stopOnFailure = false;
        private boolean throwFailureWhenFinished = true;
        private Task<I, ?> revertTask = null;
        private boolean stopRevertsOnFailure = false;
        private Task<I, ?> abortTask = null;
        private boolean stopAbortsOnFailure = false;
        private final List<Class<? extends Exception>> stopRetryExceptions = Lists.newArrayList((Object[])new Class[]{UnrecoverableException.class});
        private List<Class<? extends Exception>> onlyRetryExceptions = null;
        private Predicate<Exception> shouldRetryPredicate = null;
        private int maxAttempts = 1;
        private long minSleepTimeMs = 1000L;
        private long maxSleepTimeMs = 600000L;
        private long maxDurationMs = 600000L;
        private double scaleFactor = 2.0;
        private Counter attemptsCounter;

        public Builder(Iterable<I> items) {
            this.items = items;
        }

        public Builder<I> executeWith(ExecutorService svc) {
            this.service = svc;
            return this;
        }

        public Builder<I> onFailure(FailureTask<I, ?> task) {
            this.onFailure = task;
            return this;
        }

        public Builder<I> stopOnFailure() {
            this.stopOnFailure = true;
            return this;
        }

        public Builder<I> throwFailureWhenFinished() {
            this.throwFailureWhenFinished = true;
            return this;
        }

        public Builder<I> throwFailureWhenFinished(boolean throwWhenFinished) {
            this.throwFailureWhenFinished = throwWhenFinished;
            return this;
        }

        public Builder<I> suppressFailureWhenFinished() {
            this.throwFailureWhenFinished = false;
            return this;
        }

        public Builder<I> revertWith(Task<I, ?> task) {
            this.revertTask = task;
            return this;
        }

        public Builder<I> stopRevertsOnFailure() {
            this.stopRevertsOnFailure = true;
            return this;
        }

        public Builder<I> abortWith(Task<I, ?> task) {
            this.abortTask = task;
            return this;
        }

        public Builder<I> stopAbortsOnFailure() {
            this.stopAbortsOnFailure = true;
            return this;
        }

        @SafeVarargs
        public final Builder<I> stopRetryOn(Class<? extends Exception> ... exceptions) {
            this.stopRetryExceptions.addAll(Arrays.asList(exceptions));
            return this;
        }

        public Builder<I> shouldRetryTest(Predicate<Exception> shouldRetry) {
            this.shouldRetryPredicate = shouldRetry;
            return this;
        }

        public Builder<I> noRetry() {
            this.maxAttempts = 1;
            return this;
        }

        public Builder<I> retry(int nTimes) {
            this.maxAttempts = nTimes + 1;
            return this;
        }

        public Builder<I> onlyRetryOn(Class<? extends Exception> exception) {
            this.onlyRetryExceptions = Collections.singletonList(exception);
            return this;
        }

        @SafeVarargs
        public final Builder<I> onlyRetryOn(Class<? extends Exception> ... exceptions) {
            this.onlyRetryExceptions = Lists.newArrayList((Object[])exceptions);
            return this;
        }

        public Builder<I> countAttempts(Counter counter) {
            this.attemptsCounter = counter;
            return this;
        }

        public Builder<I> exponentialBackoff(long backoffMinSleepTimeMs, long backoffMaxSleepTimeMs, long backoffMaxRetryTimeMs, double backoffScaleFactor) {
            this.minSleepTimeMs = backoffMinSleepTimeMs;
            this.maxSleepTimeMs = backoffMaxSleepTimeMs;
            this.maxDurationMs = backoffMaxRetryTimeMs;
            this.scaleFactor = backoffScaleFactor;
            return this;
        }

        public boolean run(Task<I, RuntimeException> task) {
            return this.run(task, RuntimeException.class);
        }

        public <E extends Exception> boolean run(Task<I, E> task, Class<E> exceptionClass) throws E {
            if (this.service != null) {
                return this.runParallel(task, exceptionClass);
            }
            return this.runSingleThreaded(task, exceptionClass);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private <E extends Exception> boolean runSingleThreaded(Task<I, E> task, Class<E> exceptionClass) throws E {
            boolean threw;
            ArrayList exceptions;
            block24: {
                Iterator<I> iterator;
                block25: {
                    Iterator e2;
                    boolean failed;
                    ArrayList succeeded = Lists.newArrayList();
                    exceptions = Lists.newArrayList();
                    iterator = this.items.iterator();
                    threw = true;
                    try {
                        while (iterator.hasNext()) {
                            I item = iterator.next();
                            try {
                                this.runTaskWithRetry(task, item);
                                succeeded.add(item);
                            }
                            catch (Exception e2) {
                                exceptions.add(e2);
                                if (this.onFailure != null) {
                                    this.tryRunOnFailure(item, e2);
                                }
                                if (!this.stopOnFailure) continue;
                            }
                        }
                        if (!(threw = false) && exceptions.isEmpty()) break block24;
                        if (this.revertTask == null) break block25;
                        failed = false;
                        e2 = succeeded.iterator();
                    }
                    catch (Throwable throwable) {
                        boolean failed2;
                        if (!threw) {
                            if (exceptions.isEmpty()) throw throwable;
                        }
                        if (this.revertTask != null) {
                            failed2 = false;
                            for (Object item : succeeded) {
                                try {
                                    this.revertTask.run(item);
                                }
                                catch (Exception e3) {
                                    failed2 = true;
                                    LOG.error("Failed to revert task", (Throwable)e3);
                                }
                                if (!this.stopRevertsOnFailure || !failed2) continue;
                            }
                        }
                        if (this.abortTask == null) throw throwable;
                        failed2 = false;
                        do {
                            if (!iterator.hasNext()) throw throwable;
                            try {
                                this.abortTask.run(iterator.next());
                            }
                            catch (Exception e4) {
                                failed2 = true;
                                LOG.error("Failed to abort task", (Throwable)e4);
                            }
                        } while (!this.stopAbortsOnFailure || !failed2);
                        throw throwable;
                    }
                    while (e2.hasNext()) {
                        Object item = e2.next();
                        try {
                            this.revertTask.run(item);
                        }
                        catch (Exception e5) {
                            failed = true;
                            LOG.error("Failed to revert task", (Throwable)e5);
                        }
                        if (!this.stopRevertsOnFailure || !failed) continue;
                    }
                }
                if (this.abortTask != null) {
                    boolean failed = false;
                    while (iterator.hasNext()) {
                        try {
                            this.abortTask.run(iterator.next());
                        }
                        catch (Exception e) {
                            failed = true;
                            LOG.error("Failed to abort task", (Throwable)e);
                        }
                        if (!this.stopAbortsOnFailure || !failed) continue;
                    }
                }
            }
            if (this.throwFailureWhenFinished && !exceptions.isEmpty()) {
                Tasks.throwOne(exceptions, exceptionClass);
            } else if (this.throwFailureWhenFinished && threw) {
                throw new RuntimeException("Task set failed with an uncaught throwable");
            }
            if (threw) return false;
            return true;
        }

        private void tryRunOnFailure(I item, Exception failure) {
            try {
                this.onFailure.run(item, failure);
            }
            catch (Exception failException) {
                failure.addSuppressed(failException);
                LOG.error("Failed to clean up on failure", (Throwable)failException);
            }
        }

        private <E extends Exception> boolean runParallel(final Task<I, E> task, Class<E> exceptionClass) throws E {
            final ConcurrentLinkedQueue succeeded = new ConcurrentLinkedQueue();
            final ConcurrentLinkedQueue<Throwable> exceptions = new ConcurrentLinkedQueue<Throwable>();
            final AtomicBoolean taskFailed = new AtomicBoolean(false);
            final AtomicBoolean abortFailed = new AtomicBoolean(false);
            final AtomicBoolean revertFailed = new AtomicBoolean(false);
            ArrayList futures = Lists.newArrayList();
            for (final Object item : this.items) {
                futures.add(this.service.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Override
                    public void run() {
                        if (!stopOnFailure || !taskFailed.get()) {
                            boolean threw = true;
                            try {
                                this.runTaskWithRetry(task, item);
                                succeeded.add(item);
                                threw = false;
                                return;
                            }
                            catch (Exception e) {
                                taskFailed.set(true);
                                exceptions.add(e);
                                if (onFailure == null) return;
                                this.tryRunOnFailure(item, e);
                                return;
                            }
                            finally {
                                if (threw) {
                                    taskFailed.set(true);
                                }
                            }
                        }
                        if (abortTask == null) return;
                        if (stopAbortsOnFailure && abortFailed.get()) {
                            return;
                        }
                        boolean failed = true;
                        try {
                            abortTask.run(item);
                            failed = false;
                            return;
                        }
                        catch (Exception e) {
                            LOG.error("Failed to abort task", (Throwable)e);
                            return;
                        }
                        finally {
                            if (failed) {
                                abortFailed.set(true);
                            }
                        }
                    }
                }));
            }
            exceptions.addAll(Tasks.waitFor(futures));
            futures.clear();
            if (taskFailed.get() && this.revertTask != null) {
                for (final Object item : succeeded) {
                    futures.add(this.service.submit(new Runnable(){

                        @Override
                        public void run() {
                            if (stopRevertsOnFailure && revertFailed.get()) {
                                return;
                            }
                            boolean failed = true;
                            try {
                                revertTask.run(item);
                                failed = false;
                            }
                            catch (Exception e) {
                                LOG.error("Failed to revert task", (Throwable)e);
                            }
                            finally {
                                if (failed) {
                                    revertFailed.set(true);
                                }
                            }
                        }
                    }));
                }
                exceptions.addAll(Tasks.waitFor(futures));
            }
            if (this.throwFailureWhenFinished && !exceptions.isEmpty()) {
                Tasks.throwOne(exceptions, exceptionClass);
            } else if (this.throwFailureWhenFinished && taskFailed.get()) {
                throw new RuntimeException("Task set failed with an uncaught throwable");
            }
            return !taskFailed.get();
        }

        private <E extends Exception> void runTaskWithRetry(Task<I, E> task, I item) throws E {
            long start = System.currentTimeMillis();
            int attempt = 0;
            while (true) {
                ++attempt;
                if (null != this.attemptsCounter) {
                    this.attemptsCounter.increment();
                }
                try {
                    task.run(item);
                    break;
                }
                catch (Exception e) {
                    long durationMs = System.currentTimeMillis() - start;
                    if (attempt >= this.maxAttempts || durationMs > this.maxDurationMs && attempt > 1) {
                        if (durationMs > this.maxDurationMs) {
                            LOG.info("Stopping retries after {} ms", (Object)durationMs);
                        }
                        throw e;
                    }
                    if (this.shouldRetryPredicate != null) {
                        if (!this.shouldRetryPredicate.test(e)) {
                            throw e;
                        }
                    } else if (this.onlyRetryExceptions != null) {
                        boolean matchedRetryException = false;
                        for (Class<? extends Exception> exClass : this.onlyRetryExceptions) {
                            if (!exClass.isInstance(e)) continue;
                            matchedRetryException = true;
                            break;
                        }
                        if (!matchedRetryException) {
                            throw e;
                        }
                    } else {
                        for (Class<? extends Exception> exClass : this.stopRetryExceptions) {
                            if (!exClass.isInstance(e)) continue;
                            throw e;
                        }
                    }
                    int delayMs = (int)Math.min((double)this.minSleepTimeMs * Math.pow(this.scaleFactor, attempt - 1), (double)this.maxSleepTimeMs);
                    int jitter = ThreadLocalRandom.current().nextInt(Math.max(1, (int)((double)delayMs * 0.1)));
                    int sleepTimeMs = delayMs + jitter;
                    LOG.warn("Retrying task after failure: sleepTimeMs={} {}", new Object[]{sleepTimeMs, e.getMessage(), e});
                    try {
                        TimeUnit.MILLISECONDS.sleep(sleepTimeMs);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException(ie);
                    }
                }
            }
        }
    }

    public static interface Task<I, E extends Exception> {
        public void run(I var1) throws E;
    }

    public static interface FailureTask<I, E extends Exception> {
        public void run(I var1, Exception var2) throws E;
    }

    public static class UnrecoverableException
    extends RuntimeException {
        public UnrecoverableException(String message) {
            super(message);
        }

        public UnrecoverableException(String message, Throwable cause) {
            super(message, cause);
        }

        public UnrecoverableException(Throwable cause) {
            super(cause);
        }
    }
}

