/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.admin.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.apache.polaris.core.admin.model.AuthenticationParameters;
import org.apache.polaris.core.admin.model.ConnectionConfigInfo;
import org.apache.polaris.core.admin.model.ServiceIdentityInfo;

@ApiModel(description="Configuration necessary for connecting to a Hive Catalog")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class HiveConnectionConfigInfo
extends ConnectionConfigInfo {
    private final String warehouse;

    @ApiModelProperty(value="The warehouse location for the hive catalog.")
    @JsonProperty(value="warehouse")
    public String getWarehouse() {
        return this.warehouse;
    }

    @JsonCreator
    public HiveConnectionConfigInfo(@JsonProperty(value="warehouse") String warehouse, @JsonProperty(value="connectionType", required=true) ConnectionConfigInfo.ConnectionTypeEnum connectionType, @JsonProperty(value="uri") String uri, @JsonProperty(value="authenticationParameters") AuthenticationParameters authenticationParameters, @JsonProperty(value="serviceIdentity") ServiceIdentityInfo serviceIdentity) {
        super(connectionType, uri, authenticationParameters, serviceIdentity);
        this.warehouse = warehouse;
    }

    public HiveConnectionConfigInfo(ConnectionConfigInfo.ConnectionTypeEnum connectionType) {
        super(connectionType);
        this.warehouse = null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ConnectionConfigInfo.ConnectionTypeEnum connectionType) {
        return new Builder(connectionType);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HiveConnectionConfigInfo hiveConnectionConfigInfo = (HiveConnectionConfigInfo)o;
        return super.equals(o) && Objects.equals(this.warehouse, hiveConnectionConfigInfo.warehouse);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.warehouse);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HiveConnectionConfigInfo {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    warehouse: ").append(this.toIndentedString(this.warehouse)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class Builder {
        private String warehouse;
        private ConnectionConfigInfo.ConnectionTypeEnum connectionType;
        private String uri;
        private AuthenticationParameters authenticationParameters;
        private ServiceIdentityInfo serviceIdentity;

        private Builder() {
        }

        private Builder(ConnectionConfigInfo.ConnectionTypeEnum connectionType) {
            this.connectionType = connectionType;
        }

        public Builder setWarehouse(String warehouse) {
            this.warehouse = warehouse;
            return this;
        }

        public Builder setConnectionType(ConnectionConfigInfo.ConnectionTypeEnum connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        public Builder setUri(String uri) {
            this.uri = uri;
            return this;
        }

        public Builder setAuthenticationParameters(AuthenticationParameters authenticationParameters) {
            this.authenticationParameters = authenticationParameters;
            return this;
        }

        public Builder setServiceIdentity(ServiceIdentityInfo serviceIdentity) {
            this.serviceIdentity = serviceIdentity;
            return this;
        }

        public HiveConnectionConfigInfo build() {
            HiveConnectionConfigInfo inst = new HiveConnectionConfigInfo(this.warehouse, this.connectionType, this.uri, this.authenticationParameters, this.serviceIdentity);
            return inst;
        }
    }
}

