/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.smallrye.config.WithParentName;
import java.util.HashMap;
import java.util.Map;
import org.apache.polaris.service.config.ConfigurationUtils;

public interface RealmOverridable {
    @WithParentName
    public Map<String, String> defaults();

    public Map<String, RealmOverrides> realmOverrides();

    default public Map<String, Object> parseDefaults(ObjectMapper objectMapper) {
        return ConfigurationUtils.convertMap(objectMapper, this.defaults());
    }

    default public Map<String, Map<String, Object>> parseRealmOverrides(ObjectMapper objectMapper) {
        HashMap<String, Map<String, Object>> m = new HashMap<String, Map<String, Object>>();
        for (String realm : this.realmOverrides().keySet()) {
            m.put(realm, ConfigurationUtils.convertMap(objectMapper, this.realmOverrides().get(realm).overrides()));
        }
        return m;
    }

    public static interface RealmOverrides {
        @WithParentName
        public Map<String, String> overrides();
    }
}

