/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.auth;

import com.google.common.base.Throwables;
import io.smallrye.common.annotation.Identifier;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.iceberg.exceptions.NotAuthorizedException;
import org.apache.iceberg.exceptions.ServiceFailureException;
import org.apache.polaris.core.PolarisCallContext;
import org.apache.polaris.core.auth.PolarisPrincipal;
import org.apache.polaris.core.context.CallContext;
import org.apache.polaris.core.entity.PolarisEntity;
import org.apache.polaris.core.entity.PolarisEntityCore;
import org.apache.polaris.core.entity.PolarisEntityType;
import org.apache.polaris.core.entity.PrincipalRoleEntity;
import org.apache.polaris.core.persistence.MetaStoreManagerFactory;
import org.apache.polaris.core.persistence.PolarisMetaStoreManager;
import org.apache.polaris.core.persistence.dao.entity.BaseResult;
import org.apache.polaris.core.persistence.dao.entity.EntityResult;
import org.apache.polaris.core.persistence.dao.entity.LoadGrantsResult;
import org.apache.polaris.service.auth.ActiveRolesProvider;
import org.apache.polaris.service.auth.PersistedPolarisPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
@Identifier(value="default")
@Deprecated
public class DefaultActiveRolesProvider
implements ActiveRolesProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultActiveRolesProvider.class);
    @Inject
    CallContext callContext;
    @Inject
    MetaStoreManagerFactory metaStoreManagerFactory;

    @Override
    public Set<String> getActiveRoles(PolarisPrincipal principal) {
        if (!(principal instanceof PersistedPolarisPrincipal)) {
            LOGGER.error("Expected an PersistedPolarisPrincipal, but got {}: {}", (Object)principal.getClass().getName(), (Object)Throwables.getStackTraceAsString((Throwable)new ServiceFailureException("Invalid principal type", new Object[0])));
            throw new NotAuthorizedException("Unable to authenticate", new Object[0]);
        }
        PersistedPolarisPrincipal persistedPolarisPrincipal = (PersistedPolarisPrincipal)principal;
        List<PrincipalRoleEntity> activeRoles = this.loadActivePrincipalRoles(principal.getRoles(), (PolarisEntity)persistedPolarisPrincipal.getEntity(), this.metaStoreManagerFactory.getOrCreateMetaStoreManager(this.callContext.getRealmContext()));
        return activeRoles.stream().map(PolarisEntityCore::getName).collect(Collectors.toSet());
    }

    protected List<PrincipalRoleEntity> loadActivePrincipalRoles(Set<String> tokenRoles, PolarisEntity principal, PolarisMetaStoreManager metaStoreManager) {
        PolarisCallContext polarisContext = this.callContext.getPolarisCallContext();
        LoadGrantsResult principalGrantResults = metaStoreManager.loadGrantsToGrantee(polarisContext, (PolarisEntityCore)principal);
        polarisContext.getDiagServices().check(principalGrantResults.isSuccess(), "Failed to resolve principal roles for principal name={} id={}", principal.getName(), new Object[]{principal.getId()});
        if (!principalGrantResults.isSuccess()) {
            LOGGER.warn("Failed to resolve principal roles for principal name={} id={}", (Object)principal.getName(), (Object)principal.getId());
            throw new NotAuthorizedException("Unable to authenticate", new Object[0]);
        }
        boolean allRoles = tokenRoles.isEmpty();
        Predicate<PrincipalRoleEntity> includeRoleFilter = allRoles ? r -> true : r -> tokenRoles.contains(r.getName());
        List<PrincipalRoleEntity> activeRoles = principalGrantResults.getGrantRecords().stream().map(gr -> metaStoreManager.loadEntity(polarisContext, gr.getSecurableCatalogId(), gr.getSecurableId(), PolarisEntityType.PRINCIPAL_ROLE)).filter(BaseResult::isSuccess).map(EntityResult::getEntity).map(PrincipalRoleEntity::of).filter(includeRoleFilter).toList();
        if (activeRoles.size() != principalGrantResults.getGrantRecords().size()) {
            LOGGER.atWarn().addKeyValue("principal", (Object)principal.getName()).addKeyValue("scopes", tokenRoles).addKeyValue("roles", activeRoles).log("Some principal roles were not found in the principal's grants");
        }
        return activeRoles;
    }
}

