/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.helpers.spies;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.helpers.spies.MultiSpyBase;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.concurrent.atomic.AtomicLong;

public class MultiOnRequestSpy<T>
extends MultiSpyBase<T> {
    private final AtomicLong requestedCount = new AtomicLong();

    public long requestedCount() {
        return this.requestedCount.get();
    }

    public MultiOnRequestSpy(Multi<? extends T> upstream) {
        super(upstream);
    }

    @Override
    public void reset() {
        super.reset();
        this.requestedCount.set(0L);
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> downstream) {
        this.upstream.onRequest().invoke((long count) -> {
            this.incrementInvocationCount();
            Subscriptions.add(this.requestedCount, count);
        }).subscribe().withSubscriber(downstream);
    }

    @Override
    public String toString() {
        return "MultiOnRequestSpy{requestedCount=" + String.valueOf(this.requestedCount) + "} " + super.toString();
    }
}

