/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.persistence;

import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.processors.cache.persistence.filename.PdsFolderResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ignite2PersistenceTools {
    private static final Logger LOGGER = LoggerFactory.getLogger(Ignite2PersistenceTools.class);
    private static final Pattern MASKED_UUID_PATTERN = Pattern.compile("[a-fA-F0-9]{8}_[a-fA-F0-9]{4}_[a-fA-F0-9]{4}_[a-fA-F0-9]{4}_[a-fA-F0-9]{12}");
    private static final Method FIND_PERSISTENT_STORAGE_PATH_METHOD;
    private static final Method FIND_NODE_FOLDERS_METHOD;
    private static final FileFilter DB_SUBFOLDERS_OLD_STYLE_FILTER;

    public static List<NodeFolderDescriptor> nodeFolderCandidates(IgniteConfiguration cfg) {
        List candidates;
        File dbFolderFile;
        if (cfg.getWorkDirectory() == null) {
            throw new IllegalArgumentException("WorkDirectory must not be null");
        }
        if (cfg.getDataStorageConfiguration() == null) {
            throw new IllegalArgumentException("DataStorageConfiguration must not be null");
        }
        try {
            PdsFolderResolver folderResolver = new PdsFolderResolver(cfg, null, null, null);
            dbFolderFile = (File)FIND_PERSISTENT_STORAGE_PATH_METHOD.invoke((Object)folderResolver, false);
            candidates = (List)FIND_NODE_FOLDERS_METHOD.invoke((Object)folderResolver, dbFolderFile);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        if (candidates == null || candidates.isEmpty()) {
            File[] oldStyleFolders = dbFolderFile.listFiles(DB_SUBFOLDERS_OLD_STYLE_FILTER);
            if (oldStyleFolders != null && oldStyleFolders.length != 0) {
                ArrayList<NodeFolderDescriptor> ret = new ArrayList<NodeFolderDescriptor>(oldStyleFolders.length);
                for (File folder : oldStyleFolders) {
                    String folderName = folder.getName();
                    Matcher matcher = MASKED_UUID_PATTERN.matcher(folderName);
                    if (matcher.matches()) {
                        String uuidStr = folderName.replace('_', '-');
                        UUID uuid = UUID.fromString(uuidStr);
                        ret.add(new NodeFolderDescriptor(folder, uuid));
                        continue;
                    }
                    LOGGER.warn("Could not capture consistentId (UUID) from node folder, falling back to String: {}", (Object)folder.getPath());
                    ret.add(new NodeFolderDescriptor(folder, (Serializable)((Object)folderName)));
                }
                return ret;
            }
            return Collections.emptyList();
        }
        return candidates.stream().map(folderCandidate -> new NodeFolderDescriptor(folderCandidate.subFolderFile(), folderCandidate.uuid())).collect(Collectors.toList());
    }

    static {
        try {
            FIND_PERSISTENT_STORAGE_PATH_METHOD = PdsFolderResolver.class.getDeclaredMethod("resolvePersistentStoreBasePath", Boolean.TYPE);
            FIND_PERSISTENT_STORAGE_PATH_METHOD.setAccessible(true);
            FIND_NODE_FOLDERS_METHOD = PdsFolderResolver.class.getDeclaredMethod("getNodeIndexSortedCandidates", File.class);
            FIND_NODE_FOLDERS_METHOD.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        try {
            Field field = PdsFolderResolver.class.getDeclaredField("DB_SUBFOLDERS_OLD_STYLE_FILTER");
            field.setAccessible(true);
            DB_SUBFOLDERS_OLD_STYLE_FILTER = (FileFilter)field.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static class NodeFolderDescriptor {
        private final File subFolderFile;
        private final Serializable consistentId;

        public NodeFolderDescriptor(File subFolderFile, Serializable consistentId) {
            this.subFolderFile = subFolderFile;
            this.consistentId = consistentId;
        }

        public Serializable consistentId() {
            return this.consistentId;
        }

        public File subFolderFile() {
            return this.subFolderFile;
        }
    }
}

