/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.raft.storage.segstore;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite3.internal.close.ManuallyCloseable;
import org.apache.ignite3.internal.failure.FailureProcessor;
import org.apache.ignite3.internal.lang.IgniteInternalException;
import org.apache.ignite3.internal.raft.storage.segstore.IndexFileManager;
import org.apache.ignite3.internal.raft.storage.segstore.IndexMemTable;
import org.apache.ignite3.internal.raft.storage.segstore.RaftLogCheckpointer;
import org.apache.ignite3.internal.raft.storage.segstore.SegmentFile;
import org.apache.ignite3.internal.raft.storage.segstore.SegmentPayload;
import org.apache.ignite3.internal.raft.storage.segstore.WriteModeIndexMemTable;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.raft.jraft.entity.LogEntry;
import org.apache.ignite3.raft.jraft.entity.codec.LogEntryEncoder;

class SegmentFileManager
implements ManuallyCloseable {
    private static final int ROLLOVER_WAIT_TIMEOUT_MS = 30000;
    private static final int MAGIC_NUMBER = -17958194;
    private static final int FORMAT_VERSION = 1;
    private static final String SEGMENT_FILE_NAME_FORMAT = "segment-%010d-%010d.bin";
    static final byte[] HEADER_RECORD = ByteBuffer.allocate(8).order(SegmentFile.BYTE_ORDER).putInt(-17958194).putInt(1).array();
    static final byte[] SWITCH_SEGMENT_RECORD = new byte[8];
    private final Path baseDir;
    private final long fileSize;
    private final int stripes;
    private final AtomicReference<SegmentFile> currentSegmentFile = new AtomicReference();
    private WriteModeIndexMemTable memTable;
    private final RaftLogCheckpointer checkpointer;
    private final Object rolloverLock = new Object();
    private int curSegmentFileOrdinal;
    private boolean isStopped;

    SegmentFileManager(String nodeName, Path baseDir, long fileSize, int stripes, FailureProcessor failureProcessor) {
        if (fileSize <= (long)HEADER_RECORD.length) {
            throw new IllegalArgumentException("File size must be greater than the header size: " + fileSize);
        }
        this.baseDir = baseDir;
        this.fileSize = fileSize;
        this.stripes = stripes;
        this.memTable = new IndexMemTable(stripes);
        this.checkpointer = new RaftLogCheckpointer(nodeName, new IndexFileManager(baseDir), failureProcessor);
    }

    void start() throws IOException {
        this.checkpointer.start();
        this.currentSegmentFile.set(this.allocateNewSegmentFile(0));
    }

    private SegmentFile allocateNewSegmentFile(int fileOrdinal) throws IOException {
        Path path = this.baseDir.resolve(SegmentFileManager.segmentFileName(fileOrdinal, 0));
        SegmentFile segmentFile = new SegmentFile(path, this.fileSize, 0L);
        SegmentFileManager.writeHeader(segmentFile);
        return segmentFile;
    }

    private static String segmentFileName(int fileOrdinal, int generation) {
        return String.format(SEGMENT_FILE_NAME_FORMAT, fileOrdinal, generation);
    }

    void appendEntry(long groupId, LogEntry entry, LogEntryEncoder encoder) throws IOException {
        SegmentPayload segmentPayload = new SegmentPayload(groupId, entry, encoder);
        int payloadSize = segmentPayload.size();
        if ((long)payloadSize > this.maxEntrySize()) {
            throw new IllegalArgumentException(String.format("Entry size is too big (%d bytes), maximum allowed entry size: %d bytes.", payloadSize, this.maxEntrySize()));
        }
        while (true) {
            SegmentFile segmentFile = this.currentSegmentFile();
            try (SegmentFile.WriteBuffer writeBuffer = segmentFile.reserve(payloadSize);){
                if (writeBuffer != null) {
                    int segmentOffset = writeBuffer.buffer().position();
                    segmentPayload.writeTo(writeBuffer.buffer());
                    this.memTable.appendSegmentFileOffset(groupId, entry.getId().getIndex(), segmentOffset);
                    return;
                }
            }
            this.initiateRollover(segmentFile);
        }
    }

    private SegmentFile currentSegmentFile() {
        SegmentFile segmentFile = this.currentSegmentFile.get();
        if (segmentFile != null) {
            return segmentFile;
        }
        try {
            Object object = this.rolloverLock;
            synchronized (object) {
                while (true) {
                    if (this.isStopped) {
                        throw new IgniteInternalException(ErrorGroups.Common.NODE_STOPPING_ERR);
                    }
                    segmentFile = this.currentSegmentFile.get();
                    if (segmentFile != null) {
                        return segmentFile;
                    }
                    this.rolloverLock.wait(30000L);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, "Interrupted while waiting for rollover.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initiateRollover(SegmentFile observedSegmentFile) throws IOException {
        if (!this.currentSegmentFile.compareAndSet(observedSegmentFile, null)) {
            return;
        }
        observedSegmentFile.closeForRollover(SWITCH_SEGMENT_RECORD);
        Object object = this.rolloverLock;
        synchronized (object) {
            if (this.isStopped) {
                throw new IgniteInternalException(ErrorGroups.Common.NODE_STOPPING_ERR);
            }
            SegmentFile newFile = this.allocateNewSegmentFile(++this.curSegmentFileOrdinal);
            this.checkpointer.onRollover(observedSegmentFile, this.memTable.transitionToReadMode());
            this.memTable = new IndexMemTable(this.stripes);
            this.currentSegmentFile.set(newFile);
            this.rolloverLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        Object object = this.rolloverLock;
        synchronized (object) {
            if (this.isStopped) {
                return;
            }
            this.isStopped = true;
            SegmentFile segmentFile = this.currentSegmentFile.getAndSet(null);
            if (segmentFile != null) {
                segmentFile.close();
            }
            this.rolloverLock.notifyAll();
        }
        this.checkpointer.stop();
    }

    private static void writeHeader(SegmentFile segmentFile) {
        try (SegmentFile.WriteBuffer writeBuffer = segmentFile.reserve(HEADER_RECORD.length);){
            assert (writeBuffer != null);
            writeBuffer.buffer().put(HEADER_RECORD);
        }
    }

    private long maxEntrySize() {
        return this.fileSize - (long)HEADER_RECORD.length;
    }
}

