/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.fileio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.apache.ignite3.internal.fileio.FileIo;

public abstract class AbstractFileIo
implements FileIo {
    private static final int MAX_IO_TIMEOUT_MS = 2000;

    @Override
    public int readFully(ByteBuffer destBuf) throws IOException {
        return this.fully(offs -> this.read(destBuf), this.position(), destBuf.remaining(), false);
    }

    @Override
    public int readFully(ByteBuffer destBuf, long position) throws IOException {
        return this.fully(offs -> this.read(destBuf, position + (long)offs), position, destBuf.remaining(), false);
    }

    @Override
    public int readFully(byte[] buf, int off, int len) throws IOException {
        return this.fully(offs -> this.read(buf, off + offs, len - offs), this.position(), len, false);
    }

    @Override
    public int writeFully(ByteBuffer srcBuf) throws IOException {
        return this.fully(offs -> this.write(srcBuf), this.position(), srcBuf.remaining(), true);
    }

    @Override
    public int writeFully(ByteBuffer srcBuf, long position) throws IOException {
        return this.fully(offs -> this.write(srcBuf, position + (long)offs), position, srcBuf.remaining(), true);
    }

    @Override
    public int writeFully(byte[] buf, int off, int len) throws IOException {
        return this.fully(offs -> this.write(buf, off + offs, len - offs), this.position(), len, true);
    }

    private int available(int requested, long position) throws IOException {
        long available = this.size() - position;
        return (long)requested > available ? (int)available : requested;
    }

    private int fully(IoOperation operation, long position, int num, boolean write) throws IOException {
        if (num > 0) {
            long time = 0L;
            int i = 0;
            while (i < num) {
                int n = operation.run(i);
                if (n > 0) {
                    i += n;
                    time = 0L;
                    continue;
                }
                if (n == 0 || i > 0) {
                    if (!write && this.available(num - i, position + (long)i) == 0) {
                        return i;
                    }
                    if (time == 0L) {
                        time = System.nanoTime();
                        continue;
                    }
                    if (System.nanoTime() - time < TimeUnit.MILLISECONDS.toNanos(2000L)) continue;
                    throw new IOException(write && position + (long)i == this.size() ? "Failed to extend file." : "Probably disk is too busy, please check your device.");
                }
                return -1;
            }
        }
        return num;
    }

    private static interface IoOperation {
        public int run(int var1) throws IOException;
    }
}

