/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.visitor;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.order.Ordered;
import io.micronaut.core.reflect.GenericTypeUtils;
import io.micronaut.core.util.Toggleable;
import io.micronaut.inject.ast.beans.BeanElement;
import io.micronaut.inject.visitor.BeanElementVisitorLoader;
import io.micronaut.inject.visitor.VisitorContext;
import java.lang.annotation.Annotation;
import java.util.List;

public interface BeanElementVisitor<A extends Annotation>
extends Ordered,
Toggleable {
    public static final List<BeanElementVisitor<?>> VISITORS = BeanElementVisitorLoader.load();

    @Nullable
    public BeanElement visitBeanElement(@NonNull BeanElement var1, @NonNull VisitorContext var2);

    default public void start(VisitorContext visitorContext) {
    }

    default public void finish(VisitorContext visitorContext) {
    }

    default public boolean supports(@NonNull BeanElement beanElement) {
        if (beanElement == null) {
            return false;
        }
        Class<Annotation> t = GenericTypeUtils.resolveInterfaceTypeArgument(this.getClass(), BeanElementVisitor.class).orElse(Annotation.class);
        if (t == Annotation.class) {
            return true;
        }
        return beanElement.hasAnnotation(t.getName());
    }
}

