/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.table;

import java.util.function.Function;
import org.apache.ignite.internal.client.table.ClientSchema;
import org.apache.ignite.internal.client.tx.ClientLazyTransaction;
import org.jetbrains.annotations.Nullable;

public class PartitionAwarenessProvider {
    @Nullable
    private final Integer partition;
    @Nullable
    private final Function<ClientSchema, Integer> hashFunc;
    @Nullable
    private final ClientLazyTransaction tx;

    private PartitionAwarenessProvider(@Nullable Function<ClientSchema, Integer> hashFunc, @Nullable Integer partition, @Nullable ClientLazyTransaction tx) {
        this.hashFunc = hashFunc;
        this.partition = partition;
        this.tx = tx;
    }

    public static PartitionAwarenessProvider of(Integer partition) {
        return new PartitionAwarenessProvider(null, partition, null);
    }

    public static PartitionAwarenessProvider of(@Nullable ClientLazyTransaction tx, Function<ClientSchema, Integer> hashFunc) {
        return new PartitionAwarenessProvider(hashFunc, null, tx);
    }

    @Nullable
    String nodeName() {
        return this.tx != null ? this.tx.nodeName() : null;
    }

    @Nullable
    Integer partition() {
        return this.partition;
    }

    Integer getObjectHashCode(ClientSchema schema) {
        if (this.hashFunc == null) {
            throw new IllegalStateException("Partition awareness is not enabled. Check channel() first.");
        }
        return this.hashFunc.apply(schema);
    }

    boolean isPartitionAwarenessEnabled() {
        return this.hashFunc != null || this.partition != null;
    }
}

