/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.bind.binders;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.version.annotation.Version;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.client.annotation.Client;
import io.micronaut.http.client.bind.AnnotatedClientRequestBinder;
import io.micronaut.http.client.bind.ClientRequestUriContext;
import io.micronaut.http.client.interceptor.configuration.ClientVersioningConfiguration;
import io.micronaut.inject.qualifiers.Qualifiers;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class VersionClientRequestBinder
implements AnnotatedClientRequestBinder<Version> {
    private final Map<String, ClientVersioningConfiguration> versioningConfigurations = new ConcurrentHashMap<String, ClientVersioningConfiguration>(5);
    private final BeanContext beanContext;

    public VersionClientRequestBinder(BeanContext beanContext) {
        this.beanContext = beanContext;
    }

    @Override
    public void bind(@NonNull MethodInvocationContext<Object, Object> context, @NonNull ClientRequestUriContext uriContext, @NonNull MutableHttpRequest<?> request) {
        context.findAnnotation(Version.class).flatMap(AnnotationValue::stringValue).filter(StringUtils::isNotEmpty).ifPresent(version -> {
            ClientVersioningConfiguration configuration = this.getVersioningConfiguration(context.getAnnotationMetadata());
            configuration.getHeaders().forEach(header -> request.header((CharSequence)header, (CharSequence)version));
            configuration.getParameters().forEach(parameter -> uriContext.addQueryParameter((String)parameter, (String)version));
        });
    }

    @Override
    @NonNull
    public Class<Version> getAnnotationType() {
        return Version.class;
    }

    private ClientVersioningConfiguration getVersioningConfiguration(AnnotationMetadata annotationMetadata) {
        return this.versioningConfigurations.computeIfAbsent(this.getClientId(annotationMetadata), clientId -> this.beanContext.findBean(ClientVersioningConfiguration.class, Qualifiers.byName((String)clientId)).orElseGet(() -> (ClientVersioningConfiguration)this.beanContext.findBean(ClientVersioningConfiguration.class, Qualifiers.byName((String)"default")).orElseThrow(() -> new ConfigurationException("Attempt to apply a '@Version' to the request, but versioning configuration found neither for '" + clientId + "' nor '" + "default" + "' provided."))));
    }

    private String getClientId(AnnotationMetadata clientAnn) {
        return clientAnn.stringValue(Client.class).orElse(null);
    }
}

