/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.table;

import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.internal.client.sql.ClientSql;
import org.apache.ignite.internal.client.table.ClientColumn;
import org.apache.ignite.internal.client.table.ClientSchema;
import org.apache.ignite.internal.client.table.ClientTable;
import org.apache.ignite.internal.sql.StatementBuilderImpl;
import org.apache.ignite.internal.table.criteria.CriteriaExceptionMapperUtil;
import org.apache.ignite.internal.table.criteria.CursorAdapter;
import org.apache.ignite.internal.table.criteria.QueryCriteriaAsyncCursor;
import org.apache.ignite.internal.table.criteria.SqlSerializer;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.internal.util.ViewUtils;
import org.apache.ignite.lang.AsyncCursor;
import org.apache.ignite.lang.Cursor;
import org.apache.ignite.lang.util.IgniteNameUtils;
import org.apache.ignite.shaded.org.jetbrains.annotations.Nullable;
import org.apache.ignite.sql.ResultSetMetadata;
import org.apache.ignite.sql.SqlRow;
import org.apache.ignite.sql.Statement;
import org.apache.ignite.sql.async.AsyncResultSet;
import org.apache.ignite.table.criteria.Criteria;
import org.apache.ignite.table.criteria.CriteriaQueryOptions;
import org.apache.ignite.table.criteria.CriteriaQuerySource;
import org.apache.ignite.tx.Transaction;

abstract class AbstractClientView<T>
implements CriteriaQuerySource<T> {
    protected final ClientTable tbl;
    protected final ClientSql sql;

    AbstractClientView(ClientTable tbl, ClientSql sql) {
        assert (tbl != null);
        assert (sql != null);
        this.tbl = tbl;
        this.sql = sql;
    }

    protected static String[] columnNames(ClientColumn[] columns) {
        String[] columnNames = new String[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            columnNames[i] = columns[i].name();
        }
        return columnNames;
    }

    protected static SqlSerializer createSqlSerializer(String tableName, ClientColumn[] columns, @Nullable Criteria criteria) {
        Set<String> columnNames = Arrays.stream(columns).map(ClientColumn::name).collect(Collectors.toSet());
        return new SqlSerializer.Builder().tableName(IgniteNameUtils.parseSimpleName(tableName)).columns(columnNames).where(criteria).build();
    }

    @Nullable
    protected Function<SqlRow, T> queryMapper(ResultSetMetadata meta, ClientSchema schema) {
        return null;
    }

    @Override
    public Cursor<T> query(@Nullable Transaction tx, @Nullable Criteria criteria, @Nullable String indexName, @Nullable CriteriaQueryOptions opts) {
        return new CursorAdapter<T>(ViewUtils.sync(this.queryAsync(tx, criteria, null, opts)));
    }

    @Override
    public CompletableFuture<AsyncCursor<T>> queryAsync(@Nullable Transaction tx, @Nullable Criteria criteria, @Nullable String indexName, @Nullable CriteriaQueryOptions opts) {
        CriteriaQueryOptions opts0 = opts == null ? CriteriaQueryOptions.DEFAULT : opts;
        return ((CompletableFuture)this.tbl.getLatestSchema().thenCompose(schema -> {
            SqlSerializer ser = AbstractClientView.createSqlSerializer(this.tbl.name(), schema.columns(), criteria);
            Statement statement = new StatementBuilderImpl().query(ser.toString()).pageSize(opts0.pageSize()).build();
            return this.sql.executeAsync(tx, statement, ser.getArguments()).thenApply(resultSet -> {
                ResultSetMetadata meta = resultSet.metadata();
                assert (meta != null) : "Metadata can't be null.";
                return new QueryCriteriaAsyncCursor<T, SqlRow>((AsyncResultSet<SqlRow>)resultSet, this.queryMapper(meta, (ClientSchema)schema), () -> {});
            });
        })).exceptionally(th -> {
            throw new CompletionException(CriteriaExceptionMapperUtil.mapToPublicCriteriaException(ExceptionUtils.unwrapCause(th)));
        });
    }
}

