/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.protocols;

import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.testng.collections.Lists;
import org.testng.internal.Utils;
import org.testng.internal.protocols.BundledResourceProcessor;
import org.testng.internal.protocols.FileProcessor;
import org.testng.internal.protocols.Input;
import org.testng.internal.protocols.JarProcessor;
import org.testng.internal.protocols.NoOpProcessor;

public abstract class Processor {
    protected static final String CLS_NAME = Processor.class.getSimpleName();

    public static Processor newInstance(String protocol) {
        Processor instance;
        switch (protocol.toLowerCase()) {
            case "file": {
                instance = new FileProcessor();
                break;
            }
            case "jar": {
                instance = new JarProcessor();
                break;
            }
            case "bundleresource": {
                instance = new BundledResourceProcessor();
                break;
            }
            default: {
                instance = new NoOpProcessor();
            }
        }
        return instance;
    }

    public abstract List<String> process(Input var1, URL var2);

    protected static List<String> findClassesInDirPackage(String packageName, List<String> included, List<String> excluded, String packagePath, boolean recursive) {
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return Lists.newArrayList();
        }
        File[] dirfiles = dir.listFiles(file -> recursive && file.isDirectory() || file.getName().endsWith(".class") || file.getName().endsWith(".groovy"));
        Utils.log(CLS_NAME, 4, "Looking for test classes in the directory: " + String.valueOf(dir));
        if (dirfiles == null) {
            return Lists.newArrayList();
        }
        List<String> classes = Lists.newArrayList();
        for (File file2 : dirfiles) {
            if (file2.isDirectory()) {
                List<String> foundClasses = Processor.findClassesInDirPackage(Processor.makeFullClassName(packageName, file2.getName()), included, excluded, file2.getAbsolutePath(), recursive);
                classes.addAll(foundClasses);
                continue;
            }
            String className = file2.getName().substring(0, file2.getName().lastIndexOf(46));
            Utils.log(CLS_NAME, 4, "Found class " + className + ", seeing it if it's included or excluded");
            List<String> processedList = Processor.includeOrExcludeClass(packageName, className, included, excluded);
            classes.addAll(processedList);
        }
        return classes;
    }

    private static String makeFullClassName(String pkg, String cls) {
        return pkg.length() > 0 ? pkg + "." + cls : cls;
    }

    protected static List<String> includeOrExcludeClass(String packageName, String className, List<String> included, List<String> excluded) {
        List<String> classes = Lists.newArrayList();
        if (Processor.isIncluded(packageName, included, excluded)) {
            Utils.log(CLS_NAME, 4, "... Including class " + className);
            classes.add(Processor.makeFullClassName(packageName, className));
        } else {
            Utils.log(CLS_NAME, 4, "... Excluding class " + className);
        }
        return classes;
    }

    private static boolean isIncluded(String name, List<String> included, List<String> excluded) {
        if (included.isEmpty() && excluded.isEmpty()) {
            return true;
        }
        boolean isIncluded = Processor.find(name, included);
        boolean isExcluded = Processor.find(name, excluded);
        boolean result = isIncluded && !isExcluded ? true : (isExcluded ? false : included.isEmpty());
        return result;
    }

    private static boolean find(String name, List<String> list) {
        return ((Stream)list.stream().parallel()).anyMatch(each -> Pattern.matches(each, name));
    }
}

