/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.felix.webconsole.internal.Util;

public class NavigationRenderer {
    public static final String HEADER;
    public static final String FOOTER;

    public static void renderTopNavigation(PrintWriter pw, String appRoot, Map menuMap, Map langMap, Locale reqLocale) {
        NavigationRenderer.renderMenu(menuMap, appRoot, pw);
        if (null != langMap && !langMap.isEmpty()) {
            String locale;
            String string = locale = null != reqLocale ? reqLocale.getLanguage() : Locale.getDefault().getLanguage();
            if (!langMap.containsKey(locale)) {
                locale = Locale.getDefault().getLanguage();
            }
            if (!langMap.containsKey(locale)) {
                locale = "en";
            }
            pw.println("<div id='langSelect'>");
            pw.println(" <span>");
            NavigationRenderer.printLocaleElement(pw, appRoot, locale, langMap.get(locale));
            pw.println(" </span>");
            pw.println(" <span class='flags ui-helper-hidden'>");
            for (Object l : langMap.keySet()) {
                if (l.equals(locale)) continue;
                NavigationRenderer.printLocaleElement(pw, appRoot, l, langMap.get(l));
            }
            pw.println(" </span>");
            pw.println("</div>");
        }
    }

    private static SortedMap sortMenuCategoryMap(Map map, String appRoot) {
        TreeMap<String, MenuItem> sortedMap = new TreeMap<String, MenuItem>(String.CASE_INSENSITIVE_ORDER);
        for (String key : map.keySet()) {
            if (key.startsWith("category.")) {
                SortedMap categoryMap = NavigationRenderer.sortMenuCategoryMap((Map)map.get(key), appRoot);
                String title = key.substring(key.indexOf(46) + 1);
                if (sortedMap.containsKey(title)) {
                    ((MenuItem)sortedMap.get(title)).setSubMenu(categoryMap);
                    continue;
                }
                String link = "<a href=\"#\">" + title + "</a>";
                MenuItem menuItem = new MenuItem(link, categoryMap);
                sortedMap.put(title, menuItem);
                continue;
            }
            String title = (String)map.get(key);
            String link = "<a href=\"" + appRoot + "/" + key + "\">" + title + "</a>";
            if (sortedMap.containsKey(title)) {
                ((MenuItem)sortedMap.get(title)).setLink(link);
                continue;
            }
            MenuItem menuItem = new MenuItem(link);
            sortedMap.put(title, menuItem);
        }
        return sortedMap;
    }

    private static void renderMenu(Map menuMap, String appRoot, PrintWriter pw) {
        if (menuMap != null) {
            SortedMap categoryMap = NavigationRenderer.sortMenuCategoryMap(menuMap, appRoot);
            pw.println("<ul id=\"navmenu\">");
            NavigationRenderer.renderSubmenu(categoryMap, appRoot, pw, 0);
            pw.println("<li class=\"logoutButton navMenuItem-0\">");
            pw.println("<a href=\"" + appRoot + "/logout\">${logout}</a>");
            pw.println("</li>");
            pw.println("</ul>");
        }
    }

    private static void renderMenu(Map menuMap, String appRoot, PrintWriter pw, int level) {
        pw.println("<ul class=\"navMenuLevel-" + level + "\">");
        NavigationRenderer.renderSubmenu(menuMap, appRoot, pw, level);
        pw.println("</ul>");
    }

    private static void renderSubmenu(Map menuMap, String appRoot, PrintWriter pw, int level) {
        String liStyleClass = " class=\"navMenuItem-" + level + "\"";
        for (String key : menuMap.keySet()) {
            MenuItem menuItem = (MenuItem)menuMap.get(key);
            pw.println("<li" + liStyleClass + ">" + menuItem.getLink());
            Map subMenu = menuItem.getSubMenu();
            if (subMenu != null) {
                NavigationRenderer.renderMenu(subMenu, appRoot, pw, level + 1);
            }
            pw.println("</li>");
        }
    }

    private static final void printLocaleElement(PrintWriter pw, String appRoot, Object langCode, Object langName) {
        pw.print("  <img src='");
        pw.print(appRoot);
        pw.print("/res/flags/");
        pw.print(langCode);
        pw.print(".gif' alt='");
        pw.print(langCode);
        pw.print("' title='");
        pw.print(langName);
        pw.println("'/>");
    }

    static {
        try {
            HEADER = Util.readTemplateFile(NavigationRenderer.class, "/templates/main_header.html");
            FOOTER = Util.readTemplateFile(NavigationRenderer.class, "/templates/main_footer.html");
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private static class MenuItem {
        private String link;
        private Map subMenu;

        public MenuItem(String link) {
            this.link = link;
        }

        public MenuItem(String link, Map subMenu) {
            this.link = link;
            this.subMenu = subMenu;
        }

        public String getLink() {
            return this.link;
        }

        public void setLink(String link) {
            this.link = link;
        }

        public Map getSubMenu() {
            return this.subMenu;
        }

        public void setSubMenu(Map subMenu) {
            this.subMenu = subMenu;
        }
    }
}

