/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.dubbo.demo.consumer;


import org.apache.dubbo.demo.*;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class Consumer {

    public static void main(String[] args) {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(new String[]{"META-INF/spring/dubbo-demo-consumer.xml"});
        context.start();

        DemoProvider demoService = (DemoProvider) context.getBean("demoProvider"); // 获取远程服务代理
        String hello = demoService.sayHello("world"); // 执行远程方法
        System.out.println(hello); // 显示调用结果


        String res = demoService.echo();
        System.out.println(res);
        UserRequest request = new UserRequest();
        request.setId(1);
        request.setEmail("dubbo-js@gmail.com");
        request.setName("node-dubbo");

        UserResponse userInfo = demoService.getUserInfo(request);
        System.out.println(userInfo);

        BasicTypeProvider basicTypeService = (BasicTypeProvider) context.getBean("basicTypeProvider");
        System.out.println(basicTypeService.testBasicType(new TypeRequest()));

        try {
            Thread.sleep(30000);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}
