/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import java.lang.foreign.MemorySegment;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.kll.KllDirectDoublesSketch;
import org.apache.datasketches.kll.KllDoublesSketch;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class KllDirectCompactDoublesSketchTest {
    private static final boolean enablePrinting = false;

    @Test
    public void checkRODirectUpdatable_ROandWritable() {
        int k = 20;
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 21; ++i) {
            sk.update((double)i);
        }
        byte[] byteArr = KllHelper.toByteArray((KllSketch)sk, (boolean)true);
        MemorySegment srcSeg = MemorySegment.ofArray(byteArr).asReadOnly();
        KllDoublesSketch sk2 = KllDoublesSketch.wrap((MemorySegment)srcSeg);
        Assert.assertTrue((boolean)(sk2 instanceof KllDirectDoublesSketch));
        Assert.assertTrue((boolean)sk2.isMemorySegmentUpdatableFormat());
        Assert.assertTrue((boolean)sk2.isReadOnly());
        Assert.assertEquals((double)sk2.getMinItem(), (double)1.0);
        Assert.assertEquals((double)sk2.getMaxItem(), (double)21.0);
        MemorySegment srcWseg = MemorySegment.ofArray(byteArr);
        KllDoublesSketch sk3 = KllDoublesSketch.wrap((MemorySegment)srcWseg);
        Assert.assertTrue((boolean)(sk3 instanceof KllDirectDoublesSketch));
        KllDirectCompactDoublesSketchTest.println(sk3.toString(true, false));
        Assert.assertFalse((boolean)sk3.isReadOnly());
        sk3.update(22.0);
        Assert.assertEquals((double)sk3.getMinItem(), (double)1.0);
        Assert.assertEquals((double)sk3.getMaxItem(), (double)22.0);
    }

    @Test
    public void checkRODirectCompact() {
        int k = 20;
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 21; ++i) {
            sk.update((double)i);
        }
        MemorySegment srcSeg = MemorySegment.ofArray(sk.toByteArray());
        KllDoublesSketch sk2 = KllDoublesSketch.wrap((MemorySegment)srcSeg);
        Assert.assertTrue((boolean)sk2.isCompactMemorySegmentFormat());
        Assert.assertFalse((boolean)sk2.isMemorySegmentUpdatableFormat());
        Assert.assertTrue((boolean)sk2.isReadOnly());
        Assert.assertEquals((double)sk2.getMinItem(), (double)1.0);
        Assert.assertEquals((double)sk2.getMaxItem(), (double)21.0);
        MemorySegment srcSeg2 = MemorySegment.ofArray(sk2.toByteArray());
        KllDoublesSketch sk3 = KllDoublesSketch.wrap((MemorySegment)srcSeg2);
        Assert.assertTrue((boolean)sk3.isCompactMemorySegmentFormat());
        Assert.assertFalse((boolean)sk2.isMemorySegmentUpdatableFormat());
        Assert.assertTrue((boolean)sk3.isReadOnly());
        Assert.assertEquals((double)sk3.getMinItem(), (double)1.0);
        Assert.assertEquals((double)sk3.getMaxItem(), (double)21.0);
    }

    @Test
    public void checkDirectCompactSingleItem() {
        int k = 20;
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)20);
        sk.update(1.0);
        KllDoublesSketch sk2 = KllDoublesSketch.wrap((MemorySegment)MemorySegment.ofArray(sk.toByteArray()));
        Assert.assertTrue((boolean)sk2.isCompactMemorySegmentFormat());
        Assert.assertTrue((boolean)sk2.isReadOnly());
        Assert.assertEquals((double)sk2.getDoubleSingleItem(), (double)1.0);
        sk.update(2.0);
        sk2 = KllDoublesSketch.wrap((MemorySegment)MemorySegment.ofArray(sk.toByteArray()));
        Assert.assertEquals((long)sk2.getN(), (long)2L);
        try {
            sk2.getDoubleSingleItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkDirectCompactGetDoubleItemsArray() {
        int i;
        int k = 20;
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)20);
        KllDoublesSketch sk2 = KllDoublesSketch.wrap((MemorySegment)MemorySegment.ofArray(sk.toByteArray()));
        double[] itemsArr = sk2.getDoubleItemsArray();
        for (i = 0; i < 20; ++i) {
            Assert.assertEquals((double)itemsArr[i], (double)0.0);
        }
        sk.update(1.0);
        sk2 = KllDoublesSketch.wrap((MemorySegment)MemorySegment.ofArray(sk.toByteArray()));
        itemsArr = sk2.getDoubleItemsArray();
        for (i = 0; i < 19; ++i) {
            Assert.assertEquals((double)itemsArr[i], (double)0.0);
        }
        Assert.assertEquals((double)itemsArr[19], (double)1.0);
        for (i = 2; i <= 21; ++i) {
            sk.update((double)i);
        }
        sk2 = KllDoublesSketch.wrap((MemorySegment)MemorySegment.ofArray(sk.toByteArray()));
        itemsArr = sk2.getDoubleItemsArray();
        Assert.assertEquals((int)itemsArr.length, (int)33);
        Assert.assertEquals((double)itemsArr[22], (double)21.0);
    }

    @Test
    public void checkHeapAndDirectCompactGetRetainedItemsArray() {
        int k = 20;
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)20);
        double[] retArr = sk.getDoubleRetainedItemsArray();
        Assert.assertEquals((int)retArr.length, (int)0);
        KllDoublesSketch sk2 = KllDoublesSketch.wrap((MemorySegment)MemorySegment.ofArray(sk.toByteArray()));
        retArr = sk2.getDoubleRetainedItemsArray();
        Assert.assertEquals((int)retArr.length, (int)sk.getNumRetained());
        Assert.assertEquals((int)retArr.length, (int)0);
        sk.update(1.0);
        retArr = sk.getDoubleRetainedItemsArray();
        Assert.assertEquals((int)retArr.length, (int)sk.getNumRetained());
        Assert.assertEquals((int)retArr.length, (int)1);
        Assert.assertEquals((double)retArr[0], (double)1.0);
        sk2 = KllDoublesSketch.wrap((MemorySegment)MemorySegment.ofArray(sk.toByteArray()));
        retArr = sk2.getDoubleRetainedItemsArray();
        Assert.assertEquals((int)retArr.length, (int)sk.getNumRetained());
        Assert.assertEquals((int)retArr.length, (int)1);
        Assert.assertEquals((double)retArr[0], (double)1.0);
        for (int i = 2; i <= 21; ++i) {
            sk.update((double)i);
        }
        retArr = sk.getDoubleRetainedItemsArray();
        Assert.assertEquals((int)retArr.length, (int)sk.getNumRetained());
        Assert.assertEquals((int)retArr.length, (int)11);
        sk2 = KllDoublesSketch.wrap((MemorySegment)MemorySegment.ofArray(sk.toByteArray()));
        Assert.assertEquals((int)retArr.length, (int)sk2.getNumRetained());
        Assert.assertEquals((int)retArr.length, (int)11);
    }

    @Test
    public void checkMinAndMax() {
        int k = 20;
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)20);
        KllDoublesSketch sk2 = KllDoublesSketch.wrap((MemorySegment)MemorySegment.ofArray(sk.toByteArray()));
        try {
            sk2.getMinItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk2.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        sk.update(1.0);
        sk2 = KllDoublesSketch.wrap((MemorySegment)MemorySegment.ofArray(sk.toByteArray()));
        Assert.assertEquals((double)sk2.getMaxItem(), (double)1.0);
        Assert.assertEquals((double)sk2.getMinItem(), (double)1.0);
        for (int i = 2; i <= 21; ++i) {
            sk.update((double)i);
        }
        sk2 = KllDoublesSketch.wrap((MemorySegment)MemorySegment.ofArray(sk.toByteArray()));
        Assert.assertEquals((double)sk2.getMaxItem(), (double)21.0);
        Assert.assertEquals((double)sk2.getMinItem(), (double)1.0);
    }

    @Test
    public void checkQuantile() {
        KllDoublesSketch sk1 = KllDoublesSketch.newHeapInstance();
        for (int i = 1; i <= 1000; ++i) {
            sk1.update((double)i);
        }
        KllDoublesSketch sk2 = KllDoublesSketch.wrap((MemorySegment)MemorySegment.ofArray(sk1.toByteArray()));
        double med2 = sk2.getQuantile(0.5);
        double med1 = sk1.getQuantile(0.5);
        Assert.assertEquals((double)med1, (double)med2);
        KllDirectCompactDoublesSketchTest.println("Med1: " + med1);
        KllDirectCompactDoublesSketchTest.println("Med2: " + med2);
    }

    @Test
    public void checkCompactSingleItemMerge() {
        int k = 20;
        KllDoublesSketch skH1 = KllDoublesSketch.newHeapInstance((int)20);
        skH1.update(21.0);
        KllDoublesSketch skDC1 = KllDoublesSketch.wrap((MemorySegment)MemorySegment.ofArray(skH1.toByteArray()));
        KllDoublesSketch skH20 = KllDoublesSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 20; ++i) {
            skH20.update((double)i);
        }
        skH20.merge((KllSketch)skDC1);
        Assert.assertEquals((long)skH20.getN(), (long)21L);
        MemorySegment wseg = MemorySegment.ofArray(new byte[1000]);
        KllDoublesSketch skDU20 = KllDoublesSketch.newDirectInstance((int)20, (MemorySegment)wseg, null);
        for (int i = 1; i <= 20; ++i) {
            skDU20.update((double)i);
        }
        skDU20.merge((KllSketch)skDC1);
        Assert.assertEquals((long)skDU20.getN(), (long)21L);
    }

    @Test
    public void printlnTest() {
        KllDirectCompactDoublesSketchTest.println("PRINTING: " + this.getClass().getName());
    }

    private static final void println(Object o) {
    }
}

