/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllLongsSketch;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.DefaultMemoryRequestServer;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.quantilescommon.QuantilesLongsSketchIterator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class KllDirectLongsSketchIteratorTest {
    private static final DefaultMemoryRequestServer memReqSvr = new DefaultMemoryRequestServer();

    @Test
    public void emptySketch() {
        KllLongsSketch sketch = KllDirectLongsSketchIteratorTest.getDLSketch(200, 0);
        QuantilesLongsSketchIterator it = sketch.iterator();
        Assert.assertFalse((boolean)it.next());
    }

    @Test
    public void oneItemSketch() {
        KllLongsSketch sketch = KllDirectLongsSketchIteratorTest.getDLSketch(200, 0);
        sketch.update(0L);
        QuantilesLongsSketchIterator it = sketch.iterator();
        Assert.assertTrue((boolean)it.next());
        Assert.assertEquals((long)it.getQuantile(), (long)0L);
        Assert.assertEquals((long)it.getWeight(), (long)1L);
        Assert.assertFalse((boolean)it.next());
    }

    @Test
    public void bigSketches() {
        for (int n = 1000; n < 100000; n += 2000) {
            KllLongsSketch sketch = KllDirectLongsSketchIteratorTest.getDLSketch(200, 0);
            for (int i = 0; i < n; ++i) {
                sketch.update((long)i);
            }
            QuantilesLongsSketchIterator it = sketch.iterator();
            int count = 0;
            int weight = 0;
            while (it.next()) {
                ++count;
                weight += (int)it.getWeight();
            }
            Assert.assertEquals((int)count, (int)sketch.getNumRetained());
            Assert.assertEquals((int)weight, (int)n);
        }
    }

    private static KllLongsSketch getDLSketch(int k, int n) {
        KllLongsSketch sk = KllLongsSketch.newHeapInstance((int)k);
        for (int i = 1; i <= n; ++i) {
            sk.update((long)i);
        }
        byte[] byteArr = KllHelper.toByteArray((KllSketch)sk, (boolean)true);
        WritableMemory wmem = WritableMemory.writableWrap((byte[])byteArr);
        KllLongsSketch dlsk = KllLongsSketch.writableWrap((WritableMemory)wmem, (MemoryRequestServer)memReqSvr);
        return dlsk;
    }
}

