/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.elab;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.elab.SequenceEvaluator;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.MemoClosure;
import net.sf.saxon.value.SingletonClosure;

public class MemoClosureEvaluator
implements SequenceEvaluator {
    final Expression input;
    final PullEvaluator inputEvaluator;
    final boolean singleton;

    public MemoClosureEvaluator(Expression input, PullEvaluator inputEvaluator) {
        this.input = input;
        this.inputEvaluator = inputEvaluator;
        this.singleton = !Cardinality.allowsMany(input.getCardinality());
    }

    @Override
    public Sequence evaluate(XPathContext context) throws XPathException {
        try {
            return this.singleton ? new SingletonClosure(this.input, this.inputEvaluator, context) : new MemoClosure(this.input, this.inputEvaluator, context);
        }
        catch (UncheckedXPathException e) {
            throw e.getXPathException();
        }
    }
}

