/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver.catalog.query;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.xmlresolver.CatalogManager;
import org.xmlresolver.ResolverFeature;
import org.xmlresolver.catalog.entry.Entry;
import org.xmlresolver.catalog.entry.EntryCatalog;
import org.xmlresolver.catalog.entry.EntryDelegateUri;
import org.xmlresolver.catalog.entry.EntryRewriteUri;
import org.xmlresolver.catalog.entry.EntryUri;
import org.xmlresolver.catalog.entry.EntryUriSuffix;
import org.xmlresolver.catalog.query.QueryCatalog;
import org.xmlresolver.catalog.query.QueryDelegateUri;
import org.xmlresolver.catalog.query.QueryResult;
import org.xmlresolver.logging.ResolverLogger;

public class QueryUri
extends QueryCatalog {
    public final String uri;
    public final String nature;
    public final String purpose;

    public QueryUri(String uri, String nature, String purpose) {
        this.uri = uri;
        this.nature = nature;
        this.purpose = purpose;
    }

    public QueryUri(String uri) {
        this.uri = uri;
        this.nature = null;
        this.purpose = null;
    }

    @Override
    protected QueryResult lookup(CatalogManager manager, EntryCatalog catalog) {
        String compareUri = manager.normalizedForComparison(this.uri);
        String compareNature = manager.normalizedForComparison(this.nature);
        String comparePurpose = manager.normalizedForComparison(this.purpose);
        for (Entry raw : catalog.entries(Entry.Type.URI)) {
            EntryUri entry = (EntryUri)raw;
            if (!compareUri.equals(manager.normalizedForComparison(entry.name)) || this.nature != null && entry.nature != null && !compareNature.equals(manager.normalizedForComparison(entry.nature)) || this.purpose != null && entry.purpose != null && !comparePurpose.equals(manager.normalizedForComparison(entry.purpose))) continue;
            return new QueryResult(entry.uri);
        }
        EntryRewriteUri rewrite = null;
        String rewriteStart = null;
        for (Entry raw : catalog.entries(Entry.Type.REWRITE_URI)) {
            EntryRewriteUri entry = (EntryRewriteUri)raw;
            String string = manager.normalizedForComparison(entry.uriStart);
            if (!compareUri.startsWith(string) || rewrite != null && string.length() <= rewriteStart.length()) continue;
            rewrite = entry;
            rewriteStart = string;
        }
        if (rewrite != null) {
            try {
                URI resolved = new URI(rewrite.rewritePrefix.toString() + compareUri.substring(rewriteStart.length()));
                return new QueryResult(resolved);
            }
            catch (URISyntaxException ex) {
                ResolverLogger logger = manager.getResolverConfiguration().getFeature(ResolverFeature.RESOLVER_LOGGER);
                logger.debug("Invalid URI syntax resolving rewriteUri: " + ex.getMessage());
                return null;
            }
        }
        EntryUriSuffix suffix = null;
        String uriSuffix = null;
        for (Entry entry : catalog.entries(Entry.Type.URI_SUFFIX)) {
            EntryUriSuffix entry2 = (EntryUriSuffix)entry;
            String compareSuffix = manager.normalizedForComparison(entry2.uriSuffix);
            if (!compareUri.endsWith(compareSuffix) || suffix != null && compareSuffix.length() <= uriSuffix.length()) continue;
            suffix = entry2;
            uriSuffix = compareSuffix;
        }
        if (suffix != null) {
            return new QueryResult(suffix.uri);
        }
        ArrayList<EntryDelegateUri> delegated = new ArrayList<EntryDelegateUri>();
        for (Entry raw : catalog.entries(Entry.Type.DELEGATE_URI)) {
            int pos;
            EntryDelegateUri entry = (EntryDelegateUri)raw;
            String delegateStart = manager.normalizedForComparison(entry.uriStart);
            if (!compareUri.startsWith(delegateStart)) continue;
            for (pos = 0; pos < delegated.size() && delegateStart.length() <= manager.normalizedForComparison(((EntryDelegateUri)delegated.get((int)pos)).uriStart).length(); ++pos) {
            }
            delegated.add(pos, entry);
        }
        if (!delegated.isEmpty()) {
            ArrayList<URI> arrayList = new ArrayList<URI>();
            for (EntryDelegateUri entry : delegated) {
                arrayList.add(entry.catalog);
            }
            return new QueryDelegateUri(this.uri, this.nature, this.purpose, arrayList);
        }
        return QueryResult.EMPTY_RESULT;
    }
}

